/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.model.IF;

import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.model.device.DeviceEvent;
import ch.rakudave.jnetmap.net.Subnet;
import ch.rakudave.jnetmap.net.status.IsReachable;
import ch.rakudave.jnetmap.net.status.PingMethod;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.LinkedList;

@XStreamAlias(value="PhysicalIF")
public class PhysicalIF
implements NetworkIF {
    private InetAddress address;
    private InetAddress gateway;
    private Subnet subnet;
    private String name = "";
    private String macAddress;
    private Device device;
    private Connection connection;
    private PingMethod method;
    private Status status;
    private Date lastSeen;
    private LinkedList<Tuple<Date, Status>> statusHistory;
    private long latency;
    private boolean ignore;

    public PhysicalIF() {
    }

    public PhysicalIF(Device parent, Connection connection, String addr) {
        this(parent, connection, addr, "", IsReachable.getInstance());
    }

    public PhysicalIF(Device parent, Connection connection, String addr, PingMethod m) {
        this(parent, connection, addr, "", m);
    }

    public PhysicalIF(Device parent, Connection connection, String macAddress, String addr) {
        this(parent, connection, addr, macAddress, IsReachable.getInstance());
    }

    public PhysicalIF(Device parent, Connection connection, String addr, String macAddress, PingMethod m) {
        this.device = parent;
        this.connection = connection;
        this.setAddress(addr);
        this.setMacAddress(macAddress);
        this.setPingMethod(m);
        this.status = Status.UNKNOWN;
        this.name = "eth" + (parent.getInterfaces() != null ? parent.getInterfaces().size() : 0);
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public String getCanonicalName() {
        return this.address.getCanonicalHostName();
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public InetAddress getGateway() {
        return this.gateway;
    }

    @Override
    public Date getLastSeen() {
        return this.lastSeen;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Subnet getSubnet() {
        return this.subnet;
    }

    @Override
    public boolean setAddress(String addr) {
        try {
            this.address = InetAddress.getByName(addr);
            return true;
        }
        catch (UnknownHostException e) {
            this.status = Status.NOT_FOUND;
            Logger.warn("Address not found: " + addr);
            return false;
        }
    }

    @Override
    public boolean setGateway(String gateway) {
        try {
            this.gateway = InetAddress.getByName(gateway);
            return true;
        }
        catch (UnknownHostException e) {
            Logger.warn("Gateway not found: " + gateway);
            return false;
        }
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public void setPingMethod(PingMethod m) {
        if (m != null) {
            this.method = m;
        }
    }

    @Override
    public boolean setSubnet(String subnet) {
        if (subnet == null || subnet.isEmpty()) {
            return false;
        }
        if (!subnet.contains(".")) {
            try {
                this.subnet = new Subnet(subnet);
            }
            catch (Exception e) {
                Logger.warn("Invalid CIDR-format for subnet " + subnet);
                return false;
            }
        }
        try {
            this.subnet = new Subnet(this.address.getHostAddress(), subnet);
        }
        catch (Exception e) {
            Logger.warn("Address undefined or Subnet not found: " + subnet);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name + ": " + this.address.getHostAddress();
    }

    @Override
    public String toHtmlString() {
        return "<span style=\"color: " + this.getStatus().getHtmlValue() + "\">" + this.toString() + "</span>";
    }

    @Override
    public void updateStatus() {
        long millis = System.currentTimeMillis();
        Status newStatus = this.method.getStatus(this.address);
        this.latency = System.currentTimeMillis() - millis;
        this.connection.setStatus(this, newStatus);
        if (this.address != null) {
            this.connection.setLatency(this.latency);
        }
        if (this.status != newStatus) {
            Date now;
            this.status = newStatus;
            this.lastSeen = now = new Date(millis);
            this.putInStatusHistory(now, newStatus);
            if (!this.ignore) {
                this.device.notifyListeners(new DeviceEvent(this.device, DeviceEvent.Type.INTERFACE_STATUS_CHANGED, this));
            }
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public PingMethod getPingMethod() {
        return this.method;
    }

    @Override
    public LinkedList<Tuple<Date, Status>> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new LinkedList();
        }
        return this.statusHistory;
    }

    private void putInStatusHistory(Date date, Status status) {
        if (this.statusHistory == null) {
            this.statusHistory = new LinkedList();
        }
        if (!(status == null || this.statusHistory.size() != 0 && status.equals((Object)this.statusHistory.getLast().getSecond()))) {
            this.statusHistory.add(new Tuple<Date, Status>(date, status));
            if (this.statusHistory.size() > Settings.getInt("device.history.maxsize", 20)) {
                this.statusHistory.removeFirst();
            }
        }
    }

    @Override
    public void addStatusUnknownToHistory() {
        this.putInStatusHistory(new Date(System.currentTimeMillis()), Status.UNKNOWN);
    }

    @Override
    public long getLatency() {
        return this.latency;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setGateway(InetAddress gateway) {
        this.gateway = gateway;
    }

    public void setSubnet(Subnet subnet) {
        this.subnet = subnet;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }
}

