/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.LibraPoolEntry;
import com.pnf.libravm.LibraUnit;
import com.pnf.libravm.ModuleHandle;
import com.pnf.libravm.StringEntry;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
class StructHandle
extends LibraPoolEntry {
    @SerId(value=1)
    private int modulehandle_index;
    @SerId(value=2)
    private int name_index;
    @SerId(value=3)
    private boolean is_resource;

    public StructHandle(int modulehandle_index, int name_index, boolean is_resource) {
        this.modulehandle_index = modulehandle_index;
        this.name_index = name_index;
        this.is_resource = is_resource;
    }

    public boolean isResource() {
        return this.is_resource;
    }

    public ModuleHandle getModule(LibraUnit l) {
        return (ModuleHandle)l.moduleHandles.get(this.modulehandle_index);
    }

    public String getName(LibraUnit l) {
        return ((StringEntry)l.stringPool.get(this.name_index)).get();
    }

    public String getFullName(LibraUnit l) {
        String s = ((StringEntry)l.stringPool.get(this.name_index)).get();
        s = s + "@";
        s = s + ((ModuleHandle)l.moduleHandles.get(this.modulehandle_index)).getFullName(l);
        return s;
    }

    @Override
    public TextBuilder format(LibraUnit l, TextBuilder t) {
        if (this.is_resource) {
            t.append((Object)"resource ");
        }
        ((StringEntry)l.stringPool.get(this.name_index)).format(l, t);
        t.append((Object)"@");
        ((ModuleHandle)l.moduleHandles.get(this.modulehandle_index)).format(l, t);
        return t;
    }
}

