/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.FieldDef;
import com.pnf.libravm.LibraPoolEntry;
import com.pnf.libravm.LibraUnit;
import com.pnf.libravm.StructHandle;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
class StructDef
extends LibraPoolEntry {
    @SerId(value=1)
    private int structhandle_index;
    @SerId(value=2)
    private int field_count;
    @SerId(value=3)
    private int fields_index;

    public StructDef(int structhandle_index, int field_count, int fields_index) {
        this.structhandle_index = structhandle_index;
        this.field_count = field_count;
        this.fields_index = fields_index;
    }

    public int getHandleIndex() {
        return this.structhandle_index;
    }

    public StructHandle getHandle(LibraUnit l) {
        return (StructHandle)l.structHandles.get(this.structhandle_index);
    }

    public String getName(LibraUnit l) {
        return this.getHandle(l).getName(l);
    }

    public int getFieldCount() {
        return this.field_count;
    }

    public List<FieldDef> getFields(LibraUnit l) {
        ArrayList<FieldDef> r = new ArrayList<FieldDef>(this.field_count);
        for (int i = 0; i < this.field_count; ++i) {
            r.add((FieldDef)l.fieldDefs.get(this.fields_index + i));
        }
        return r;
    }

    @Override
    public TextBuilder format(LibraUnit l, TextBuilder t) {
        ((StructHandle)l.structHandles.get(this.structhandle_index)).format(l, t);
        t.append((Object)" { ");
        for (int i = 0; i < this.field_count; ++i) {
            if (i > 0) {
                t.append((Object)", ");
            }
            ((FieldDef)l.fieldDefs.get(this.fields_index + i)).format(l, t);
        }
        t.append((Object)" }");
        return t;
    }
}

