/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.AddressEntry;
import com.pnf.libravm.BytearrayEntry;
import com.pnf.libravm.FieldDef;
import com.pnf.libravm.FunctionDef;
import com.pnf.libravm.FunctionHandle;
import com.pnf.libravm.LibraInstruction;
import com.pnf.libravm.LibraInstructionOperand;
import com.pnf.libravm.LibraUnit;
import com.pnf.libravm.StringEntry;
import com.pnf.libravm.StructDef;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.render.GenericCodeFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.render.NumberFormatter;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public class LibraCodeFormatter
extends GenericCodeFormatter<LibraInstruction> {
    public LibraCodeFormatter() {
        this.setMnemonicRightPaddingLength(0);
    }

    public String generateExtraMethodComment(long address) {
        LibraUnit libra = (LibraUnit)this.getCodeUnit().getParent();
        FunctionDef f = libra.getFunctionByAddress(address);
        if (f == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Libra signature: %s / ", libra.formatObject(f.getHandle(libra).getSignature(libra))));
        sb.append(String.format("Locals: %s", libra.formatObject(f.getCode().getLocals(libra))));
        return sb.toString();
    }

    public void formatInstruction(long address, IInstruction insn, CodeDocumentPart out) {
        LibraInstruction _insn = (LibraInstruction)insn;
        String p = String.format("[%d,%d] ", _insn.preExecStackDelta, _insn.postExecStackDelta);
        out.appendAndRecord(p, ItemClassIdentifiers.COMMENT);
        out.append("  ");
        super.formatInstruction(address, insn, out);
    }

    public void formatOperand(long address, IInstruction insn, IInstructionOperand opnd, int opndIndexGlobal, int opndDepth, CodeDocumentPart out) {
        LibraUnit libra = (LibraUnit)this.getCodeUnit().getParent();
        LibraInstruction _insn = (LibraInstruction)insn;
        LibraInstructionOperand _opnd = (LibraInstructionOperand)opnd;
        Object o = _opnd.getObject();
        switch (_opnd.getOperandType()) {
            case Branch: {
                long targetAddress = address + (long)_insn.targetDelta;
                this.formatAddress(targetAddress, out);
                break;
            }
            case ImmUint64: {
                long val = (Long)o;
                NumberFormatter prefs = this.getNumberFormatter(opnd, false);
                if (prefs == null) {
                    prefs = this.getDefaultNumberFormatter();
                }
                String s = prefs.format(64, val);
                out.appendAndRecord(s, ItemClassIdentifiers.IMMEDIATE, this.createItemIdForImmediate(address, opndIndexGlobal));
                break;
            }
            case IdxLocal: {
                out.append("@" + _opnd.getObject());
                break;
            }
            case IdxAddress: {
                out.append(((AddressEntry)libra.addressPool.get((Integer)o)).toString());
                break;
            }
            case IdxByteArray: {
                out.append(((BytearrayEntry)libra.bytearrayPool.get((Integer)o)).toString());
                break;
            }
            case IdxString: {
                String str = ((StringEntry)libra.stringPool.get((Integer)o)).toString();
                out.appendAndRecord(Formatter.escapeString((CharSequence)str), ItemClassIdentifiers.STRING);
                break;
            }
            case IdxFieldDef: {
                out.append(((FieldDef)libra.fieldDefs.get((Integer)o)).getName(libra));
                break;
            }
            case IdxFuncHandle: {
                out.append(((FunctionHandle)libra.functionHandles.get((Integer)o)).getName(libra));
                break;
            }
            case IdxStructDef: {
                out.append(((StructDef)libra.structDefs.get((Integer)o)).getName(libra));
                break;
            }
            default: {
                out.append(opnd.format(insn, address));
            }
        }
    }
}

