/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnfsoftware.jeb.util.base.Assert;

public class Libra {
    public static final int ADDRESS_LENGTH = 32;
    public static final int PUBLIC = 1;
    public static final int NATIVE = 2;

    public static String formatFunctionFlags(int flags) {
        String s = "";
        while (flags != 0) {
            if ((flags & 1) != 0) {
                s = s + "public ";
                flags &= 0xFFFFFFFE;
                continue;
            }
            if ((flags & 2) != 0) {
                s = s + "native ";
                flags &= 0xFFFFFFFD;
                continue;
            }
            s = s + String.format("(0x%X) ", flags);
            flags = 0;
        }
        return s.trim();
    }

    static enum OpcodeDef {
        POP(1, 1, 0),
        RET(2, -1, 0),
        BR_TRUE(3, 1, 0, OpndType.Branch),
        BR_FALSE(4, 1, 0, OpndType.Branch),
        BRANCH(5, 0, 0, OpndType.Branch),
        LD_CONST(6, 0, 1, OpndType.ImmUint64),
        LD_ADDR(7, 0, 1, OpndType.IdxAddress),
        LD_STR(8, 0, 1, OpndType.IdxString),
        LD_TRUE(9, 0, 1),
        LD_FALSE(10, 0, 1),
        COPY_LOC(11, 0, 1, OpndType.IdxLocal, "Push the local identified by `LocalIndex` onto the stack. The value is copied and the local is still safe to use"),
        MOVE_LOC(12, 0, 1, OpndType.IdxLocal, "Push the local identified by `LocalIndex` onto the stack. The local is moved and it is invalid to use from that point on, unless a store operation writes to the local before any read to that local"),
        ST_LOC(13, 1, 0, OpndType.IdxLocal),
        LD_REF_LOC(14, 0, 1, OpndType.IdxLocal),
        LD_REF_FIELD(15, 1, 1, OpndType.IdxFieldDef),
        LD_BYTEARRAY(16, 0, 1, OpndType.IdxByteArray),
        CALL(17, -1, -1, OpndType.IdxFuncHandle),
        PACK(18, -1, 1, OpndType.IdxStructDef),
        UNPACK(19, 1, -1, OpndType.IdxStructDef),
        READ_REF(20, 1, 1),
        WRITE_REF(21, 2, 0),
        ADD(22, 2, 1),
        SUB(23, 2, 1),
        MUL(24, 2, 1),
        MOD(25, 2, 1),
        DIV(26, 2, 1),
        BIT_OR(27, 2, 1),
        BIT_AND(28, 2, 1),
        XOR(29, 2, 1),
        OR(30, 2, 1),
        AND(31, 2, 1),
        NOT(32, 1, 1),
        EQ(33, 2, 1),
        NEQ(34, 2, 1),
        LT(35, 2, 1),
        GT(36, 2, 1),
        LE(37, 2, 1),
        GE(38, 2, 1),
        ASSERT(39, 2, 0),
        GET_TXN_GAS_UNIT_PRICE(40, 0, 1),
        GET_TXN_MAX_GAS_UNITS(41, 0, 1),
        GET_GAS_REMAINING(42, 0, 1),
        GET_TXN_SENDER(43, 0, 1),
        EXISTS(44, 1, 1, OpndType.IdxStructDef),
        BORROW_REF(45, 1, 1, OpndType.IdxStructDef),
        RELEASE_REF(46, 1, 0),
        MOVE_FROM(47, 1, 1, OpndType.IdxStructDef),
        MOVE_TO(48, 1, 0, OpndType.IdxStructDef),
        CREATE_ACCOUNT(49, 1, 0),
        EMIT_EVENT(50, 3, 0),
        GET_TXN_SEQUENCE_NUMBER(51, 0, 1),
        GET_TXN_PUBLIC_KEY(52, 0, 1),
        FREEZE_REF(53, 1, 1);

        int v;
        int popcnt;
        int pushcnt;
        OpndType opndtype;
        String docstr;

        private OpcodeDef(int v, int popcnt, int pushcnt) {
            this(v, popcnt, pushcnt, OpndType.None);
        }

        private OpcodeDef(int v, int popcnt, int pushcnt, OpndType opndtype) {
            this(v, popcnt, pushcnt, opndtype, null);
        }

        private OpcodeDef(int v, int popcnt, int pushcnt, String docstr) {
            this(v, popcnt, pushcnt, OpndType.None, docstr);
        }

        private OpcodeDef(int v, int popcnt, int pushcnt, OpndType opndtype, String docstr) {
            this.v = v;
            this.popcnt = popcnt;
            this.pushcnt = pushcnt;
            this.opndtype = opndtype;
            this.docstr = docstr;
        }

        public int getOpcode() {
            return this.v;
        }

        public int getPopCount() {
            return this.popcnt;
        }

        public int getPushCount() {
            return this.pushcnt;
        }

        public OpndType getOperandType() {
            return this.opndtype;
        }

        public String getDocString() {
            return this.docstr;
        }

        public static OpcodeDef fromValue(int opcode) {
            if (opcode < 1 || opcode > 53) {
                throw new RuntimeException("Unknown opcode: " + opcode);
            }
            OpcodeDef op = OpcodeDef.values()[opcode - 1];
            Assert.a((op.v == opcode ? 1 : 0) != 0);
            return op;
        }

        public String getLLMnemonic() {
            return this.toString();
        }

        public boolean isBinaryOperation() {
            switch (this) {
                case ADD: 
                case SUB: 
                case MUL: 
                case MOD: 
                case DIV: 
                case BIT_OR: 
                case BIT_AND: 
                case XOR: {
                    return true;
                }
            }
            return false;
        }

        public boolean isLogicalOperation() {
            switch (this) {
                case NOT: 
                case OR: 
                case AND: 
                case EQ: 
                case NEQ: 
                case LT: 
                case GT: 
                case LE: 
                case GE: {
                    return true;
                }
            }
            return false;
        }

        public String getHLMnemonic() {
            switch (this) {
                case LD_REF_LOC: {
                    return "BorrowLoc";
                }
                case LD_REF_FIELD: {
                    return "BorrowField";
                }
                case BORROW_REF: {
                    return "BorrowGlobal";
                }
                case MOVE_TO: {
                    return "MoveToSender";
                }
            }
            String s = "";
            for (String elt : this.getLLMnemonic().split("_")) {
                s = s + elt.charAt(0) + elt.substring(1).toLowerCase();
            }
            return s;
        }
    }

    static enum OpndType {
        None,
        Branch,
        ImmUint64,
        IdxLocal,
        IdxAddress,
        IdxByteArray,
        IdxString,
        IdxFuncHandle,
        IdxStructDef,
        IdxFieldDef;

    }

    static enum SerializedType {
        BOOL(1),
        INTEGER(2),
        STRING(3),
        ADDRESS(4),
        REFERENCE(5),
        MUTABLE_REFERENCE(6),
        STRUCT(7),
        BYTEARRAY(8);

        int value;

        private SerializedType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this) {
                case REFERENCE: {
                    return "&";
                }
                case MUTABLE_REFERENCE: {
                    return "&mut";
                }
                case STRUCT: {
                    return "struct";
                }
            }
            return super.toString().toLowerCase();
        }

        public static SerializedType fromValue(int value) {
            for (SerializedType t : SerializedType.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new RuntimeException("Unknown value: " + value);
        }
    }

    static enum SignatureType {
        TYPE_SIGNATURE(1),
        FUNCTION_SIGNATURE(2),
        LOCAL_SIGNATURE(3);

        int value;

        private SignatureType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SignatureType fromValue(int value) {
            for (SignatureType t : SignatureType.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new RuntimeException("Unknown value: " + value);
        }
    }

    static enum TableType {
        MODULE_HANDLES(1),
        STRUCT_HANDLES(2),
        FUNCTION_HANDLES(3),
        ADDRESS_POOL(4),
        STRING_POOL(5),
        BYTE_ARRAY_POOL(6),
        MAIN(7, 2),
        STRUCT_DEFS(8, 1),
        FIELD_DEFS(9, 1),
        FUNCTION_DEFS(10, 1),
        TYPE_SIGNATURES(11),
        FUNCTION_SIGNATURES(12),
        LOCALS_SIGNATURES(13);

        int value;
        int usage;

        private TableType(int value) {
            this(value, 0);
        }

        private TableType(int value, int usage) {
            this.value = value;
            this.usage = usage;
        }

        public int getValue() {
            return this.value;
        }

        public int getUsage() {
            return this.usage;
        }

        public static TableType fromValue(int value) {
            for (TableType t : TableType.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new RuntimeException("Unknown value: " + value);
        }
    }

    static enum BinaryType {
        MODULE,
        SCRIPT;

    }
}

