/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.LibraPoolEntry;
import com.pnf.libravm.LibraUnit;
import com.pnf.libravm.SignatureToken;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.List;

@Ser
class FunctionSignature
extends LibraPoolEntry {
    @SerId(value=1)
    private List<SignatureToken> returnTokens;
    @SerId(value=2)
    private List<SignatureToken> paramTokens;

    public FunctionSignature(List<SignatureToken> returnTokens, List<SignatureToken> paramTokens) {
        this.returnTokens = returnTokens;
        this.paramTokens = paramTokens;
    }

    public List<SignatureToken> getReturnTokens() {
        return this.returnTokens;
    }

    public List<SignatureToken> getParamTokens() {
        return this.paramTokens;
    }

    public String toString() {
        return this.paramTokens.toString() + ": " + this.returnTokens.toString();
    }

    @Override
    public TextBuilder format(LibraUnit l, TextBuilder t) {
        t.append((Object)"(");
        int i = 0;
        for (SignatureToken token : this.paramTokens) {
            if (i > 0) {
                t.append((Object)", ");
            }
            token.format(l, t);
            ++i;
        }
        t.append((Object)"): (");
        i = 0;
        for (SignatureToken token : this.returnTokens) {
            if (i > 0) {
                t.append((Object)", ");
            }
            token.format(l, t);
            ++i;
        }
        t.append((Object)")");
        return t;
    }
}

