/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.pnf.plugin.pdf.filter.PDFObject;
import com.pnf.plugin.pdf.parser.PdfFilterException;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.sun.pdfview.PDFParseException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class ASCIIHexDecode {
    private ByteBuffer buf;

    private ASCIIHexDecode(ByteBuffer buf) {
        this.buf = buf;
    }

    private int readHexDigit() throws PDFParseException {
        while (this.buf.remaining() > 0) {
            int c = this.buf.get();
            if (PdfSpecialCharacters.isSeparator((byte)c)) continue;
            if (c >= 48 && c <= 57) {
                c -= 48;
            } else if (c >= 97 && c <= 102) {
                c -= 87;
            } else if (c >= 65 && c <= 70) {
                c -= 55;
            } else if (c == 62) {
                c = -1;
            } else {
                throw new PDFParseException("Bad character " + c + "in ASCIIHex decode");
            }
            return c;
        }
        return -1;
    }

    private ByteBuffer decode() throws PdfFilterException {
        this.buf.rewind();
        int bufSize = this.buf.remaining();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            while (true) {
                int first = this.readHexDigit();
                int second = this.readHexDigit();
                if (first == -1) break;
                if (second == -1) {
                    baos.write((byte)(first << 4));
                    break;
                }
                baos.write((byte)((first << 4) + second));
            }
        }
        catch (PDFParseException e) {
            throw new PdfFilterException(e, baos, bufSize - this.buf.remaining());
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    public static ByteBuffer decode(ByteBuffer buf, PDFObject params) throws PdfFilterException {
        ASCIIHexDecode me = new ASCIIHexDecode(buf);
        return me.decode();
    }
}

