/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import java.util.HashMap;
import java.util.Map;

@Ser
public class PdfString
extends AbstractPdfParsableAttribute {
    private static final Map<Character, Character> escapedCharacters = new HashMap<Character, Character>();
    @SerId(value=1)
    private String value;
    @SerId(value=2)
    private String decryptedValue;

    public PdfString(AbstractPdfParsableAttribute parent, int startIndex) {
        super(parent, startIndex);
    }

    public String getValue() {
        return this.value;
    }

    public String getDecryptedValue() {
        return this.decryptedValue;
    }

    @Override
    public int parse(byte[] data, int cursor) {
        boolean isHexa = false;
        int intermediateParenthesis = 0;
        if (data[cursor] == 60) {
            isHexa = true;
        }
        int startLine = ++cursor;
        StringBuilder stb = new StringBuilder();
        while (cursor < data.length && !this.isEndToken(data, cursor, isHexa, intermediateParenthesis)) {
            if (!isHexa) {
                if (data[cursor] == 92) {
                    int endLine = PdfSpecialCharacters.testEndLine(data, cursor + 1);
                    if (endLine != 0) {
                        if (endLine > 0) {
                            cursor += endLine;
                        } else {
                            Character c = escapedCharacters.get(Character.valueOf((char)data[cursor + 1]));
                            if (c != null) {
                                stb.append(c);
                                ++cursor;
                            } else if (Character.isDigit(data[cursor + 1])) {
                                int nbDigit;
                                for (nbDigit = 1; cursor + nbDigit < data.length && nbDigit < 3 && Character.isDigit(data[cursor + nbDigit + 1]); ++nbDigit) {
                                }
                                if (nbDigit == 3) {
                                    stb.append((char)Integer.valueOf(new String(data, cursor + 1, nbDigit), 8).byteValue());
                                    cursor += nbDigit;
                                }
                            }
                        }
                    }
                } else if (data[cursor] == 40) {
                    ++intermediateParenthesis;
                } else if (data[cursor] == 41) {
                    --intermediateParenthesis;
                } else {
                    stb.append((char)data[cursor]);
                }
            }
            ++cursor;
        }
        if (cursor >= data.length) {
            this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.Malformed, "Unclosed string");
        }
        this.setEndIndex(cursor);
        this.value = isHexa ? this.decodeHexa(data, startLine, cursor) : stb.toString();
        return cursor;
    }

    private String decodeHexa(byte[] data, int fromIndex, int toIndex) {
        StringBuilder dataWitoutSpace = new StringBuilder();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (PdfSpecialCharacters.isSeparator(data[i])) continue;
            dataWitoutSpace.append((char)data[i]);
        }
        if (dataWitoutSpace.length() % 2 == 1) {
            dataWitoutSpace.append('0');
        }
        String hexaString = dataWitoutSpace.toString();
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < hexaString.length(); i += 2) {
            try {
                String str = hexaString.substring(i, i + 2);
                stb.append((char)Integer.parseInt(str, 16));
                continue;
            }
            catch (Exception e) {
                this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.Malformed, "Incorrect String format", e);
                return '<' + new String(data, fromIndex, toIndex - fromIndex) + '>';
            }
        }
        return stb.toString();
    }

    public String toString() {
        return this.decryptedValue == null ? this.value : this.decryptedValue;
    }

    public static boolean isStartToken(byte[] data, int cursor) {
        return data[cursor] == 40 || data[cursor] == 60 && data[cursor + 1] != 60;
    }

    public boolean isEndToken(byte[] data, int cursor, boolean isHexa, int intermediateParenthesis) {
        return !isHexa && data[cursor] == 41 && intermediateParenthesis == 0 || isHexa && data[cursor] == 62;
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.String;
    }

    public void decrypt(PDFDecrypter decrypter) {
        try {
            this.decryptedValue = decrypter.decryptString(this.getId().getObjectNumber(), this.getId().getGenerationNumber(), this.value);
        }
        catch (PDFParseException e) {
            e.printStackTrace();
            this.getMainParent().getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.StreamUnfiltered, "Can not unencrypt String", e);
        }
    }

    static {
        escapedCharacters.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapedCharacters.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapedCharacters.put(Character.valueOf('t'), Character.valueOf('\t'));
        escapedCharacters.put(Character.valueOf('b'), Character.valueOf('\b'));
        escapedCharacters.put(Character.valueOf('f'), Character.valueOf('\u00ff'));
        escapedCharacters.put(Character.valueOf('('), Character.valueOf('('));
        escapedCharacters.put(Character.valueOf(')'), Character.valueOf(')'));
        escapedCharacters.put(Character.valueOf('\\'), Character.valueOf('\\'));
    }
}

