/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf;

import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.statistics.PdfUnitNotification;
import com.pnf.plugin.pdf.unit.IPdfUnit;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.core.units.IUnitNotificationManager;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@Ser
public class PdfStatistics
implements IUnitNotificationManager {
    private static final ILogger logger = GlobalLog.getLogger(PdfStatistics.class);
    public static boolean BATCH_MODE = false;
    @SerId(value=1)
    private int nbIndirectObjects = 0;
    @SerId(value=2)
    private int nbStreamedObjects = 0;
    @SerId(value=3)
    private int nbStreams = 0;
    @SerId(value=4)
    private Map<PdfIndirectObj, Map<IPdfAttribute, List<IUnitNotification>>> anomalies = new TreeMap<PdfIndirectObj, Map<IPdfAttribute, List<IUnitNotification>>>();
    @SerId(value=5)
    private Set<String> filtersUsed = new TreeSet<String>();
    @SerId(value=6)
    private Map<String, Integer> tokens = new HashMap<String, Integer>();
    @SerId(value=7)
    private boolean isEncrypted = false;
    @SerId(value=8)
    private boolean userPasswordRequired = false;
    @SerId(value=9)
    private IPdfUnit unit;
    @SerId(value=10)
    private String version = "";

    protected PdfStatistics(IPdfUnit unit) {
        this.unit = unit;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public int getNbIndirectObjects() {
        return this.nbIndirectObjects;
    }

    public void setNbIndirectObjects(int nbIndirectObjects) {
        this.nbIndirectObjects = nbIndirectObjects;
    }

    public int getNbStreamedObjects() {
        return this.nbStreamedObjects;
    }

    public void setNbStreamedObjects(int nbStreamedObjects) {
        this.nbStreamedObjects = nbStreamedObjects;
    }

    public int getNbStreams() {
        return this.nbStreams;
    }

    public void setNbStreams(int nbStreams) {
        this.nbStreams = nbStreams;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isUserPasswordRequired() {
        return this.userPasswordRequired;
    }

    public void setEncrypted(boolean isEncrypted) {
        logger.info("Pdf trailer defines Encryption: Trying to decode", new Object[0]);
        this.setEncrypted(isEncrypted, false);
    }

    public void setEncrypted(boolean isEncrypted, boolean requiresUserPassword) {
        this.isEncrypted |= isEncrypted;
        this.userPasswordRequired |= requiresUserPassword;
    }

    public Set<String> getFiltersUsed() {
        return this.filtersUsed;
    }

    public void addFiltersUsed(String filter) {
        this.filtersUsed.add(filter);
    }

    public Map<IPdfAttribute, List<IUnitNotification>> getAnomalies(PdfIndirectObj obj) {
        return this.anomalies.get(obj);
    }

    public Set<PdfIndirectObj> anomalyKeys() {
        return this.anomalies.keySet();
    }

    public void addUnitNotification(IPdfAttribute element, SuspiciousType suspicious) {
        this.addUnitNotification(element, suspicious, null, null);
    }

    public void addUnitNotification(IPdfAttribute element, SuspiciousType suspicious, String description) {
        this.addUnitNotification(element, suspicious, description, null);
    }

    public void addUnitNotification(IPdfAttribute element, SuspiciousType suspicious, String description, Throwable e) {
        this.addUnitNotification(element, suspicious, description, e, false);
    }

    public void addUnitNotification(IPdfAttribute element, SuspiciousType suspicious, String description, Throwable e, boolean dropSameLevel) {
        if (element.getParent() == null) {
            this.addUnitNotification(element, (PdfIndirectObj)element, suspicious, description, dropSameLevel);
        } else {
            this.addUnitNotification(element, element.getParent().getMainParent(), suspicious, description, dropSameLevel);
        }
    }

    private void addUnitNotification(IPdfAttribute element, PdfIndirectObj parent, SuspiciousType suspicious, String description, boolean dropSameLevel) {
        List<IUnitNotification> anomaliesByElement;
        Map<IPdfAttribute, List<IUnitNotification>> anomaliesByChild = this.anomalies.get(parent);
        if (anomaliesByChild == null) {
            anomaliesByChild = new HashMap<IPdfAttribute, List<IUnitNotification>>();
            this.anomalies.put(parent, anomaliesByChild);
        }
        if ((anomaliesByElement = anomaliesByChild.get(element)) == null) {
            anomaliesByElement = new ArrayList<IUnitNotification>();
            anomaliesByChild.put(element, anomaliesByElement);
        }
        NotificationType notificationType = this.getNotificationType(suspicious);
        AbstractPdfParsableAttribute parentElement = element.getParent();
        ArrayList<IUnitNotification> duplicates = new ArrayList<IUnitNotification>();
        for (Map.Entry<IPdfAttribute, List<IUnitNotification>> entry : anomaliesByChild.entrySet()) {
            for (IUnitNotification notification : entry.getValue()) {
                IPdfAttribute notificationElement;
                if (notification.getType() != notificationType || !notification.getDescription().equals(description) || (notificationElement = ((PdfUnitNotification)notification).getElement()) != element && notificationElement != parentElement && notificationElement.getParent() != element && notificationElement.getParent() != parentElement) continue;
                duplicates.add(notification);
            }
            if (dropSameLevel) {
                entry.getValue().removeAll(duplicates);
                continue;
            }
            if (duplicates.isEmpty()) continue;
            return;
        }
        anomaliesByElement.add(this.getUnitNotification(element, suspicious, description));
    }

    private IUnitNotification getUnitNotification(IPdfAttribute element, SuspiciousType suspicious, String description) {
        if (suspicious == SuspiciousType.PotentialHarmfulToken) {
            this.addToken(element);
        }
        return new PdfUnitNotification(this.getNotificationType(suspicious), this.getDescription(element, suspicious, description), element, this.unit);
    }

    private NotificationType getNotificationType(SuspiciousType suspicious) {
        switch (suspicious) {
            case Malformed: 
            case MalformedStream: {
                return NotificationType.CORRUPTION;
            }
            case StreamUnfiltered: {
                return NotificationType.UNSUPPORTED_FEATURE;
            }
            case StreamWithMultipleFilters: {
                return NotificationType.AREA_OF_INTEREST;
            }
            case PotentialHarmfulToken: 
            case PotentialHarmfulFile: {
                return NotificationType.POTENTIALLY_HARMFUL;
            }
        }
        return NotificationType.AREA_OF_INTEREST;
    }

    private void addToken(IPdfAttribute element) {
        Integer t = this.tokens.get(element.toString());
        if (t == null) {
            t = 0;
        }
        t = t + 1;
        this.tokens.put(element.toString(), t);
    }

    private String getDescription(IPdfAttribute element, SuspiciousType suspicious, String description) {
        if (!(description == null || suspicious == SuspiciousType.StreamUnfiltered && description.equals("Encrypted"))) {
            if (!BATCH_MODE || suspicious != SuspiciousType.PotentialHarmfulToken && suspicious != SuspiciousType.StreamWithMultipleFilters) {
                logger.error("%s: %s in %s", new Object[]{suspicious, description, element.getId()});
            }
            return description;
        }
        return suspicious.toString();
    }

    public String toStringTokens() {
        StringBuilder stb = new StringBuilder();
        for (Map.Entry<String, Integer> t : this.tokens.entrySet()) {
            stb.append("\nToken '").append(t.getKey()).append("' found ").append(t.getValue()).append(" time");
            if (t.getValue() <= 1) continue;
            stb.append('s');
        }
        return stb.toString();
    }

    public String toStringCorruptions() {
        StringBuilder stb = new StringBuilder();
        for (Map.Entry<PdfIndirectObj, Map<IPdfAttribute, List<IUnitNotification>>> entry : this.anomalies.entrySet()) {
            for (Map.Entry<IPdfAttribute, List<IUnitNotification>> entryAttr : entry.getValue().entrySet()) {
                String corruptions = PdfStatistics.toString(entryAttr.getValue(), NotificationType.CORRUPTION);
                if (corruptions.isEmpty()) continue;
                stb.append("\n--- in ").append(entry.getKey().getId()).append(":").append(corruptions);
            }
        }
        if (stb.length() > 0) {
            stb.insert(0, "\n\nPdf File has corruptions:");
        }
        return stb.toString();
    }

    public String toStringAnomalies() {
        StringBuilder stb = new StringBuilder();
        for (Map.Entry<PdfIndirectObj, Map<IPdfAttribute, List<IUnitNotification>>> entry : this.anomalies.entrySet()) {
            stb.append("\n- Notifications in ").append(entry.getKey().getId());
            for (Map.Entry<IPdfAttribute, List<IUnitNotification>> entryAttr : entry.getValue().entrySet()) {
                stb.append("\n--- in ").append(entryAttr.getKey().toString()).append(":").append(PdfStatistics.toString(entryAttr.getValue(), null));
            }
            stb.append("\n");
        }
        return stb.toString();
    }

    public static String toString(List<IUnitNotification> notifications) {
        return PdfStatistics.toString(notifications, null);
    }

    public static String toString(List<IUnitNotification> notifications, NotificationType filter) {
        TreeSet<String> notifStr = new TreeSet<String>();
        for (IUnitNotification n : notifications) {
            if (filter != null) {
                if (n.getType() != filter) continue;
                notifStr.add(n.getDescription());
                continue;
            }
            notifStr.add(n.getDescription());
        }
        return Strings.join((String)", ", notifStr);
    }

    public List<IUnitNotification> getNotifications() {
        Collection<Map<IPdfAttribute, List<IUnitNotification>>> anomaliesPerAttr = this.anomalies.values();
        ArrayList<IUnitNotification> notifications = new ArrayList<IUnitNotification>();
        for (Map<IPdfAttribute, List<IUnitNotification>> ano : anomaliesPerAttr) {
            Collection<List<IUnitNotification>> anomaliesList = ano.values();
            for (List<IUnitNotification> a : anomaliesList) {
                notifications.addAll(a);
            }
        }
        return notifications;
    }

    public IUnitNotification getNotification(String key) {
        Collection<Map<IPdfAttribute, List<IUnitNotification>>> anomaliesPerAttr = this.anomalies.values();
        for (Map<IPdfAttribute, List<IUnitNotification>> ano : anomaliesPerAttr) {
            Collection<List<IUnitNotification>> anomaliesList = ano.values();
            for (List<IUnitNotification> a : anomaliesList) {
                for (IUnitNotification n : a) {
                    if (n.getKey() == null || !n.getKey().equals(key)) continue;
                    return n;
                }
            }
        }
        return null;
    }

    public int getNotificationCount() {
        return this.getNotifications().size();
    }

    public void addNotification(IUnitNotification notification) {
        throw new UnsupportedOperationException("A notification must be bound to a PDF Indirect Object");
    }

    public void addNotifications(Collection<? extends IUnitNotification> arg0) {
        throw new UnsupportedOperationException("A notification must be bound to a PDF Indirect Object");
    }

    public boolean removeNotification(String key) {
        throw new UnsupportedOperationException("A notification must be bound to a PDF Indirect Object");
    }

    public static enum SuspiciousType {
        Malformed,
        StreamWithMultipleFilters,
        PotentialHarmfulToken,
        StreamUnfiltered,
        MalformedStream,
        PotentialHarmfulFile;

    }
}

