/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IFileOverwriteDecider;
import com.pnfsoftware.jeb.installer.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUnpacker {
    ZipFile zipfile;
    String basedir;
    String skipPrefix;
    List<String> errorpaths = new ArrayList<String>();
    List<Record> records = new ArrayList<Record>();
    IFileOverwriteDecider fileOverwriteDecider;

    public ZipUnpacker(ZipFile zipfile, String basedir) {
        this.zipfile = zipfile;
        this.basedir = basedir;
    }

    public List<String> getErrorPaths() {
        return this.errorpaths;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setSkipPrefix(String skipPrefix) {
        this.skipPrefix = skipPrefix;
    }

    public void setFileOverwriteDecider(IFileOverwriteDecider fileOverwriteDecider) {
        this.fileOverwriteDecider = fileOverwriteDecider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzip() {
        Enumeration<? extends ZipEntry> all = this.zipfile.entries();
        while (all.hasMoreElements()) {
            ZipEntry entry = all.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (this.skipPrefix != null && name != null && !name.startsWith(this.skipPrefix)) continue;
            InputStream in = null;
            try {
                in = this.zipfile.getInputStream(entry);
                this.extractEntry(in, name);
            }
            catch (IOException e) {
                Logger.logd(e);
                this.errorpaths.add(name);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    Logger.logd(e);
                }
            }
        }
        return this.errorpaths.isEmpty();
    }

    private byte[] readInputStream(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[131072];
        while ((n = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, n);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private void extractEntry(InputStream in, String name) throws IOException {
        byte[] data = this.readInputStream(in);
        this.writeEntry(name, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeEntry(String name, byte[] data, boolean createDirs) {
        File parent;
        File file = new File(this.basedir, name);
        if (createDirs && (parent = file.getAbsoluteFile().getParentFile()) != null) {
            parent.mkdirs();
        }
        int resultcode = 1;
        if (file.exists() && file.isFile()) {
            resultcode = 2;
            if (this.fileOverwriteDecider != null && !this.fileOverwriteDecider.isOverwriteAllowed(file, name, data)) {
                this.records.add(new Record(name, 3));
                return true;
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(data);
            this.records.add(new Record(name, resultcode));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logger.logd(e);
            this.records.add(new Record(name, -resultcode));
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    Logger.logd(e);
                }
            }
        }
    }

    public static class Record {
        private String name;
        private int code;

        Record(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }
}

