/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnf.androsig.apply.model.ISignatureFile;
import com.pnf.androsig.apply.model.LibraryInfo;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SignatureFile
implements ISignatureFile {
    private static final ILogger logger = GlobalLog.getLogger(SignatureFile.class);
    private Map<String, List<MethodSignature>> allTightSignatures = new HashMap<String, List<MethodSignature>>();
    private Map<String, List<MethodSignature>> allLooseSignatures = new HashMap<String, List<MethodSignature>>();
    private Map<String, List<MethodSignature>> allSignaturesByClassname = new HashMap<String, List<MethodSignature>>();
    private Map<String, List<MethodSignature>> allMetaByClassname = new HashMap<String, List<MethodSignature>>();
    private LibraryInfo libraryInfos;
    private int allSignatureCount = 0;

    public boolean loadSignatures(File sigFile) {
        if (this.libraryInfos != null) {
            throw new RuntimeException("Can only load one signature file");
        }
        int version = 0;
        String libname = "Unknown library code";
        String author = "Unknown author";
        List lines = IO.readLinesSafe((File)sigFile, (Charset)Charset.forName("UTF-8"));
        if (lines == null) {
            return false;
        }
        this.libraryInfos = new LibraryInfo();
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith(";")) {
                String value = this.checkMarker(line = line.substring(1), "version");
                if (value != null) {
                    version = Conversion.stringToInt((String)value);
                    this.libraryInfos.setVersion(version);
                }
                if ((value = this.checkMarker(line, "libname")) != null) {
                    libname = value;
                    this.libraryInfos.setLibName(libname);
                }
                if ((value = this.checkMarker(line, "author")) == null) continue;
                author = value;
                this.libraryInfos.setAuthor(author);
                continue;
            }
            MethodSignature ml = MethodSignature.parse(line);
            if (ml == null) {
                ml = MethodSignature.parse(line, false);
                if (ml == null) {
                    logger.warn("Invalid signature line: %s", new Object[]{line});
                    continue;
                }
                boolean found = false;
                for (MethodSignature method : this.allMetaByClassname.get(ml.getCname())) {
                    if (!MethodSignature.equalsMethodSig(method, ml)) continue;
                    method.addRevision(ml.getOwnRevision());
                    found = true;
                    break;
                }
                if (!found) {
                    SignatureFile.saveValue(this.allMetaByClassname, ml.getCname(), ml);
                }
            }
            this.storeMethodHash(ml);
            ++this.allSignatureCount;
        }
        return true;
    }

    private String checkMarker(String line, String marker) {
        if (line.startsWith(marker + "=")) {
            return line.substring(marker.length() + 1).trim();
        }
        return null;
    }

    private void storeMethodHash(MethodSignature sig) {
        String tight = sig.getOwnRevision().getMhash_tight();
        String loose = sig.getOwnRevision().getMhash_loose();
        boolean found = false;
        for (MethodSignature method : this.allSignaturesByClassname.get(sig.getCname())) {
            if (!MethodSignature.equalsMethodSig(method, sig)) continue;
            method.addRevision(sig.getOwnRevision());
            sig = method;
            found = true;
            break;
        }
        if (!found || !this.contains(this.allTightSignatures.get(tight), sig)) {
            SignatureFile.saveValue(this.allTightSignatures, tight, sig);
        }
        if (!found || !this.contains(this.allLooseSignatures.get(loose), sig)) {
            SignatureFile.saveValue(this.allLooseSignatures, loose, sig);
        }
        if (!found) {
            SignatureFile.saveValue(this.allSignaturesByClassname, sig.getCname(), sig);
        }
    }

    private boolean contains(List<MethodSignature> list, MethodSignature sig) {
        return list != null && list.contains(sig);
    }

    private static void saveValue(Map<String, List<MethodSignature>> map, String key, MethodSignature value) {
        List<MethodSignature> val = map.get(key);
        if (val == null) {
            val = new ArrayList<MethodSignature>();
            map.put(key, val);
        }
        val.add(value);
    }

    @Deprecated
    public Map<String, List<MethodSignature>> getAllTightSignatures() {
        return this.allTightSignatures;
    }

    @Override
    public List<MethodSignature> getTightSignatures(String hashcode) {
        return this.allTightSignatures.get(hashcode);
    }

    public long getTightSignaturesSize() {
        return this.allTightSignatures.size();
    }

    public long getSignaturesSize() {
        long sz = 0L;
        for (List<MethodSignature> e : this.getAllTightSignatures().values()) {
            sz += (long)e.size();
        }
        return sz;
    }

    @Override
    public List<MethodSignature> getLooseSignatures(String hashcode) {
        return this.allLooseSignatures.get(hashcode);
    }

    public long getLooseSignaturesSize() {
        return this.allLooseSignatures.size();
    }

    @Deprecated
    public Map<String, List<MethodSignature>> getAllLooseSignatures() {
        return this.allLooseSignatures;
    }

    @Override
    public LibraryInfo getLibraryInfos() {
        return this.libraryInfos;
    }

    @Override
    public int getAllSignatureCount() {
        return this.allSignatureCount;
    }

    @Override
    public boolean hasSignaturesForClassname(String className) {
        return this.allSignaturesByClassname.containsKey(className);
    }

    @Override
    public List<MethodSignature> getSignaturesForClassname(String className, boolean exactName) {
        ArrayList<MethodSignature> compatibleSignatures = new ArrayList<MethodSignature>();
        if (exactName) {
            List<MethodSignature> list = this.allSignaturesByClassname.get(className);
            if (list != null) {
                compatibleSignatures.addAll(list);
            }
            return compatibleSignatures;
        }
        for (Map.Entry<String, List<MethodSignature>> entry : this.allSignaturesByClassname.entrySet()) {
            if (!entry.getKey().startsWith(className)) continue;
            compatibleSignatures.addAll((Collection<MethodSignature>)entry.getValue());
        }
        return compatibleSignatures;
    }

    @Override
    public List<MethodSignature> getParent(String className) {
        List<MethodSignature> compatibleSignatures = new ArrayList<MethodSignature>();
        List<MethodSignature> list = this.allMetaByClassname.get(className);
        if (list != null) {
            compatibleSignatures.addAll(list);
            compatibleSignatures = compatibleSignatures.stream().filter(m -> m.getMname().equals("<parent>")).collect(Collectors.toList());
        }
        return compatibleSignatures;
    }

    public static boolean populate(File sigFile, Map<String, Set<String>> allTightHashcodes, Map<String, Set<String>> allLooseHashcodes, Map<String, Set<String>> allClasses) {
        List lines = IO.readLinesSafe((File)sigFile, (Charset)Charset.forName("UTF-8"));
        if (lines == null) {
            return false;
        }
        for (String line : lines) {
            String className;
            String mhash_loose;
            if (!MethodSignature.isSignatureLine(line = line.trim())) continue;
            String[] subLines = MethodSignature.parseNative(line);
            if (subLines == null) {
                logger.warn("Invalid parameter signature line: " + line + " in file " + sigFile, new Object[0]);
                continue;
            }
            String mhash_tight = MethodSignature.getTightSignature(subLines);
            if (mhash_tight != null && !mhash_tight.isEmpty()) {
                Set<String> files = allTightHashcodes.get(mhash_tight);
                if (files == null) {
                    files = new LinkedHashSet<String>();
                    allTightHashcodes.put(mhash_tight, files);
                }
                files.add(sigFile.getAbsolutePath());
            }
            if ((mhash_loose = MethodSignature.getLooseSignature(subLines)) != null && !mhash_loose.isEmpty()) {
                Set<String> files = allLooseHashcodes.get(mhash_loose);
                if (files == null) {
                    files = new LinkedHashSet<String>();
                    allLooseHashcodes.put(mhash_loose, files);
                }
                files.add(sigFile.getAbsolutePath());
            }
            if ((className = MethodSignature.getClassname(subLines)) == null || className.isEmpty()) continue;
            Set<String> files = allClasses.get(className);
            if (files == null) {
                files = new LinkedHashSet<String>();
                allClasses.put(className, files);
            }
            files.add(sigFile.getAbsolutePath());
        }
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

