/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.model.ISignatureFile;
import com.pnf.androsig.apply.model.LibraryInfo;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnf.androsig.apply.model.SignatureFileFactory;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatabaseReference {
    private final ILogger logger = GlobalLog.getLogger(DatabaseReference.class);
    private Map<String, Set<String>> allTightHashcodes = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> allLooseHashcodes = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> allClasses = new HashMap<String, Set<String>>();
    private SignatureFileFactory signatureFileFactory = new SignatureFileFactory();
    private int allSignatureFileCount = 0;

    public void loadAllHashCodes(File sigFolder) {
        this.logger.info("Hashcodes loading start...", new Object[0]);
        long startTime = System.currentTimeMillis();
        this.loadAllHashCodesTemp(sigFolder);
        long endTime = System.currentTimeMillis();
        this.logger.info("Hashcodes loading completed! (Execution Time: " + (endTime - startTime) / 1000L + "s)", new Object[0]);
        this.logger.info("allTightHashcodes: " + this.allTightHashcodes.size(), new Object[0]);
        this.logger.info("allLooseHashcodes: " + this.allLooseHashcodes.size(), new Object[0]);
    }

    private void loadAllHashCodesTemp(File sigFolder) {
        Runtime rt = Runtime.getRuntime();
        long memused = rt.totalMemory() - rt.freeMemory();
        for (File f : sigFolder.listFiles()) {
            long newmemused;
            if (f.isFile() && f.getName().endsWith(".sig")) {
                ++this.allSignatureFileCount;
                if (!this.loadHashCodes(f)) {
                    this.logger.error("Cannot load signatures files: %s", new Object[]{f});
                }
            } else if (f.isDirectory()) {
                this.loadAllHashCodesTemp(f);
            }
            if ((newmemused = rt.totalMemory() - rt.freeMemory()) - memused <= 1000000000L) continue;
            System.gc();
            memused = rt.totalMemory() - rt.freeMemory();
        }
    }

    private boolean loadHashCodes(File sigFile) {
        return SignatureFileFactory.populate(sigFile, this.allTightHashcodes, this.allLooseHashcodes, this.allClasses);
    }

    public int getAllSignatureFileCount() {
        return this.allSignatureFileCount;
    }

    public List<String> getFilesContainingTightHashcode(String hashcode) {
        Set<String> res = this.allTightHashcodes.get(hashcode);
        return res == null ? null : new ArrayList<String>(res);
    }

    public List<String> getFilesContainingLooseHashcode(String hashcode) {
        Set<String> res = this.allLooseHashcodes.get(hashcode);
        return res == null ? null : new ArrayList<String>(res);
    }

    public List<String> getFilesContainingClass(String className) {
        Set<String> res = this.allClasses.get(className);
        return res == null ? null : new ArrayList<String>(res);
    }

    public List<MethodSignature> getSignatureLines(String file, String hashcode, boolean tight) {
        ISignatureFile sigFile = this.signatureFileFactory.getSignatureFile(file);
        return tight ? sigFile.getTightSignatures(hashcode) : sigFile.getLooseSignatures(hashcode);
    }

    public List<MethodSignature> getSignatureLines(DatabaseReferenceFile file, String hashcode, boolean tight) {
        List<MethodSignature> sigs = this.getSignatureLines(file.file, hashcode, tight);
        Set<String> versions = file.getAvailableVersions();
        return this.filterVersions(sigs, versions);
    }

    public List<MethodSignature> getSignaturesForClassname(String file, String className, boolean exactName) {
        ISignatureFile sigFile = this.signatureFileFactory.getSignatureFile(file);
        return sigFile.getSignaturesForClassname(className, exactName);
    }

    public List<MethodSignature> getSignaturesForClassname(DatabaseReferenceFile file, String className, boolean exactName) {
        List<MethodSignature> sigs = this.getSignaturesForClassname(file.file, className, exactName);
        Set<String> versions = file.getAvailableVersions();
        return this.filterVersions(sigs, versions);
    }

    private List<MethodSignature> filterVersions(List<MethodSignature> sigs, Set<String> versions) {
        if (sigs != null && versions != null && !versions.isEmpty()) {
            ArrayList<MethodSignature> versioned = new ArrayList<MethodSignature>();
            for (MethodSignature sig : sigs) {
                if (!this.intersect(versions, sig.getVersions())) continue;
                versioned.add(sig);
            }
            return versioned;
        }
        return sigs;
    }

    private boolean intersect(Set<String> versions, String[] versions2) {
        if (versions2 == null || versions2.length == 0 || versions == null || versions.size() == 0) {
            return true;
        }
        for (String v : versions2) {
            if (!versions.contains(v)) continue;
            return true;
        }
        return false;
    }

    public LibraryInfo getLibraryInfos(String file, String className) {
        ISignatureFile sigFile = this.signatureFileFactory.getSignatureFile(file);
        if (className != null && !sigFile.hasSignaturesForClassname(className)) {
            return null;
        }
        return sigFile.getLibraryInfos();
    }

    public Map<String, ISignatureFile> getLoadedSignatureFiles() {
        return this.signatureFileFactory.getLoadedSignatureFiles();
    }

    public void close() {
        this.signatureFileFactory.close();
    }

    public Couple<String, List<String>> getParentForClassname(String file, String className) {
        ISignatureFile sigFile = this.signatureFileFactory.getSignatureFile(file);
        List<MethodSignature> sigs = sigFile.getParent(className);
        if (sigs == null || sigs.size() != 1) {
            return null;
        }
        return new Couple((Object)sigs.get(0).getTargetSuperType(), sigs.get(0).getTargetInterfaces());
    }

    public Couple<String, List<String>> getParentForClassname(DatabaseReferenceFile refFile, String className) {
        ISignatureFile sigFile = this.signatureFileFactory.getSignatureFile(refFile.file);
        List<MethodSignature> rawSigs = sigFile.getParent(className);
        if (rawSigs == null || rawSigs.isEmpty()) {
            return null;
        }
        Set<String> versions = refFile.getAvailableVersions();
        List<MethodSignature> sigs = this.filterVersions(rawSigs, versions);
        if (sigs.size() != 1) {
            this.logger.warn("Parent of %s can not be found for current version", new Object[]{className});
            if (rawSigs.size() == 1) {
                sigs = rawSigs;
            } else {
                return null;
            }
        }
        MethodSignature sig = sigs.get(0);
        String parent = null;
        HashSet<String> interfaces = null;
        if (sig.getRevisions().size() == 1) {
            return new Couple((Object)sig.getTargetSuperType(), sig.getTargetInterfaces());
        }
        boolean firstFound = false;
        for (MethodSignature.MethodSignatureRevision rev : sig.getRevisions()) {
            List<String> altInterfaces;
            if (versions != null) {
                boolean found = false;
                for (String v : rev.getVersions()) {
                    if (!versions.contains(v)) continue;
                    found = true;
                }
                if (!found) continue;
            }
            if (!firstFound) {
                firstFound = true;
                parent = rev.getTargetSuperType();
                List<String> interfacesList = rev.getTargetInterfaces();
                interfaces = interfacesList == null ? new HashSet<String>() : new HashSet<String>(interfacesList);
                continue;
            }
            if (parent != null && !parent.equals(rev.getTargetSuperType())) {
                parent = null;
            }
            if (interfaces == null || (altInterfaces = rev.getTargetInterfaces()) == null) continue;
            interfaces.addAll(altInterfaces);
        }
        if (parent == null && interfaces == null) {
            return null;
        }
        return new Couple(parent, interfaces == null || interfaces.isEmpty() ? null : new ArrayList(interfaces));
    }

    public List<String> getClassList(String f) {
        ArrayList<String> classes = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> class_ : this.allClasses.entrySet()) {
            if (!class_.getValue().contains(f)) continue;
            classes.add(class_.getKey());
        }
        return classes;
    }
}

