/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.matcher;

import com.pnf.androsig.apply.matcher.DatabaseMatcherParameters;
import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.matcher.FileMatches;
import com.pnf.androsig.apply.matcher.IAndrosigModule;
import com.pnf.androsig.apply.matcher.IMatcherValidation;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.DexHashcodeList;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexPrototype;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MatchingSearch {
    private IDexUnit dex;
    private DexHashcodeList dexHashCodeList;
    private DatabaseReference ref;
    private DatabaseMatcherParameters params;
    private FileMatches fileMatches;
    private List<IAndrosigModule> modules;
    private boolean firstRound;
    private boolean firstPass;
    private Map<String, Map<String, InnerMatch>> fileCandidates = new HashMap<String, Map<String, InnerMatch>>();

    public MatchingSearch(IDexUnit dex, DexHashcodeList dexHashCodeList, DatabaseReference ref, DatabaseMatcherParameters params, FileMatches fileMatches, List<IAndrosigModule> modules, boolean firstRound, boolean firstPass) {
        this.dex = dex;
        this.dexHashCodeList = dexHashCodeList;
        this.ref = ref;
        this.params = params;
        this.fileMatches = fileMatches;
        this.modules = modules;
        this.firstRound = firstRound;
        this.firstPass = firstPass;
    }

    private List<MethodSignature> getInnerClassSignatureLines(DatabaseReferenceFile file, String mhash, boolean tight, String innerClass) {
        List<MethodSignature> sigLine = this.ref.getSignatureLines(file, mhash, tight);
        if (sigLine != null) {
            sigLine = sigLine.stream().filter(s -> s.getCname().startsWith(innerClass)).collect(Collectors.toList());
        }
        return sigLine;
    }

    public void processInnerClass(DatabaseReferenceFile file, IDexClass eClass, List<? extends IDexMethod> methods, String innerClass, int innerLevel, List<MethodSignature> compatibleSignatures) {
        for (IDexMethod iDexMethod : methods) {
            String mname;
            String mhash_tight;
            boolean instructionBarReached;
            if (!iDexMethod.isInternal()) continue;
            List instructions = iDexMethod.getInstructions();
            boolean bl = instructions == null ? false : (instructionBarReached = instructions.size() > this.params.methodSizeBar);
            if (!instructionBarReached) {
                instructionBarReached = !((ICodeType)eClass.getSupertypes().get(0)).getSignature(true).equals("Ljava/lang/Object;");
            }
            List<MethodSignature> sigLine = null;
            if (instructionBarReached && (mhash_tight = this.dexHashCodeList.getTightHashcode(iDexMethod)) != null) {
                sigLine = this.getInnerClassSignatureLines(file, mhash_tight, true, innerClass);
            }
            if (!this.firstRound) {
                String mhash_loose;
                if ((sigLine == null || sigLine.isEmpty()) && instructionBarReached && (mhash_loose = this.dexHashCodeList.getLooseHashcode(iDexMethod)) != null) {
                    sigLine = this.getInnerClassSignatureLines(file, mhash_loose, false, innerClass);
                }
                if (sigLine == null || sigLine.isEmpty()) {
                    IDexPrototype proto = this.dex.getPrototype(iDexMethod.getPrototypeIndex());
                    String prototypes = proto.generate(true);
                    String shorty = null;
                    sigLine = compatibleSignatures.stream().filter(s -> this.isCompatibleSignature((MethodSignature)s, SignatureCheck.PROTOTYPE_STRICT, shorty, prototypes, eMethod)).collect(Collectors.toList());
                    if (!this.isComplexSignature(prototypes)) {
                        String mname2 = iDexMethod.getName(true);
                        sigLine = sigLine.stream().filter(s -> s.getMname().equals(mname2) && !DexUtilLocal.isObjectInheritedMethod(s.getMname(), s.getPrototype())).collect(Collectors.toList());
                    }
                }
            }
            if (sigLine == null || sigLine.isEmpty() || (mname = this.fileMatches.getMatchedMethod(iDexMethod)) != null && (sigLine = sigLine.stream().filter(s -> mname.equals(s.getMname())).collect(Collectors.toList())).isEmpty()) continue;
            Map<String, InnerMatch> classes = this.fileCandidates.get(file.file);
            if (classes == null) {
                classes = new HashMap<String, InnerMatch>();
                this.fileCandidates.put(file.file, classes);
            }
            this.saveTemporaryCandidate(iDexMethod, sigLine, this.firstRound, classes, file.file, innerLevel);
        }
    }

    public boolean isComplexSignature(String prototypes) {
        String params1 = DexUtilLocal.extractParamsFromSignature(prototypes);
        List<String> paramList = DexUtilLocal.parseSignatureParameters(params1);
        if (paramList.isEmpty() || paramList.size() == 1 && paramList.get(0).length() == 1) {
            return false;
        }
        paramList.add(DexUtilLocal.extractReturnValueFromSignature(prototypes));
        int genericApiParams = 0;
        for (String param : paramList) {
            if (param.length() == 1) continue;
            if (DexUtilLocal.isAndroidPlatformClass(param) || DexUtilLocal.isJavaPlatformClass(param)) {
                ++genericApiParams;
            }
            return true;
        }
        return genericApiParams >= this.params.complexSignatureParams;
    }

    public boolean processClass(IMatcherValidation validation, IDexClass eClass, List<? extends IDexMethod> methods, int innerLevel) {
        List<String> validFiles = this.getValidFiles(validation, eClass, methods);
        return this.processClass(validation, eClass, methods, innerLevel, validFiles);
    }

    public boolean processClass(IMatcherValidation validation, IDexClass eClass, List<? extends IDexMethod> methods, int innerLevel, List<String> validFiles) {
        if (!this.firstRound && !this.firstPass && validFiles.size() > 1) {
            validFiles = new ArrayList<String>(CollectionUtil.intersect(validFiles, new ArrayList<String>(this.fileMatches.getSignatureFileUsed())));
        }
        if (validFiles.isEmpty() && !this.firstRound) {
            return false;
        }
        ArrayList<IDexMethod> easyMatches = new ArrayList<IDexMethod>();
        for (IDexMethod iDexMethod : methods) {
            String mhash_loose;
            String mhash_tight;
            List instructions;
            if (!iDexMethod.isInternal() || (instructions = iDexMethod.getInstructions()) == null || instructions.size() <= this.params.methodSizeBar || (mhash_tight = this.dexHashCodeList.getTightHashcode(iDexMethod)) == null) continue;
            List<String> candidateFiles = this.ref.getFilesContainingTightHashcode(mhash_tight);
            if (candidateFiles != null) {
                candidateFiles = new ArrayList<String>(CollectionUtil.intersect(validFiles, candidateFiles));
                if (this.firstRound && candidateFiles.size() > 10) {
                    easyMatches.add(iDexMethod);
                    continue;
                }
                for (String file : candidateFiles) {
                    List<MethodSignature> sigLines = this.fileMatches.getSignatureLines(this.ref, file, mhash_tight, true);
                    if (sigLines == null || sigLines.isEmpty()) continue;
                    sigLines = sigLines.stream().filter(s -> !this.fileMatches.containsMatchedClassValue(s.getCname())).collect(Collectors.toList());
                    String mname = this.fileMatches.getMatchedMethod(iDexMethod);
                    if (mname != null && (sigLines = sigLines.stream().filter(s -> mname.equals(s.getMname())).collect(Collectors.toList())).isEmpty()) continue;
                    Map<String, InnerMatch> classes = this.fileCandidates.get(file);
                    if (classes == null) {
                        classes = new HashMap<String, InnerMatch>();
                        this.fileCandidates.put(file, classes);
                    }
                    this.saveTemporaryCandidate(iDexMethod, sigLines, this.firstRound, classes, file, innerLevel);
                    if (!classes.isEmpty()) continue;
                    this.fileCandidates.remove(file);
                }
                continue;
            }
            if (this.firstRound || (mhash_loose = this.dexHashCodeList.getLooseHashcode(iDexMethod)) == null || (candidateFiles = this.ref.getFilesContainingLooseHashcode(mhash_loose)) == null) continue;
            for (String file : candidateFiles) {
                String mname;
                List<MethodSignature> sigLines;
                if (!validFiles.contains(file) || (sigLines = this.fileMatches.getSignatureLines(this.ref, file, mhash_loose, false)) == null || sigLines.isEmpty() || (mname = this.fileMatches.getMatchedMethod(iDexMethod)) != null && (sigLines = sigLines.stream().filter(s -> mname.equals(s.getMname())).collect(Collectors.toList())).isEmpty()) continue;
                Map<String, InnerMatch> classes = this.fileCandidates.get(file);
                if (classes == null) {
                    classes = new HashMap<String, InnerMatch>();
                    this.fileCandidates.put(file, classes);
                }
                this.saveTemporaryCandidate(iDexMethod, sigLines, this.firstRound, classes, file, innerLevel);
                if (!classes.isEmpty()) continue;
                this.fileCandidates.remove(file);
            }
        }
        return true;
    }

    private List<String> getValidFiles(IMatcherValidation validation, IDexClass eClass, List<? extends IDexMethod> methods) {
        HashMap<String, ArrayList<Integer>> methodsPerFile = new HashMap<String, ArrayList<Integer>>();
        HashMap methodsPerFileSmalls = new HashMap();
        for (IDexMethod iDexMethod : methods) {
            String mhash_tight;
            List instructions;
            if (!iDexMethod.isInternal() || (instructions = iDexMethod.getInstructions()) == null || (mhash_tight = this.dexHashCodeList.getTightHashcode(iDexMethod)) == null) continue;
            List<String> candidateFiles = this.ref.getFilesContainingTightHashcode(mhash_tight);
            if (candidateFiles == null && !this.firstRound) {
                String mhash_loose = this.dexHashCodeList.getLooseHashcode(iDexMethod);
                if (mhash_loose == null) continue;
                candidateFiles = this.ref.getFilesContainingLooseHashcode(mhash_loose);
            }
            if (candidateFiles == null || candidateFiles.isEmpty()) continue;
            HashMap<String, ArrayList<Integer>> indexMap = methodsPerFile;
            if (instructions.size() <= this.params.methodSizeBar) {
                indexMap = methodsPerFileSmalls;
            }
            for (String file : candidateFiles) {
                ArrayList<Integer> methodIds = (ArrayList<Integer>)indexMap.get(file);
                if (methodIds == null) {
                    methodIds = new ArrayList<Integer>();
                    indexMap.put(file, methodIds);
                }
                methodIds.add(iDexMethod.getIndex());
            }
        }
        ArrayList<String> validFiles = new ArrayList<String>();
        for (Map.Entry entry : methodsPerFile.entrySet()) {
            ArrayList<Integer> allMethodsMatch = new ArrayList<Integer>();
            allMethodsMatch.addAll((Collection)entry.getValue());
            List smalls = (List)methodsPerFileSmalls.get(entry.getKey());
            if (smalls != null) {
                allMethodsMatch.addAll(smalls);
            }
            if (this.firstRound && validation.f(this.dex, eClass, allMethodsMatch) != null) continue;
            validFiles.add((String)entry.getKey());
        }
        return validFiles;
    }

    private void saveTemporaryCandidate(IDexMethod eMethod, List<MethodSignature> elts, boolean firstRound, Map<String, InnerMatch> classes, String file, int innerLevel) {
        IDexPrototype proto = this.dex.getPrototype(eMethod.getPrototypeIndex());
        String shorty = proto.getShorty();
        String prototype = proto.generate(true);
        List<MethodSignature> realCandidates = elts.stream().filter(strArray -> this.isCompatibleSignature((MethodSignature)strArray, SignatureCheck.PROTOTYPE_COMPATIBLE, shorty, prototype, eMethod)).collect(Collectors.toList());
        if (!realCandidates.isEmpty()) {
            List<MethodSignature> strArrays = MatchingSearch.mergeSignaturesPerClass(realCandidates, eMethod);
            for (MethodSignature strArray2 : strArrays) {
                String className = strArray2.getCname();
                if (DexUtilLocal.getInnerClassLevel(className) != innerLevel) continue;
                InnerMatch inner = classes.get(className);
                if (inner == null) {
                    inner = new InnerMatch(className, file);
                }
                inner.addMethod(eMethod, strArray2);
                if (realCandidates.size() > 1) {
                    inner.doNotRenameIndexes.add(eMethod.getIndex());
                }
                classes.put(className, inner);
            }
        }
    }

    public List<MethodSignature> getSignaturesForClassname(DatabaseReferenceFile file, String className, boolean exactName, IDexMethod eMethod) {
        List<MethodSignature> sigs = this.ref.getSignaturesForClassname(file, className, true);
        List instructions = eMethod.getInstructions();
        sigs = sigs.stream().filter(s -> instructions == null ? s.isEmptyOp() : !s.isEmptyOp()).collect(Collectors.toList());
        return sigs;
    }

    public MethodSignature findMethodMatch(DatabaseReferenceFile file, String className, IDexMethod eMethod, String methodName) {
        IDexPrototype proto = this.dex.getPrototype(eMethod.getPrototypeIndex());
        String prototypes = proto.generate(true);
        List<MethodSignature> sigs = this.getSignaturesForClassname(file, className, true, eMethod);
        MethodSignature ms = this.findMethodName(sigs = sigs.stream().filter(s -> s.getMname().equals(methodName)).collect(Collectors.toList()), SignatureCheck.PROTOTYPE_STRICT, prototypes, null, className, new ArrayList<MethodSignature>(), eMethod);
        if (ms != null) {
            return ms;
        }
        String shorty = proto.getShorty();
        return this.findMethodName(sigs, SignatureCheck.PROTOTYPE_COMPATIBLE, prototypes, shorty, className, new ArrayList<MethodSignature>(), eMethod);
    }

    public MethodSignature findMethodMatch(DatabaseReferenceFile file, String classPath, Collection<MethodSignature> alreadyProcessedMethods, IDexMethod eMethod, boolean allowEmptyMName) {
        IDexPrototype proto = this.dex.getPrototype(eMethod.getPrototypeIndex());
        String prototypes = proto.generate(true);
        String shorty = proto.getShorty();
        String mhash_tight = this.dexHashCodeList.getTightHashcode(eMethod);
        if (mhash_tight == null) {
            return null;
        }
        return this.findMethodMatch(file, mhash_tight, prototypes, shorty, classPath, alreadyProcessedMethods, eMethod, allowEmptyMName);
    }

    public MethodSignature findMethodMatch(DatabaseReferenceFile file, String mhash_tight, String prototypes, String shorty, String classPath, Collection<MethodSignature> alreadyProcessedMethods, IDexMethod eMethod, boolean allowEmptyMName) {
        String mhash_loose;
        MethodSignature strArray = null;
        List<MethodSignature> sigs = this.ref.getSignatureLines(file, mhash_tight, true);
        if (sigs != null) {
            strArray = this.findMethodName(sigs, prototypes, shorty, classPath, alreadyProcessedMethods, eMethod);
        }
        if ((strArray == null || !allowEmptyMName && strArray.getMname().isEmpty()) && (sigs = this.ref.getSignatureLines(file, mhash_loose = this.dexHashCodeList.getLooseHashcode(eMethod), false)) != null) {
            strArray = this.findMethodName(sigs, prototypes, shorty, classPath, alreadyProcessedMethods, eMethod);
        }
        return strArray;
    }

    public MethodSignature findMethodName(List<MethodSignature> sigs, String classPath, Collection<MethodSignature> alreadyProcessedMethods, IDexMethod eMethod) {
        IDexPrototype proto = this.dex.getPrototype(eMethod.getPrototypeIndex());
        String prototypes = proto.generate(true);
        String shorty = proto.getShorty();
        return this.findMethodName(sigs, prototypes, shorty, classPath, alreadyProcessedMethods, eMethod);
    }

    public MethodSignature findMethodName(List<MethodSignature> sigs, String proto, String shorty, String classPath, Collection<MethodSignature> alreadyProcessedMethods, IDexMethod eMethod) {
        MethodSignature sig = this.findMethodName(sigs, SignatureCheck.PROTOTYPE_STRICT, proto, shorty, classPath, alreadyProcessedMethods, eMethod);
        if (sig != null) {
            return sig;
        }
        if (!this.firstRound && !this.firstPass) {
            return this.findMethodName(sigs, SignatureCheck.PROTOTYPE_COMPATIBLE, proto, shorty, classPath, alreadyProcessedMethods, eMethod);
        }
        return null;
    }

    private List<MethodSignature> findMethodNames(List<MethodSignature> sigs, SignatureCheck check, String prototypes, String shorty, String classPath, Collection<MethodSignature> alreadyProcessedMethods, IDexMethod eMethod) {
        ArrayList<MethodSignature> results = new ArrayList<MethodSignature>();
        for (MethodSignature strArray : sigs) {
            if (!strArray.getCname().equals(classPath) || !this.isCompatibleSignature(strArray, check, shorty, prototypes, eMethod) || MatchingSearch.isAlreadyProcessed(strArray, alreadyProcessedMethods, check == SignatureCheck.PROTOTYPE_STRICT, check != SignatureCheck.PROTOTYPE_STRICT)) continue;
            results.add(strArray);
        }
        return results;
    }

    private static boolean isAlreadyProcessed(MethodSignature strArray, Collection<MethodSignature> alreadyProcessedMethods, boolean checkPrototypes, boolean checkShorty) {
        for (MethodSignature alreadyProcessed : alreadyProcessedMethods) {
            if (!alreadyProcessed.getMname().equals(strArray.getMname()) || (!checkPrototypes || !alreadyProcessed.getPrototype().equals(strArray.getPrototype())) && (!checkShorty || !alreadyProcessed.getShorty().equals(strArray.getShorty()))) continue;
            return true;
        }
        return false;
    }

    private MethodSignature findMethodName(List<MethodSignature> sigs, SignatureCheck check, String prototypes, String shorty, String classPath, Collection<MethodSignature> alreadyProcessedMethods, IDexMethod eMethod) {
        List<MethodSignature> results = this.findMethodNames(sigs, check, prototypes, shorty, classPath, alreadyProcessedMethods, eMethod);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            this.filterList(eMethod, prototypes, results);
            if (results.size() == 1) {
                return results.get(0);
            }
            return MethodSignature.mergeSignatures(results, true, eMethod);
        }
        return null;
    }

    private boolean isCompatibleSignature(MethodSignature strArray, SignatureCheck check, String shorty, String prototypes, IDexMethod eMethod) {
        if (!this.isCompatibleSignature(strArray, check, shorty, prototypes)) {
            return false;
        }
        String methodName = eMethod.getName(true);
        if (check == SignatureCheck.PROTOTYPE_COMPATIBLE || check == SignatureCheck.PROTOTYPE_STRICT) {
            return DexUtilLocal.isMethodCompatibleWithSignatures(methodName, prototypes, strArray.getMname(), strArray.getPrototype());
        }
        return DexUtilLocal.isMethodCompatible(methodName, strArray.getMname());
    }

    private boolean isCompatibleSignature(MethodSignature strArray, SignatureCheck check, String shorty, String prototype) {
        switch (check) {
            case PROTOTYPE_STRICT: {
                return strArray.getPrototype().equals(prototype);
            }
            case SHORTY: {
                return strArray.getShorty().equals(shorty);
            }
            case PROTOTYPE_COMPATIBLE: {
                if (strArray.getPrototype().equals(prototype)) {
                    return true;
                }
                if (!strArray.getShorty().equals(shorty)) {
                    return false;
                }
                return this.isCompatiblePrototypeSignature(strArray, prototype);
            }
        }
        return false;
    }

    private boolean isCompatiblePrototypeSignature(MethodSignature strArray, String prototypes) {
        String originalReturnVal;
        String returnVal1 = prototypes.substring(prototypes.indexOf(")") + 1);
        if (!DexUtilLocal.isCompatibleClasses(returnVal1, originalReturnVal = strArray.getPrototype().substring(strArray.getPrototype().indexOf(")") + 1))) {
            return false;
        }
        String params1 = DexUtilLocal.extractParamsFromSignature(prototypes);
        String originalParams = DexUtilLocal.extractParamsFromSignature(strArray.getPrototype());
        List<String> paramList = DexUtilLocal.parseSignatureParameters(params1);
        List<String> originalParamList = DexUtilLocal.parseSignatureParameters(originalParams);
        for (int i = 0; i < paramList.size(); ++i) {
            String originalParamI;
            String paramI = paramList.get(i);
            if (paramI.equals(originalParamI = originalParamList.get(i))) continue;
            if (this.fileMatches.containsMatchedClassValue(paramI)) {
                return false;
            }
            if (DexUtilLocal.isCompatibleClasses(paramI, originalParamI)) continue;
            return false;
        }
        return true;
    }

    private void filterList(IDexMethod eMethod, String prototypes, List<MethodSignature> results) {
        for (IAndrosigModule module : this.modules) {
            Set<MethodSignature> filtered = module.filterList(this.dex, eMethod, results);
            if (filtered == null || filtered.isEmpty()) continue;
            results.clear();
            results.addAll(filtered);
            if (results.size() != 1) continue;
            return;
        }
    }

    static List<MethodSignature> mergeSignaturesPerClass(List<MethodSignature> results, IDexMethod eMethod) {
        if (results.size() < 2) {
            return results;
        }
        HashMap<String, ArrayList<MethodSignature>> sigs = new HashMap<String, ArrayList<MethodSignature>>();
        for (MethodSignature result : results) {
            String className = result.getCname();
            ArrayList<MethodSignature> values = (ArrayList<MethodSignature>)sigs.get(className);
            if (values == null) {
                values = new ArrayList<MethodSignature>();
                sigs.put(className, values);
            }
            values.add(result);
        }
        ArrayList<MethodSignature> merged = new ArrayList<MethodSignature>();
        for (List values : sigs.values()) {
            merged.add(MethodSignature.mergeSignatures(values, true, eMethod));
        }
        return merged;
    }

    public boolean isEmpty() {
        return this.fileCandidates.isEmpty();
    }

    public Set<Map.Entry<String, Map<String, InnerMatch>>> entrySet() {
        return this.fileCandidates.entrySet();
    }

    public void filterClassName(String hintName) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, Map<String, InnerMatch>> entry : this.entrySet()) {
            InnerMatch m = entry.getValue().get(hintName);
            if (m == null) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (entry.getValue().size() == 1) continue;
            entry.getValue().clear();
            entry.getValue().put(hintName, m);
        }
        for (String r : toRemove) {
            this.fileCandidates.remove(r);
        }
        if (this.fileCandidates.isEmpty()) {
            List<String> files = this.ref.getFilesContainingClass(hintName);
            if (files == null) {
                return;
            }
            for (String f : files) {
                InnerMatch m = new InnerMatch(hintName, f);
                HashMap<String, InnerMatch> value = new HashMap<String, InnerMatch>();
                value.put(hintName, m);
                this.fileCandidates.put(f, value);
            }
        }
    }

    public static enum SignatureCheck {
        PROTOTYPE_STRICT,
        PROTOTYPE_COMPATIBLE,
        SHORTY;

    }

    static class InnerMatch {
        private String className;
        private Map<Integer, MethodSignature> classPathMethod = new HashMap<Integer, MethodSignature>();
        private Set<MethodSignature> distinctMethods = new HashSet<MethodSignature>();
        private List<String> files;
        List<Integer> doNotRenameIndexes = new ArrayList<Integer>();
        public boolean oneMatch;
        private List<DatabaseReferenceFile> refFiles = new ArrayList<DatabaseReferenceFile>();

        public InnerMatch(String className, String file) {
            this.className = className;
            this.files = new ArrayList<String>();
            this.files.add(file);
        }

        public InnerMatch(String className, List<String> files) {
            this.className = className;
            this.files = files;
        }

        public String getCname() {
            return this.className;
        }

        public List<String> getFiles() {
            return this.files;
        }

        public List<DatabaseReferenceFile> getRefFiles() {
            return this.refFiles;
        }

        public DatabaseReferenceFile getFirstRefFile() {
            return this.refFiles.get(0);
        }

        public Collection<MethodSignature> getUsedMethodSignatures() {
            return this.classPathMethod.values();
        }

        public Set<Integer> getMatchedMethodIndexes() {
            return this.classPathMethod.keySet();
        }

        public Set<Map.Entry<Integer, MethodSignature>> entrySet() {
            return this.classPathMethod.entrySet();
        }

        public boolean containsMethod(Integer key) {
            return this.classPathMethod.containsKey(key);
        }

        public MethodSignature getMethod(Integer key) {
            return this.classPathMethod.get(key);
        }

        public int methodsSize() {
            return this.classPathMethod.size();
        }

        public boolean addMethod(IDexMethod eMethod, MethodSignature ms) {
            Integer key = eMethod.getIndex();
            if (this.classPathMethod.containsKey(key)) {
                return false;
            }
            Integer oldKey = null;
            MethodSignature toRemove = null;
            block0: for (MethodSignature m : this.distinctMethods) {
                if (ms.getMname().isEmpty()) {
                    if (!m.getPrototype().equals(ms.getPrototype())) continue;
                    return false;
                }
                if (!ms.getMname().equals(m.getMname()) || !ms.getPrototype().equals(m.getPrototype())) continue;
                if (eMethod.getSignature(true).equals(ms.getMname())) {
                    toRemove = m;
                    for (Map.Entry<Integer, MethodSignature> entry : this.classPathMethod.entrySet()) {
                        if (!entry.getValue().getMname().equals(ms.getMname()) || !entry.getValue().getPrototype().equals(ms.getPrototype())) continue;
                        oldKey = entry.getKey();
                        break block0;
                    }
                }
                return false;
            }
            if (toRemove != null) {
                this.classPathMethod.remove(oldKey);
                this.distinctMethods.remove(toRemove);
            }
            if (ms.getMname().isEmpty()) {
                // empty if block
            }
            this.classPathMethod.put(key, ms);
            this.distinctMethods.add(ms);
            return true;
        }

        public void validateMethods() {
            HashSet<String> duplicated = new HashSet<String>();
            HashSet<String> sigSets = new HashSet<String>();
            for (Map.Entry<Integer, MethodSignature> sig : this.classPathMethod.entrySet()) {
                if (!sigSets.contains(sig.getValue().getMname())) {
                    sigSets.add(sig.getValue().getMname());
                    continue;
                }
                duplicated.add(sig.getValue().getMname());
            }
            if (duplicated.isEmpty()) {
                return;
            }
            HashMap<String, ArrayList<Integer>> duplicatedKeys = new HashMap<String, ArrayList<Integer>>();
            for (Map.Entry<Integer, MethodSignature> entry : this.classPathMethod.entrySet()) {
                if (!duplicated.contains(entry.getValue().getMname())) continue;
                ArrayList<Integer> val = (ArrayList<Integer>)duplicatedKeys.get(entry.getValue().getMname());
                if (val == null) {
                    val = new ArrayList<Integer>();
                    duplicatedKeys.put(entry.getValue().getMname(), val);
                }
                val.add(entry.getKey());
            }
            for (Map.Entry<Integer, MethodSignature> entry : duplicatedKeys.entrySet()) {
                boolean unsafe = false;
                for (int i = 0; i < ((List)((Object)entry.getValue())).size(); ++i) {
                    Integer currentKey = (Integer)((List)((Object)entry.getValue())).get(i);
                    if (Strings.isBlank((String)this.classPathMethod.get(currentKey).getPrototype())) {
                        unsafe = true;
                        break;
                    }
                    for (int j = i + 1; j < ((List)((Object)entry.getValue())).size(); ++j) {
                        Integer vsKey = (Integer)((List)((Object)entry.getValue())).get(j);
                        if (!this.classPathMethod.get(currentKey).getPrototype().equals(this.classPathMethod.get(vsKey).getPrototype())) continue;
                        unsafe = true;
                        break;
                    }
                    if (unsafe) break;
                }
                if (!unsafe) continue;
                this.doNotRenameIndexes.addAll((Collection)((Object)entry.getValue()));
            }
        }

        public void validateVersions() {
            for (String file : this.files) {
                List<List<String>> preferedOrderList;
                DatabaseReferenceFile refFile = new DatabaseReferenceFile(file, null);
                this.refFiles.add(refFile);
                refFile.mergeVersions(this.classPathMethod.values());
                if (refFile.hasNoVersion() || (preferedOrderList = refFile.getOrderedVersions()) == null || preferedOrderList.isEmpty()) continue;
                List<String> versions = preferedOrderList.get(0);
                ArrayList<Integer> illegalMethods = new ArrayList<Integer>();
                for (Map.Entry<Integer, MethodSignature> method : this.classPathMethod.entrySet()) {
                    String[] versionsArray = method.getValue().getVersions();
                    if (versionsArray == null) continue;
                    boolean found = false;
                    for (String v : versionsArray) {
                        if (!versions.contains(v)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    illegalMethods.add(method.getKey());
                }
                for (Integer illegal : illegalMethods) {
                    this.classPathMethod.remove(illegal);
                }
                if (refFile.getMergedVersions().contains(versions.get(0))) continue;
                refFile = new DatabaseReferenceFile(this.files.get(0), null);
                refFile.mergeVersions(this.classPathMethod.values());
            }
        }

        public static InnerMatch mergeCandidates(IDexUnit dex, List<InnerMatch> newBestCandidates, boolean intersection) {
            HashMap<Integer, MethodSignature> classPathMethod = new HashMap<Integer, MethodSignature>();
            ArrayList<Integer> doNotRenameIndexes = new ArrayList<Integer>();
            boolean oneMatch = false;
            Iterator<InnerMatch> iter = newBestCandidates.iterator();
            InnerMatch first = iter.next();
            ArrayList<String> files = new ArrayList<String>();
            for (Map.Entry<Integer, MethodSignature> entry : first.entrySet()) {
                Iterator val = entry.getValue();
                classPathMethod.put(entry.getKey(), new MethodSignature(((MethodSignature)((Object)val)).getCname(), ((MethodSignature)((Object)val)).getMname(), ((MethodSignature)((Object)val)).getShorty(), ((MethodSignature)((Object)val)).getPrototype(), null));
            }
            doNotRenameIndexes.addAll(first.doNotRenameIndexes);
            oneMatch &= first.oneMatch;
            files.addAll(first.getFiles());
            while (iter.hasNext()) {
                InnerMatch nMatch = iter.next();
                HashSet toRemove = new HashSet();
                if (intersection) {
                    for (Map.Entry entry : classPathMethod.entrySet()) {
                        MethodSignature methodSignature = nMatch.getMethod((Integer)entry.getKey());
                        if (methodSignature != null && methodSignature.getMname().equals(((MethodSignature)entry.getValue()).getMname()) && methodSignature.getPrototype().equals(((MethodSignature)entry.getValue()).getPrototype())) continue;
                        toRemove.add(entry.getKey());
                    }
                    for (Integer n : toRemove) {
                        classPathMethod.remove(n);
                    }
                } else {
                    ArrayList processed = new ArrayList();
                    for (Map.Entry entry : classPathMethod.entrySet()) {
                        processed.add(entry.getKey());
                        MethodSignature nVal = nMatch.getMethod((Integer)entry.getKey());
                        if (nVal == null || nVal.getMname().equals(((MethodSignature)entry.getValue()).getMname()) && nVal.getPrototype().equals(((MethodSignature)entry.getValue()).getPrototype())) continue;
                        toRemove.add(entry.getKey());
                    }
                    for (Map.Entry<Integer, MethodSignature> entry : nMatch.entrySet()) {
                        if (processed.contains(entry.getKey())) continue;
                        classPathMethod.put(entry.getKey(), entry.getValue());
                    }
                }
                doNotRenameIndexes.addAll(nMatch.doNotRenameIndexes);
                oneMatch &= nMatch.oneMatch;
                files.addAll(nMatch.getFiles());
            }
            InnerMatch innerMatch = new InnerMatch(first.getCname(), files);
            for (Map.Entry entry : classPathMethod.entrySet()) {
                innerMatch.addMethod(dex.getMethod(((Integer)entry.getKey()).intValue()), (MethodSignature)entry.getValue());
            }
            innerMatch.doNotRenameIndexes = doNotRenameIndexes;
            innerMatch.oneMatch = oneMatch;
            innerMatch.validateVersions();
            return innerMatch;
        }
    }
}

