/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.andsig;

import com.pnf.androsig.apply.matcher.DatabaseMatcherParameters;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.DexHashcodeList;
import com.pnf.androsig.apply.model.StructureInfo;
import com.pnf.androsig.apply.util.MetadataGroupHandler;
import com.pnf.androsig.apply.util.ReportHandler;
import com.pnf.androsig.common.AndroSigCommon;
import com.pnf.androsig.common.SignatureHandler;
import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IOptionDefinition;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AndroidSigApplyPlugin
extends AbstractEnginesPlugin {
    private final ILogger logger = GlobalLog.getLogger(AndroidSigApplyPlugin.class);

    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Android Code Recognition", "Apply code signatures to identify Android libraries", "PNF Software", AndroSigCommon.VERSION, Version.create((int)3, (int)1, (int)0));
    }

    public List<? extends IOptionDefinition> getExecutionOptionDefinitions() {
        return DatabaseMatcherParameters.getExecutionOptionDefinitions();
    }

    public void dispose() {
    }

    public void load(IEnginesContext arg0) {
    }

    public void execute(IEnginesContext context) {
        this.execute(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IEnginesContext context, Map<String, String> executionOptions) {
        File sigFolder;
        long t0 = System.currentTimeMillis();
        IRuntimeProject prj = context.getProject(0);
        if (prj == null) {
            return;
        }
        try {
            sigFolder = SignatureHandler.getSignaturesFolder(context);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        DatabaseReference ref = new DatabaseReference();
        StructureInfo struInfo = new StructureInfo(executionOptions, ref);
        try {
            ref.loadAllHashCodes(sigFolder);
            List dexlist = RuntimeProjectUtil.findUnitsByType((IRuntimeProject)prj, IDexUnit.class, (boolean)false);
            Iterator iterator = dexlist.iterator();
            if (iterator.hasNext()) {
                IDexUnit dex = (IDexUnit)iterator.next();
                DexHashcodeList dexHashCodeList = new DexHashcodeList();
                dexHashCodeList.loadAPKHashcodes(dex);
                MetadataGroupHandler.createCodeGroupMethod((ICodeUnit)dex, struInfo.getStructureResult());
                MetadataGroupHandler.createCodeGroupClass((ICodeUnit)dex, struInfo.getStructureResult());
                struInfo.rebuildStructure(dex, dexHashCodeList);
                if (Thread.currentThread().isInterrupted()) {
                    this.logger.info("Tread Interrupted!", new Object[0]);
                    return;
                }
                dex.notifyListeners((IEvent)new JebEvent(J.UnitChange));
                ReportHandler.generateRecord(dex, struInfo, ref);
            }
            this.logger.info("*************** Completed! ***************", new Object[0]);
            this.logger.info("Signature recognition took %fs", new Object[]{(double)(System.currentTimeMillis() - t0) / 1000.0});
        }
        finally {
            struInfo = null;
            ref.close();
            ref = null;
            System.gc();
        }
    }
}

