/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.oat.internal;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StreamReader {
    protected static final ILogger logger = GlobalLog.getLogger(StreamReader.class);

    protected static int readInt(ByteArrayInputStream stream, int offset) {
        stream.mark(0);
        stream.skip(offset);
        int output = StreamReader.readInt(stream);
        stream.reset();
        return output;
    }

    protected static short readShort(ByteArrayInputStream stream, int offset) {
        stream.mark(0);
        stream.skip(offset);
        short output = StreamReader.readShort(stream);
        stream.reset();
        return output;
    }

    protected static int readInt(ByteArrayInputStream stream) {
        byte[] temp = new byte[4];
        stream.read(temp, 0, 4);
        return ByteBuffer.wrap(temp).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    protected static short readShort(ByteArrayInputStream stream) {
        byte[] temp = new byte[2];
        stream.read(temp, 0, 2);
        return ByteBuffer.wrap(temp).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    protected static String readString(ByteArrayInputStream stream) {
        char character;
        String output = "";
        while (stream.available() > 0 && (character = (char)stream.read()) != '\u0000') {
            output = output + character;
        }
        return output;
    }

    protected static String readString(ByteArrayInputStream stream, int length) {
        String output = "";
        for (int index = 0; index < length; ++index) {
            char character = (char)stream.read();
            output = output + character;
        }
        return output;
    }

    protected static boolean checkBytes(byte[] data, int offset, byte ... checkBytes) {
        for (int index = 0; index < checkBytes.length; ++index) {
            if (data[offset + index] == checkBytes[index]) continue;
            return false;
        }
        return true;
    }
}

