/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.oat.internal;

import com.pnf.plugin.oat.internal.StreamReader;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

public class DexFile
extends StreamReader {
    @SerId(value=1)
    private byte[] data;
    @SerId(value=2)
    private int offset;
    @SerId(value=3)
    private int maxSize;
    @SerId(value=4)
    private String location;

    @SerConstructor
    DexFile() {
    }

    public DexFile(byte[] data, int offset, int maxSize, String location) {
        this.data = data;
        this.offset = offset;
        this.maxSize = maxSize;
        this.location = location;
    }

    public byte[] getBytes(boolean provideAllBytes) {
        int expectedFileSize;
        int size = this.maxSize;
        if (!provideAllBytes && this.maxSize >= 36 && (expectedFileSize = EndianUtil.littleEndianBytesToInt((byte[])this.data, (int)(this.offset + 32))) > 0) {
            size = Math.min(this.maxSize, expectedFileSize);
        }
        byte[] output = new byte[size];
        System.arraycopy(this.data, this.offset, output, 0, size);
        return output;
    }

    public byte[] getBytes() {
        return this.getBytes(true);
    }

    public String getLocation() {
        return this.location;
    }
}

