/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.properties.impl.ConfigurationMemoryMap;
import com.pnfsoftware.jeb.core.properties.impl.SimplePropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.FontManager;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.IStatusIndicator;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ZoomableUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.IGraphController;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.IGraphNodeContents;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.BufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.IPositionListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.TextDocumentLocationGenerator;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.ItemStyleProvider2;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextHoverableProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.UnitTextAnnotator;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class NodeContentsTextFragment
extends AbstractTextFragment
implements IGraphNodeContents {
    private static final ILogger logger = GlobalLog.getLogger(NodeContentsTextFragment.class);
    private StyledText w;
    private ItemStyleProvider2 styleProvider;
    private UnitTextAnnotator textAnnotator;
    private int zoomLevel;
    private Integer defaultHeight;
    private static final int[] wkhsuite = new int[]{1, 2, 4, 6, 8, 10, 14, 20};
    private static final int wkhLastIndex = wkhsuite.length - 1;

    public NodeContentsTextFragment(Composite parent, int style, ITextDocument idoc, FontManager fontManager, ItemStyleProvider2 styleProvider, IUnit unit, final IStatusIndicator statusIndicator, IOperable master, final IGraphController controller, final IRcpClientContext context) {
        super(parent, style, unit, null, context, idoc);
        this.setLayout((Layout)new FillLayout());
        this.master = master;
        this.styleProvider = styleProvider;
        SimplePropertyManager propManager = new SimplePropertyManager(new ConfigurationMemoryMap());
        propManager.setBoolean(".ui.text.ShowVerticalScrollbar", false);
        propManager.setBoolean(".ui.text.ShowHorizontalScrollbar", false);
        propManager.setBoolean(".ui.text.DisplayEolAtEod", false);
        propManager.setInteger(".ui.text.CharactersPerLineMax", 160);
        propManager.setInteger(".ui.text.CharactersPerLineAtEnd", 10);
        propManager.setBoolean(".ui.text.AllowLineWrapping", false);
        propManager.setInteger(".ui.text.CharactersWrap", -1);
        propManager.setInteger(".ui.text.ScrollLineSize", 0);
        propManager.setInteger(".ui.text.PageLineSize", 0);
        propManager.setInteger(".ui.text.PageMultiplier", 0);
        propManager.setBoolean(".ui.text.CaretBehaviorViewportStatic", false);
        propManager.setInteger(".ui.NavigationBarPosition", 0);
        propManager.setInteger(".ui.NavigationBarThickness", 2);
        int flags = 2;
        this.iviewer = new InteractiveTextViewer(this, flags, idoc, propManager, null);
        this.w = this.iviewer.getTextWidget();
        if (fontManager != null) {
            this.w.setFont(fontManager.getCodeFont());
        }
        ThemeManager.getInstance().registerWidget((Control)this.w);
        if (styleProvider != null) {
            styleProvider.registerTextViewer(this.iviewer);
            this.iviewer.setStyleAdapter(styleProvider);
        }
        final TextDocumentLocationGenerator locationGenerator = new TextDocumentLocationGenerator(unit, this.iviewer);
        this.iviewer.addPositionListener(new IPositionListener(){

            @Override
            public void positionChanged(ITextDocumentViewer viewer, ICoordinates coordinates, int focusChange) {
                if (context != null) {
                    context.refreshHandlersStates();
                }
                if (statusIndicator != null) {
                    String status = locationGenerator.generateStatus(coordinates);
                    statusIndicator.setText(status);
                }
            }

            @Override
            public void positionUnchangedAttemptBreakout(ITextDocumentViewer viewer, int direction) {
                if (controller != null) {
                    controller.onNodeBreakoutAttempt(NodeContentsTextFragment.this, direction);
                }
            }
        });
        if (context != null) {
            UIState uiState = context.getUIState(unit);
            this.textAnnotator = new UnitTextAnnotator(uiState, this.iviewer);
        }
        this.iviewer.initialize(false);
        this.w.setDoubleClickEnabled(false);
        this.w.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                NodeContentsTextFragment.this.requestOperation(new OperationRequest(Operation.ITEM_FOLLOW));
            }
        });
        if (context != null) {
            this.iviewer.setHoverText(new TextHoverableProvider(context, unit, this.iviewer));
        }
        this.addStandardContextMenu(4);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NodeContentsTextFragment.this.iviewer.dispose();
                if (NodeContentsTextFragment.this.textAnnotator != null) {
                    NodeContentsTextFragment.this.textAnnotator.dispose();
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.w.isDisposed()) {
            return new Point(0, 0);
        }
        return this.iviewer.computeIdealSize();
    }

    public boolean setFocus() {
        if (this.w.isDisposed()) {
            return false;
        }
        return this.w.setFocus();
    }

    public boolean forceFocus() {
        if (this.w.isDisposed()) {
            return false;
        }
        return this.w.forceFocus();
    }

    public boolean isFocusControl() {
        if (this.w.isDisposed()) {
            return false;
        }
        return this.w.isFocusControl();
    }

    public void addFocusListener(FocusListener listener) {
        if (this.w.isDisposed()) {
            return;
        }
        super.addFocusListener(listener);
        this.w.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.w.isDisposed()) {
            return;
        }
        super.removeFocusListener(listener);
        this.w.removeFocusListener(listener);
    }

    public void setFont(Font font) {
        if (this.w.isDisposed()) {
            return;
        }
        super.setFont(font);
        this.w.setFont(font);
    }

    public Color getForeground() {
        return this.w.getForeground();
    }

    public void setForeground(Color color) {
        if (this.w.isDisposed()) {
            return;
        }
        super.setForeground(color);
        this.w.setForeground(color);
    }

    public Color getBackground() {
        return this.w.getBackground();
    }

    public void setBackground(Color color) {
        if (this.w.isDisposed()) {
            return;
        }
        super.setBackground(color);
        this.w.setBackground(color);
    }

    public void setEnabled(boolean enabled) {
        if (this.w.isDisposed()) {
            return;
        }
        super.setEnabled(enabled);
        this.w.setEnabled(enabled);
    }

    public void setMenu(Menu menu) {
        if (this.w.isDisposed()) {
            return;
        }
        super.setMenu(menu);
        this.w.setMenu(menu);
    }

    public void setToolTipText(String string) {
        if (this.w.isDisposed()) {
            return;
        }
        super.setToolTipText(string);
        this.w.setToolTipText(string);
    }

    public void setCursor(Cursor cursor) {
        if (this.w.isDisposed()) {
            return;
        }
        super.setCursor(cursor);
        this.w.setCursor(cursor);
    }

    public void setText(String text) {
        if (this.w.isDisposed()) {
            return;
        }
        this.w.setText(text);
    }

    public String getText() {
        if (this.w.isDisposed()) {
            return "";
        }
        return this.w.getText();
    }

    public void setEditable(boolean editable) {
        if (this.w.isDisposed()) {
            return;
        }
        this.w.setEditable(editable);
    }

    public void setCaret(Caret caret) {
        if (this.w.isDisposed()) {
            return;
        }
        this.w.setCaret(caret);
    }

    public Caret getCaret() {
        if (this.w.isDisposed()) {
            return null;
        }
        return this.w.getCaret();
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        if (this.iviewer.verifyOperation(req)) {
            return true;
        }
        switch (req.getOperation()) {
            case JUMP_TO: {
                return true;
            }
            case ITEM_FOLLOW: {
                return this.getActiveItem() instanceof IActionableItem;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        if (this.iviewer.doOperation(req)) {
            return true;
        }
        if (!req.proceed()) {
            return false;
        }
        switch (req.getOperation()) {
            case JUMP_TO: {
                return false;
            }
            case ITEM_FOLLOW: {
                return this.doItemFollow();
            }
        }
        return false;
    }

    @Override
    public IUnit getUnit() {
        return this.unit;
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return this.styleProvider == null ? false : this.styleProvider.isActiveItem(item);
    }

    @Override
    public IItem getActiveItem() {
        return this.styleProvider == null ? null : this.styleProvider.getActiveItem();
    }

    @Override
    public String getActiveItemAsText() {
        IItem item = this.getActiveItem();
        if (!(item instanceof ITextItem)) {
            return null;
        }
        return ((ITextItem)item).getText();
    }

    @Override
    public String getActiveAddress() {
        ICoordinates coords = this.iviewer.getCaretCoordinates();
        if (coords != null) {
            return this.idoc.coordinatesToAddress(coords, AddressConversionPrecision.FINE);
        }
        return null;
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        try {
            ICoordinates coord = this.idoc.addressToCoordinates(address);
            return coord != null;
        }
        catch (Exception e) {
            logger.catching(e);
            return false;
        }
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record) {
        ICoordinates coord = null;
        try {
            coord = this.idoc.addressToCoordinates(address);
        }
        catch (Exception e) {
            logger.catching(e);
        }
        if (coord == null) {
            return false;
        }
        GlobalPosition pos0 = null;
        if (record) {
            pos0 = this.getViewManager() == null ? null : this.getViewManager().getCurrentGlobalPosition();
        }
        BufferPoint vp = null;
        if (extra instanceof BufferPoint) {
            vp = (BufferPoint)extra;
        }
        if (!this.iviewer.setCaretCoordinates(coord, vp, false)) {
            return false;
        }
        if (pos0 != null) {
            this.getViewManager().recordGlobalPosition(pos0);
        }
        return true;
    }

    @Override
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    public boolean applyZoom(int zoom, boolean dryRun) {
        int newHeight;
        if (ZoomableUtil.updateZoom(this.zoomLevel, zoom = ZoomableUtil.sanitizeZoom(zoom)) == 0) {
            zoom = 0;
        }
        FontData[] fdlist = this.w.getFont().getFontData();
        FontData fd0 = fdlist[0];
        int currentHeight = fd0.getHeight();
        if (this.defaultHeight == null) {
            this.defaultHeight = currentHeight;
        }
        if ((newHeight = this.determineNextFontHeight(currentHeight, zoom)) == currentHeight || newHeight <= 1 || newHeight > 300) {
            return false;
        }
        if (!dryRun) {
            logger.i("New font height after zoom: %d", newHeight);
            FontDescriptor desc = FontDescriptor.createFrom(fdlist).setHeight(newHeight);
            Font f = UIAssetManager.getInstance().getFont(desc);
            this.w.setFont(f);
            this.zoomLevel = ZoomableUtil.updateZoom(this.zoomLevel, zoom);
        }
        return true;
    }

    private int determineNextFontHeight(int h, int zoom) {
        int v;
        if (zoom == 0) {
            return this.defaultHeight;
        }
        int i = 0;
        for (int v2 : wkhsuite) {
            if (v2 >= h) break;
            ++i;
        }
        if (i < wkhsuite.length && (v = wkhsuite[i]) > h) {
            --i;
        }
        if (i <= 0) {
            return wkhsuite[0];
        }
        if (zoom > 0) {
            if (i >= wkhLastIndex) {
                return (int)(1.5 * (double)h);
            }
            return wkhsuite[i + 1];
        }
        if (i >= wkhsuite.length) {
            return wkhsuite[wkhLastIndex];
        }
        return wkhsuite[i - 1];
    }
}

