/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.debug.impl.DebuggerUtil;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueRaw;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JumpToDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.InfiniTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractInfiniTableSectionProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.InfiniTableViewer;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.util.DbgTypedValueUtil;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DbgStackFragment
extends AbstractUnitFragment<IDebuggerUnit>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgStackFragment.class);
    private InfiniTableView view;
    private InfiniTableViewer viewer;
    private StackItemsProvider provider;

    public DbgStackFragment(Composite parent, int flags, RcpClientContext context, IDebuggerUnit unit) {
        super(parent, flags, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        if (unit == null) {
            throw new RuntimeException();
        }
        this.view = new InfiniTableView(this, 4, new String[]{"Address", "Value", "Extra"});
        this.viewer = new InfiniTableViewer(this.view);
        this.provider = new StackItemsProvider();
        this.viewer.setContentProvider(this.provider);
        this.viewer.setLabelProvider(new StackItemLabelProvider(this.provider));
        this.viewer.setTopId(0L, false);
        this.viewer.setInput(unit);
        new ContextMenu((Control)this.view.getTable()).addContextMenu(this);
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        this.addOperationsToContextMenu(menuMgr);
    }

    public StackEntry getSelectedRow() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel.isEmpty() ? null : (StackEntry)sel.getFirstElement();
    }

    @Override
    public String getActiveAddress() {
        StackEntry e = this.getSelectedRow();
        return e == null ? null : String.format("%Xh", e.address);
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case JUMP_TO: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case JUMP_TO: {
                long memoryAddress;
                JumpToDialog dlg = new JumpToDialog(this.getShell(), RcpClientContext.getStandardAddressHistory(this.context));
                String symbol = dlg.open();
                if (symbol != null && (memoryAddress = ((IDebuggerUnit)this.unit).convertSymbolicAddressToMemoryToAddress(symbol, null)) != 0L && this.provider.asize > 0) {
                    long id = memoryAddress / (long)this.provider.asize;
                    this.viewer.setTopId(id, true);
                }
                return true;
            }
        }
        return false;
    }

    static class StackItemsProvider
    extends AbstractInfiniTableSectionProvider {
        IEventListener listener;
        IDebuggerUnit dbg;
        int asize;

        StackItemsProvider() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((IDebuggerUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            this.dbg = (IDebuggerUnit)newInput;
            if (this.dbg == null) {
                return;
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    if (dbg != null && e.getSource() == dbg) {
                        UIExecutor.async((Widget)viewer.getControl(), new UIRunnable(){

                            @Override
                            public void runi() {
                                if (dbg != null && !viewer.getControl().isDisposed()) {
                                    viewer.refresh();
                                }
                            }
                        });
                    }
                }
            };
            this.dbg.addListener(this.listener);
        }

        @Override
        public Object[] getRowElements(Object row) {
            StackEntry e = (StackEntry)row;
            return new Object[]{e.address, e.bytes};
        }

        @Override
        public Object[] get(Object inputElement, long id, int cnt) {
            IDebuggerVirtualMemory vm;
            IDebuggerUnit unit = (IDebuggerUnit)inputElement;
            if (unit.isAttached() && unit.getDefaultThread() != null && unit.getDefaultThread().getStatus() == DebuggerThreadStatus.PAUSED && (vm = unit.getMemory()) != null) {
                this.asize = vm.getSpaceBits() / 8;
                try {
                    return this.readStackArea(unit, id, cnt);
                }
                catch (Exception e) {
                    logger.catching(e);
                }
            }
            return ArrayUtil.NO_OBJECT;
        }

        private Object[] readStackArea(IDebuggerUnit unit, long id, int cnt) {
            long address = id * (long)this.asize;
            int size = cnt * this.asize;
            byte[] data = new byte[size];
            int readsize = unit.readMemory(address, size, data, 0);
            logger.i("Stack @%Xh, read %Xh bytes", address, readsize);
            ArrayList<StackEntry> r = new ArrayList<StackEntry>();
            for (int i = 0; i < cnt; ++i) {
                StackEntry e = new StackEntry();
                e.address = address + (long)(i * this.asize);
                if (i >= readsize) {
                    e.bytes = null;
                } else {
                    e.bytes = new byte[this.asize];
                    ArrayUtil.copyBytes(e.bytes, 0, data, i * this.asize, this.asize);
                }
                r.add(e);
            }
            return r.toArray();
        }
    }

    class StackItemLabelProvider
    extends DefaultCellLabelProvider {
        private Map<Long, String> cacheExtra;

        public StackItemLabelProvider(StackItemsProvider provider) {
            super(provider);
            this.cacheExtra = new HashMap<Long, String>();
        }

        @Override
        public void update(ViewerCell cell) {
            super.update(cell);
            if (cell.getColumnIndex() == 0 || cell.getColumnIndex() == 1) {
                cell.setFont(DbgStackFragment.this.context.getFontManager().getCodeFont());
            }
        }

        @Override
        public String getStringAt(Object element, int key) {
            StackEntry e = (StackEntry)element;
            switch (key) {
                case 0: {
                    return DbgTypedValueUtil.formatAddress(e.address, (IDebuggerUnit)DbgStackFragment.this.unit);
                }
                case 1: {
                    if (e.bytes != null) {
                        return DbgTypedValueUtil.formatValue(new ValueRaw(e.bytes), 0, (IDebuggerUnit)DbgStackFragment.this.unit);
                    }
                    return null;
                }
                case 2: {
                    long ptr;
                    if (e.bytes != null && (ptr = DbgTypedValueUtil.bytesToAddress(e.bytes, (IDebuggerUnit)DbgStackFragment.this.unit)) != 0L) {
                        String extra = this.cacheExtra.get(ptr);
                        if (extra == null) {
                            byte[] mem = DebuggerUtil.readMemoryStringSafe((IDebuggerUnit)DbgStackFragment.this.unit, ptr, 256);
                            if (mem == null) {
                                extra = "";
                            } else {
                                int asciiLength = Strings.getAsciiLength(mem);
                                extra = Strings.decodeASCII(mem, 0, asciiLength);
                            }
                            this.cacheExtra.put(ptr, extra);
                        }
                        return extra;
                    }
                    return null;
                }
            }
            return super.getStringAt(element, key);
        }
    }

    public static class StackEntry {
        long address;
        byte[] bytes;
    }
}

