/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextViewer;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.ItemStyleProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.debuggers.DbgCodeDocument;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DbgCodeFragment
extends AbstractUnitFragment<IDebuggerUnit>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgCodeFragment.class);
    private ITextDocumentViewer viewer;
    private DbgCodeDocument document;
    private IDebuggerUnit dbg;
    private IEventListener listener;

    public DbgCodeFragment(Composite parent, int flags, RcpClientContext context, final IDebuggerUnit unit) {
        super(parent, flags, unit, null, context);
        IRegisterBank regs;
        IDebuggerThread defThread;
        this.setLayout((Layout)new FillLayout());
        if (unit == null) {
            throw new RuntimeException();
        }
        this.dbg = unit;
        this.document = new DbgCodeDocument(unit);
        this.viewer = new InteractiveTextViewer(this, 0, this.document, context.getPropertyManager(), null);
        context.getFontManager().registerWidget((Control)this.viewer.getTextWidget());
        context.getThemeManager().registerWidget((Control)this.viewer.getTextWidget());
        ItemStyleProvider tsa = new ItemStyleProvider(context.getStyleManager());
        tsa.registerTextViewer(this.viewer);
        this.viewer.setStyleAdapter(tsa);
        this.viewer.initialize(true);
        if (unit.isAttached() && (defThread = unit.getDefaultThread()) != null && defThread.getStatus() == DebuggerThreadStatus.PAUSED && (regs = defThread.getRegisters()) != null) {
            this.viewer.setCaretCoordinates(new Coordinates(regs.getProgramCounter()), null, false);
        }
        this.viewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!DbgCodeFragment.this.viewer.isDisposed()) {
                    if (e.keyCode == 119) {
                        DbgCodeFragment.this.document.switchViewType();
                        DbgCodeFragment.this.viewer.refresh();
                    } else if (DbgCodeFragment.this.document.getViewType() == DbgCodeDocument.ViewType.CODE && DbgCodeFragment.this.dbg.isAttached() && DbgCodeFragment.this.dbg.getDefaultThread() != null && DbgCodeFragment.this.dbg.getDefaultThread().getStatus() == DebuggerThreadStatus.PAUSED) {
                        ICoordinates coords = DbgCodeFragment.this.viewer.getCaretCoordinates();
                        if (coords == null) {
                            return;
                        }
                        int parseMode = this.getParseMode(e.keyCode);
                        if (parseMode >= 0) {
                            if (DbgCodeFragment.this.document.hasInsnAt(coords.getAnchorId())) {
                                return;
                            }
                            long newAnchorId = DbgCodeFragment.this.document.getInsnAddressAt(coords.getAnchorId(), coords.getColumnOffset());
                            boolean changed = DbgCodeFragment.this.document.forceInsnAt(newAnchorId, parseMode);
                            if (changed) {
                                if (!DbgCodeFragment.this.document.hasInsnAt(coords.getAnchorId())) {
                                    DbgCodeFragment.this.viewer.setCaretCoordinates(new Coordinates(newAnchorId), null, false);
                                }
                                DbgCodeFragment.this.viewer.refresh();
                            }
                        } else if (e.keyCode == 117) {
                            DbgCodeFragment.this.document.removeInsn(coords.getAnchorId());
                            DbgCodeFragment.this.viewer.refresh();
                            ICoordinates newCoords = DbgCodeFragment.this.viewer.getCaretCoordinates();
                            if (newCoords == null) {
                                Long previousInsnAddress = null;
                                long previousAddress = coords.getAnchorId() - 1L;
                                while (coords.getAnchorId() - previousAddress < 16L) {
                                    if (DbgCodeFragment.this.document.hasInsnAt(previousAddress)) {
                                        previousInsnAddress = previousAddress;
                                        break;
                                    }
                                    --previousAddress;
                                }
                                long newAnchorId = coords.getAnchorId() & 0xFFFFFFFFFFFFFFF0L;
                                if (previousInsnAddress != null) {
                                    long gap = previousInsnAddress + (long)DbgCodeFragment.this.document.getInsnAt(previousInsnAddress).getSize();
                                    newAnchorId = Math.max(newAnchorId, gap);
                                }
                                DbgCodeFragment.this.viewer.setCaretCoordinates(new Coordinates(newAnchorId), null, false);
                            }
                        }
                    }
                }
            }

            private int getParseMode(int keyCode) {
                switch (keyCode) {
                    case 100: {
                        return 0;
                    }
                    case 102: {
                        if (DbgCodeFragment.this.dbg.getProcessor().getDefaultMode() == 16) {
                            return 32;
                        }
                        return 16;
                    }
                    case 103: {
                        int defaultMode = DbgCodeFragment.this.dbg.getProcessor().getDefaultMode();
                        switch (defaultMode) {
                            case 16: 
                            case 32: {
                                return 64;
                            }
                            case 64: {
                                return 32;
                            }
                        }
                        throw new RuntimeException(Strings.f("Invalid default mode %d for processor %s", new Object[]{defaultMode, DbgCodeFragment.this.dbg.getTargetInformation().getProcessorType()}));
                    }
                }
                return -1;
            }
        });
        this.listener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (!DbgCodeFragment.this.viewer.getTextWidget().isDisposed() && DbgCodeFragment.this.dbg != null && e.getSource() == DbgCodeFragment.this.dbg) {
                    UIExecutor.async((Widget)DbgCodeFragment.this.viewer.getTextWidget(), new UIRunnable(){

                        @Override
                        public void runi() {
                            if (DbgCodeFragment.this.dbg != null && !DbgCodeFragment.this.viewer.isDisposed()) {
                                DbgCodeFragment.this.viewer.refresh();
                                if (DbgCodeFragment.this.dbg.isAttached() && DbgCodeFragment.this.dbg.getDefaultThread() != null && DbgCodeFragment.this.dbg.getDefaultThread().getStatus() == DebuggerThreadStatus.PAUSED) {
                                    String location = DbgCodeFragment.this.dbg.getDefaultThread().getLocation();
                                    DbgCodeFragment.this.viewer.setCaretCoordinates(new Coordinates(Conversion.stringToLong(location)), null, false);
                                }
                            }
                        }
                    });
                }
            }
        };
        unit.addListener(this.listener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DbgCodeFragment.this.viewer.dispose();
                unit.removeListener(DbgCodeFragment.this.listener);
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        this.addOperationsToContextMenu(menuMgr);
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        if (this.dbg == null) {
            return false;
        }
        List<? extends ICodeUnit> units = null;
        try {
            units = this.dbg.getPotentialDebuggees();
        }
        catch (Exception e) {
            logger.catchingSilent(e);
            return false;
        }
        if (units != null) {
            for (ICodeUnit iCodeUnit : units) {
                try {
                    long addr;
                    if (!(iCodeUnit instanceof INativeCodeUnit) || (addr = ((INativeCodeUnit)iCodeUnit).getCanonicalMemoryAddress(address)) == -1L) continue;
                    return true;
                }
                catch (Exception e) {
                    logger.catchingSilent(e);
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public String getActiveAddress() {
        ICoordinates coords = this.viewer.getCaretCoordinates();
        if (coords == null) {
            return null;
        }
        long anchorId = coords.getAnchorId();
        return String.format("%Xh", anchorId);
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(TextPartUtil.buildRawTextFromPart(this.viewer.getCurrentDocumentPart()));
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TEXT;
    }

    public static boolean isValidForUnit(IDebuggerUnit unit) {
        return unit.getMemory() != null;
    }
}

