/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DbgBreakpointsFragment
extends AbstractFilteredTableFragment<IDebuggerUnit, IDebuggerBreakpoint>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgBreakpointsFragment.class);

    public DbgBreakpointsFragment(Composite parent, int style, RcpClientContext context, IDebuggerUnit unit) {
        super(parent, style, unit, null, context, new BreakpointProvider());
        this.setLayout((Layout)new FillLayout());
        if (unit == null) {
            throw new RuntimeException();
        }
        FilteredTableViewer viewer = this.buildSimple(this, 36, new String[]{"Address"});
        viewer.setCheckStateProvider(new ICheckStateProvider(){

            @Override
            public boolean isGrayed(Object element) {
                return false;
            }

            @Override
            public boolean isChecked(Object element) {
                return DbgBreakpointsFragment.this.getProvider().isChecked(element);
            }
        });
        ((TableViewer)viewer.getViewer()).getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IDebuggerBreakpoint elt = DbgBreakpointsFragment.this.getSelectedRow();
                if (e.keyCode == 127 && elt != null && elt instanceof IDebuggerBreakpoint) {
                    ((IDebuggerUnit)DbgBreakpointsFragment.this.getUnit()).clearBreakpoint(elt);
                    e.doit = false;
                }
                super.keyReleased(e);
            }
        });
    }

    @Override
    protected void initFilteredView(FilteredTableView view) {
        view.setFilterVisibility(false, false);
        view.addTableEventListener(new ITableEventListener(){

            @Override
            public void onTableEvent(Object row, boolean isSelected, boolean isChecked) {
                logger.i("row=%s selected=%b checked=%b", row, isSelected, isChecked);
                IDebuggerUnit dbg = (IDebuggerUnit)DbgBreakpointsFragment.this.getUnit();
                IDebuggerBreakpoint bp = (IDebuggerBreakpoint)row;
                if (dbg.isAttached()) {
                    bp.setEnabled(isChecked);
                }
            }
        });
        new ContextMenu((Control)view.getTable()).addContextMenu(this);
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        IDebuggerBreakpoint elt = this.getSelectedRow();
        if (elt instanceof IDebuggerBreakpoint) {
            final IDebuggerBreakpoint bp = elt;
            menuMgr.add(new Action("Remove"){

                @Override
                public void run() {
                    ((IDebuggerUnit)DbgBreakpointsFragment.this.getUnit()).clearBreakpoint(bp);
                }
            });
        }
        this.addOperationsToContextMenu(menuMgr);
    }

    public TableViewer getJfaceViewer() {
        return (TableViewer)this.getViewer().getViewer();
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        IDebuggerBreakpoint o = this.getSelectedRow();
        if (!(o instanceof IDebuggerBreakpoint)) {
            return null;
        }
        String address = o.getAddress();
        return address;
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof IDebuggerBreakpoint;
    }

    @Override
    public IDebuggerBreakpoint getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof IDebuggerBreakpoint)) {
            return null;
        }
        return (IDebuggerBreakpoint)row;
    }

    static class BreakpointProvider
    implements IFilteredTableContentProvider {
        IEventListener listener;
        IDebuggerUnit dbg;

        BreakpointProvider() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((IDebuggerUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            this.dbg = (IDebuggerUnit)newInput;
            if (this.dbg == null) {
                return;
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    if (dbg != null && e.getSource() == dbg) {
                        UIExecutor.async((Widget)viewer.getControl(), new UIRunnable(){

                            @Override
                            public void runi() {
                                if (dbg != null && !viewer.getControl().isDisposed()) {
                                    viewer.refresh();
                                }
                            }
                        });
                    }
                }
            };
            this.dbg.addListener(this.listener);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            IDebuggerUnit unit = (IDebuggerUnit)inputElement;
            if (unit.isAttached()) {
                List<? extends IDebuggerBreakpoint> breakpoints = null;
                if (unit.isAttached() && (breakpoints = unit.getBreakpoints()) != null) {
                    return breakpoints.toArray();
                }
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object[] getRowElements(Object row) {
            IDebuggerBreakpoint bp = (IDebuggerBreakpoint)row;
            return new Object[]{bp.getAddress()};
        }

        @Override
        public boolean isChecked(Object row) {
            IDebuggerBreakpoint bp = (IDebuggerBreakpoint)row;
            return bp.isEnabled();
        }
    }
}

