/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.codeobject;

import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractDataFrameFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderCellItem;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CodeLoaderSegmentsFragment
extends AbstractDataFrameFragment<ICodeObjectUnit> {
    private boolean segmentsOrNotSections;
    private DataFrameView dfv = null;

    public CodeLoaderSegmentsFragment(Composite parent, int style, RcpClientContext context, ICodeObjectUnit unit, boolean segmentsOrNotSections) {
        super(parent, style, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        this.segmentsOrNotSections = segmentsOrNotSections;
        this.dfv = this.buildSimple(this, "Name", "Flags", "Offset in File", "Size in File", "Offset in Memory", "Size in Memory");
        this.dfv.getContextMenu().addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                CodeLoaderSegmentsFragment.this.addOperationsToContextMenu(menuMgr);
            }
        });
    }

    public ColumnViewer getViewer() {
        return this.dfv.getTableViewer();
    }

    @Override
    protected void initDataFrame(DataFrame df) {
        df.setRenderedBaseForNumberObjects(16);
        List<? extends ISegmentInformation> list = this.segmentsOrNotSections ? ((ICodeObjectUnit)this.unit).getSegments() : ((ICodeObjectUnit)this.unit).getSections();
        if (list == null) {
            list = new ArrayList<ISegmentInformation>();
        }
        for (ISegmentInformation iSegmentInformation : list) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(iSegmentInformation.getName());
            row.add(CodeLoaderSegmentsFragment.formatSegmentFlags(iSegmentInformation.getFlags()));
            row.add(iSegmentInformation.getOffsetInFile());
            row.add(iSegmentInformation.getSizeInFile());
            row.add(iSegmentInformation.getOffsetInMemory());
            row.add(iSegmentInformation.getSizeInMemory());
            df.addRow(row);
        }
    }

    private static String formatSegmentFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append("READ ");
            flags &= 0xFFFFFFFD;
        }
        if ((flags & 1) != 0) {
            sb.append("WRTE ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 4) != 0) {
            sb.append("EXEC ");
            flags &= 0xFFFFFFFB;
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            sb.append("SYNT ");
            flags &= Integer.MAX_VALUE;
        }
        if ((flags & 0x40000000) != 0) {
            sb.append("ALCW ");
            flags &= 0xBFFFFFFF;
        }
        if ((flags & 0x20000000) != 0) {
            sb.append("INVD ");
            flags &= 0xDFFFFFFF;
        }
        if (flags != 0) {
            sb.append(String.format("(other:%X)", flags));
        }
        return sb.toString().trim();
    }

    @Override
    public IItem getActiveItem() {
        TableItem[] sel = this.dfv.getTable().getSelection();
        if (sel != null && sel.length == 1) {
            return new CodeLoaderCellItem((ICodeObjectUnit)this.unit, sel[0].getText(0), sel[0].getText(4));
        }
        return null;
    }

    @Override
    public String getActiveAddress() {
        IItem item = this.getActiveItem();
        if (item instanceof CodeLoaderCellItem) {
            return ((CodeLoaderCellItem)item).getAddress();
        }
        return super.getActiveAddress();
    }
}

