/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorView;

public class StackEditorActionSetType
extends StackEditorAction {
    public StackEditorActionSetType(StackEditorView v) {
        super("Set Type", v);
        this.keyCode = 121;
        this.setAccelerator(89);
    }

    @Override
    public boolean isEnabled() {
        return this.v.getSelectedEntry() != null;
    }

    @Override
    public void run() {
        ItemEntry e = this.v.getSelectedEntry();
        if (e == null) {
            return;
        }
        String currentFieldSig = "";
        if (e.type != null) {
            currentFieldSig = e.type.getSignature(true);
        }
        TextDialog dlg = new TextDialog(this.v.getShell(), "Edit type of item", currentFieldSig, null);
        dlg.setSelected(true);
        String fieldSig = dlg.open();
        if (fieldSig == null) {
            return;
        }
        ITypeManager typeman = this.v.getInputUnit().getTypeManager();
        INativeType itemType = typeman.getType(fieldSig);
        if (itemType == null) {
            UI.error(String.format("The type \"%s\" was not found", fieldSig));
            return;
        }
        if (StackEditorActionSetType.setItemType(this.v, e, this.v.getInputRoutine(), itemType)) {
            this.v.refresh();
        }
    }

    static boolean setItemType(StackEditorView v, ItemEntry e, INativeMethodItem routine, INativeType newItemType) {
        if (newItemType == e.type) {
            return false;
        }
        if (!StackEditorActionSetType.offerClearItems(v, routine, e.offset, newItemType.getSize())) {
            return false;
        }
        INativeDataItem item = routine.getData().getStackframeManager().defineItem(e.offset, newItemType);
        if (item == null) {
            UI.error(String.format("A item of type \"%s\" could not be created at offset %Xh", newItemType.getName(true), e.offset));
            return false;
        }
        item.setName(e.name);
        return true;
    }
}

