/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.IllegalTypeNameException;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrettyTypeFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.WidgetActionWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.InfiniTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractInfiniTableSectionProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.InfiniTableViewer;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionDefine;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionDefineArray;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionRename;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionSelectType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionSetType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorActionUndefine;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class NativeTypeStructureEditorView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(NativeTypeStructureEditorView.class);
    private static final int previewDepthLevel = 10;
    private Font codefont;
    private INativeCodeUnit<?> unit;
    private IStructureType type;
    private InfiniTableView view;
    private InfiniTableViewer viewer;
    private StructFieldsProvider provider;
    private Combo comboSource;
    private Combo comboSelectedType;
    private Text widgetPreview;
    private Button btnPreviewDeep;
    private Button btnPreviewOffsets;
    int typeSourceFlags;
    Boolean allowUndefine;
    Integer assumedResponseForTypeImportPopup = null;

    public NativeTypeStructureEditorView(final Composite parent, int style, final INativeCodeUnit<?> unit) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        ToolBar bar = new ToolBar((Composite)this, 320);
        bar.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        ToolItem item = new ToolItem(bar, 0);
        item.setText("Source: ");
        item.setEnabled(false);
        item = new ToolItem(bar, 2);
        this.comboSource = new Combo((Composite)bar, 2056);
        this.comboSource.add("In-use types");
        this.comboSource.add("All types");
        this.comboSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NativeTypeStructureEditorView.this.comboSource.getSelectionIndex();
                NativeTypeStructureEditorView.this.selectSource(index);
            }
        });
        this.comboSource.pack();
        item.setWidth(this.comboSource.getSize().x);
        item.setControl((Control)this.comboSource);
        this.comboSource.select(0);
        this.typeSourceFlags = 1;
        item = new ToolItem(bar, 0);
        item.setText("Type: ");
        item.setEnabled(false);
        item = new ToolItem(bar, 2);
        this.comboSelectedType = new Combo((Composite)bar, 8);
        this.refreshTypesList();
        this.comboSelectedType.pack();
        item.setWidth(this.comboSelectedType.getSize().x);
        item.setControl((Control)this.comboSelectedType);
        this.comboSelectedType.forceFocus();
        item = new ToolItem(bar, 2);
        this.btnPreviewDeep = new Button((Composite)bar, 32);
        this.btnPreviewDeep.setText("Deep Preview   ");
        this.btnPreviewDeep.setSelection(true);
        this.btnPreviewDeep.setToolTipText(String.format("Include nested structures (up to %d) in preview", 10));
        this.btnPreviewDeep.pack();
        item.setWidth(this.btnPreviewDeep.getSize().x);
        item.setControl((Control)this.btnPreviewDeep);
        this.btnPreviewDeep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeStructureEditorView.this.generatePreview();
            }
        });
        item = new ToolItem(bar, 2);
        this.btnPreviewOffsets = new Button((Composite)bar, 32);
        this.btnPreviewOffsets.setText("Offsets   ");
        this.btnPreviewOffsets.setToolTipText("Display field offsets as comments in preview");
        this.btnPreviewOffsets.pack();
        item.setWidth(this.btnPreviewOffsets.getSize().x);
        item.setControl((Control)this.btnPreviewOffsets);
        this.btnPreviewOffsets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NativeTypeStructureEditorView.this.generatePreview();
            }
        });
        item = new ToolItem(bar, 2);
        Button btnCreate = UIUtil.createPushbox((Composite)bar, "Create", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextDialog dlg = new TextDialog(parent.getShell(), "Structure Name (global namespace)", "", null);
                String structName = dlg.open();
                if (structName != null) {
                    IStructureType t = null;
                    try {
                        t = unit.getTypeManager().createStructure(structName);
                        NativeTypeStructureEditorView.this.refreshTypesList();
                        NativeTypeStructureEditorView.this.setSelectedType(t);
                        NativeTypeStructureEditorView.this.view.setFocus();
                    }
                    catch (IllegalTypeNameException ex) {
                        UI.error(ex.getMessage());
                    }
                }
            }
        });
        btnCreate.pack();
        item.setWidth(btnCreate.getSize().x);
        item.setControl((Control)btnCreate);
        item = new ToolItem(bar, 2);
        Button btnHelp = UIUtil.createPushbox((Composite)bar, S.s(365), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg = "This widget is the native structure editor. The left-hand side represents the selected data structure layout.\n\nRight click on a row, at the given offset, to perform any of the following actions:\n- Define a field\n- Undefine a field\n- Rename a field\n- Create an array field\n- Set or select the type of a field\n\nYou may scroll down to access higher offsets.\n\nThe right-hand side represents a C-like representation of the structure.";
                MessageDialog.openInformation(parent.getShell(), "Controls", msg);
            }
        });
        btnHelp.pack();
        item.setWidth(btnHelp.getSize().x);
        item.setControl((Control)btnHelp);
        bar.pack();
        this.comboSelectedType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NativeTypeStructureEditorView.this.comboSelectedType.getSelectionIndex();
                if (index >= 0) {
                    String signature = NativeTypeStructureEditorView.this.comboSelectedType.getItem(index);
                    IStructureType t = (IStructureType)NativeTypeStructureEditorView.this.comboSelectedType.getData(signature);
                    NativeTypeStructureEditorView.this.onTypeSelectionChange(t);
                }
            }
        });
        SashForm sashContainer = new SashForm((Composite)this, 256);
        sashContainer.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        this.view = new InfiniTableView((Composite)sashContainer, 4, new String[]{"Offset", "Size", "Name", "Type", "Comment"});
        this.viewer = new InfiniTableViewer(this.view);
        this.provider = new StructFieldsProvider();
        this.viewer.setContentProvider(this.provider);
        this.viewer.setLabelProvider(new StructFieldLabelProvider(this.provider));
        this.viewer.setTopId(0L, false);
        this.viewer.setMinimumAllowedId(0L);
        this.viewer.setInput(null);
        this.widgetPreview = new Text((Composite)sashContainer, 2818);
        this.widgetPreview.setEditable(false);
        WidgetActionWrapper actionWrapper = new WidgetActionWrapper((Control)this.view.getTable());
        actionWrapper.registerAction(new StructEditorActionDefine(this));
        actionWrapper.registerAction(new StructEditorActionUndefine(this));
        actionWrapper.registerAction(new StructEditorActionRename(this));
        actionWrapper.registerAction(new StructEditorActionDefineArray(this));
        actionWrapper.registerAction(new StructEditorActionSetType(this));
        actionWrapper.registerAction(new StructEditorActionSelectType(this));
    }

    public INativeCodeUnit<?> getInputUnit() {
        return this.unit;
    }

    public IStructureType getInputType() {
        return this.type;
    }

    public void setCodefont(Font codefont) {
        this.codefont = codefont;
        if (codefont != null) {
            this.widgetPreview.setFont(codefont);
        }
    }

    void selectSource(int index) {
        if (index == 0) {
            this.typeSourceFlags = 1;
        }
        if (index == 1) {
            this.typeSourceFlags = 3;
        }
        this.refreshTypesList();
        this.viewer.setInput(null);
    }

    private void refreshTypesList() {
        this.comboSelectedType.removeAll();
        List<INativeType> types = TypeUtil.retrieveAvailableTypes(this.unit, this.typeSourceFlags);
        for (INativeType t : types) {
            if (!(t instanceof IStructureType)) continue;
            String sig = t.getSignature(true);
            this.comboSelectedType.add(sig);
            this.comboSelectedType.setData(sig, (Object)t);
        }
    }

    private void onTypeSelectionChange(IStructureType t) {
        if (t == null) {
            return;
        }
        this.setSelectedType(t);
    }

    void refresh() {
        int index0 = this.view.getTable().getSelectionIndex();
        this.viewer.refresh();
        this.generatePreview();
        IStructuredSelection sel1 = (IStructuredSelection)this.viewer.getSelection();
        if (sel1.isEmpty()) {
            this.view.getTable().setSelection(index0);
        }
    }

    public void setSelectedType(IStructureType type) {
        this.viewer.setInput(type);
        if (type != null) {
            int currentSourceIndex;
            boolean ownType = type.getTypeManager() == this.unit.getTypeManager();
            int wantedSourceIndex = ownType ? 0 : 1;
            if (wantedSourceIndex != (currentSourceIndex = this.comboSource.getSelectionIndex())) {
                this.comboSource.select(wantedSourceIndex);
                if (wantedSourceIndex == 0) {
                    this.typeSourceFlags = 1;
                }
                if (wantedSourceIndex == 1) {
                    this.typeSourceFlags = 3;
                }
                this.refreshTypesList();
            }
            int i = 0;
            for (String itemName : this.comboSelectedType.getItems()) {
                if (itemName.equals(type.getSignature(true))) {
                    this.comboSelectedType.select(i);
                }
                ++i;
            }
        }
        this.generatePreview();
    }

    public ItemEntry getSelectedEntry() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel.isEmpty() ? null : (ItemEntry)sel.getFirstElement();
    }

    void generatePreview() {
        IStructureType type = (IStructureType)this.viewer.getInput();
        if (type == null) {
            this.widgetPreview.setText("<No Preview>");
            return;
        }
        boolean previewDeep = this.btnPreviewDeep.getSelection();
        boolean previewOffsets = this.btnPreviewOffsets.getSelection();
        PrettyTypeFormatter f = new PrettyTypeFormatter(type);
        String str = f.format(previewDeep ? 10 : 1, previewOffsets);
        if (type.getPadding() != 1 || type.getAlignment() != 0) {
            str = String.format("// Size: %d, Padding: %d, Alignment: %d\n%s", type.getSize(), type.getPadding(), type.getAlignment(), str);
        }
        this.widgetPreview.setText(str);
    }

    class StructFieldsProvider
    extends AbstractInfiniTableSectionProvider {
        StructFieldsProvider() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            NativeTypeStructureEditorView.this.type = (IStructureType)newInput;
        }

        @Override
        public Object[] getRowElements(Object row) {
            ItemEntry e = (ItemEntry)row;
            return new Object[]{e.offset, e.size, e.name, e.type, e.comment};
        }

        @Override
        public Object[] get(Object inputElement, long id, int cnt) {
            Assert.a(NativeTypeStructureEditorView.this.type == (IStructureType)inputElement);
            return this.readFields(id, cnt);
        }

        private Object[] readFields(long id, int cnt) {
            int i;
            Assert.a(id >= 0L && cnt >= 0);
            long id1 = id + (long)cnt;
            ArrayList<ItemEntry> r = new ArrayList<ItemEntry>();
            List<? extends IStructureTypeField> fields = NativeTypeStructureEditorView.this.type.getFieldsWithGaps();
            long currentId = 0L;
            for (i = 0; i < fields.size() && id < id1; ++i) {
                long nextId;
                IStructureTypeField elt = fields.get(i);
                long l = nextId = elt.isSynthetic() ? currentId + (long)elt.getSize() : currentId + 1L;
                if (id >= currentId && id < nextId) {
                    if (!elt.isSynthetic()) {
                        Assert.a(id == currentId);
                        r.add(new ItemEntry(elt.getOffset(), elt.getSize(), elt.getName(), elt.getType(), elt.isBitfield() ? String.format("bitfield [%d:%d[", elt.getBitstart(), elt.getBitend()) : null, false));
                    } else {
                        int off = elt.getOffset() + (int)(id - currentId);
                        while (id < nextId && id < id1) {
                            r.add(new ItemEntry(off, 1, null, null, null, false));
                            ++off;
                            ++id;
                        }
                    }
                    currentId = ++id;
                    continue;
                }
                currentId = nextId;
            }
            if (id < id1) {
                long typeLastId = 0L;
                for (i = 0; i < fields.size(); ++i) {
                    IStructureTypeField elt = fields.get(i);
                    typeLastId += elt.isSynthetic() ? (long)elt.getSize() : 1L;
                }
                int delta = (int)((long)NativeTypeStructureEditorView.this.type.getSize() - typeLastId);
                while (id < id1) {
                    r.add(new ItemEntry((int)(id + (long)delta), 1, null, null, null, true));
                    ++id;
                }
            }
            return r.toArray();
        }
    }

    class StructFieldLabelProvider
    extends DefaultCellLabelProvider {
        public StructFieldLabelProvider(StructFieldsProvider provider) {
            super(provider);
        }

        @Override
        public void update(ViewerCell cell) {
            super.update(cell);
            if (NativeTypeStructureEditorView.this.codefont != null && (cell.getColumnIndex() == 0 || cell.getColumnIndex() == 1)) {
                cell.setFont(NativeTypeStructureEditorView.this.codefont);
            }
            ItemEntry entry = (ItemEntry)cell.getElement();
            if (!entry.slack && ThemeManager.getInstance().isStandardTheme()) {
                int rgb = entry.type != null ? 0xFFFFB0 : 0xFFFFE0;
                cell.setBackground(UIAssetManager.getInstance().getColor(rgb));
            }
        }

        @Override
        public String getStringAt(Object element, int key) {
            ItemEntry e = (ItemEntry)element;
            switch (key) {
                case 0: {
                    return String.format("+%08X", e.offset);
                }
                case 1: {
                    return String.format("%04X", e.size);
                }
                case 3: {
                    if (e.type == null) break;
                    return e.type.getSignature(true);
                }
            }
            return super.getStringAt(element, key);
        }
    }
}

