/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.core.IUnitContribution;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.iviewers.hover.IHoverableProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.hover.extend.HoverableHtml;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.util.base.HtmlTypedContentProperties;
import com.pnfsoftware.jeb.util.base.TypedContent;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Display;

public class TextHoverableProvider
implements IHoverableProvider {
    private static final ILogger logger = GlobalLog.getLogger(TextHoverableProvider.class);
    private Display display;
    private IRcpClientContext context;
    private IUnit unit;
    private ITextDocumentViewer iviewer;

    public TextHoverableProvider(IRcpClientContext context, IUnit unit, ITextDocumentViewer iviewer) {
        this.display = context.getDisplay();
        this.context = context;
        this.unit = unit;
        this.iviewer = iviewer;
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        logger.debug("Hovering on: %s", hoverRegion);
        TextItemRetriever retriever = new TextItemRetriever(this.iviewer, hoverRegion);
        UIExecutor.sync(this.display, (Runnable)retriever);
        ITextItem item = retriever.getItem();
        if (item != null) {
            List<IUnitContribution> contributions;
            String itemText = item.getText();
            long itemId = 0L;
            if (item instanceof IActionableItem) {
                itemId = ((IActionableItem)((Object)item)).getItemId();
            }
            if ((itemId != 0L || itemText != null) && this.unit instanceof IAddressableUnit && (contributions = RuntimeProjectUtil.findUnitContributions(this.context.getOpenedProject(), this.unit)) != null && !contributions.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                String anchor = null;
                for (IUnitContribution contrib : contributions) {
                    TypedContent content = null;
                    try {
                        content = contrib.getItemInformation((IAddressableUnit)this.unit, itemId, itemText);
                    }
                    catch (Exception e) {
                        logger.catchingSilent(e);
                    }
                    if (content == null) continue;
                    this.appendContribution(sb, content);
                    if (anchor == null) {
                        anchor = this.retrieveAnchor(content);
                    }
                    this.context.getTelemetry().record("contributionItemHover", "name", TextHoverableProvider.getPluginNameName(contrib));
                }
                return this.buildResult(sb, anchor);
            }
        }
        return null;
    }

    private Object buildResult(StringBuilder sb, String anchor) {
        if (sb.length() == 0) {
            return null;
        }
        if (anchor != null) {
            return new HoverableHtml(sb.toString(), anchor);
        }
        return sb.toString();
    }

    private void appendContribution(StringBuilder sb, TypedContent content) {
        if (content != null && !content.getText().isEmpty() && Strings.isContainedIn(content.getMimeType(), "text/html", "text/plain")) {
            sb.append(content.getText());
            sb.append("\n");
        }
    }

    @Override
    public Object getHoverInfoOnLocationRequest(String location, boolean top) {
        List<IUnitContribution> contributions;
        if (this.unit instanceof IAddressableUnit && (contributions = RuntimeProjectUtil.findUnitContributions(this.context.getOpenedProject(), this.unit)) != null && !contributions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String anchor = null;
            for (IUnitContribution contrib : contributions) {
                TypedContent content = null;
                try {
                    content = contrib.getLocationInformation((IAddressableUnit)this.unit, location);
                }
                catch (Exception e) {
                    logger.catchingSilent(e);
                }
                if (content == null) continue;
                this.appendContribution(sb, content);
                if (anchor == null) {
                    anchor = this.retrieveAnchor(content);
                }
                this.context.getTelemetry().record("contributionItemHoverNav", "name", TextHoverableProvider.getPluginNameName(contrib));
            }
            return this.buildResult(sb, anchor);
        }
        return null;
    }

    private String retrieveAnchor(TypedContent content) {
        HtmlTypedContentProperties props;
        if (content.getMimeType().equals("text/html") && content.getProperties() instanceof HtmlTypedContentProperties && (props = (HtmlTypedContentProperties)content.getProperties()) != null) {
            return props.getAnchor();
        }
        return null;
    }

    private static String getPluginNameName(IPlugin plugin) {
        if (plugin.getPluginInformation() != null && !Strings.isBlank(plugin.getPluginInformation().getName())) {
            return plugin.getPluginInformation().getName();
        }
        return plugin.getClass().getName();
    }

    static class TextItemRetriever
    extends UIRunnable {
        ITextDocumentViewer interactiveTextViewer;
        IRegion region;
        ITextItem item;

        public TextItemRetriever(ITextDocumentViewer iviewer, IRegion region) {
            this.interactiveTextViewer = iviewer;
            this.region = region;
            this.item = null;
        }

        @Override
        public void runi() {
            if (this.interactiveTextViewer.getTextWidget().isDisposed()) {
                this.item = null;
                return;
            }
            this.item = this.interactiveTextViewer.getItemAt(this.region.getOffset());
            String r = Strings.toString(this.item);
            logger.i(r, new Object[0]);
        }

        public ITextItem getItem() {
            return this.item;
        }
    }
}

