/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.text.HtmlFormatter;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IMetadataManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.IViewManager;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.FindTextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FindTextOptions;
import com.pnfsoftware.jeb.rcpclient.extensions.search.GraphicalTextFinder;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.BufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.IPositionListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextFindResult;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.TextDocumentLocationGenerator;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.ILocationListener;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.ItemStyleProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.Position;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextHoverableProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.UnitTextAnnotator;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class TextFragment
extends AbstractTextFragment {
    private static final ILogger logger = GlobalLog.getLogger(TextFragment.class);
    private List<ILocationListener> locationListeners = new ArrayList<ILocationListener>();
    private UnitTextAnnotator textAnnotator;
    private ItemStyleProvider tsa;
    private GraphicalTextFinder<InteractiveTextFindResult> finder;
    private ITextDocumentPart lastKnownPart = null;
    private ICoordinates lastKnownCoordinates = null;
    private Map<AddressConversionPrecision, JebAddress> lastKnownAddress = new HashMap<AddressConversionPrecision, JebAddress>();

    public TextFragment(Composite parent, int style, RcpClientContext context, IUnit unit, IRcpUnitView unitView, ITextDocument idoc) {
        super(parent, style, unit, unitView, context, idoc);
        this.setLayout((Layout)new FillLayout());
        this.iviewer = new InteractiveTextViewer(this, this.getFlags(unit), idoc, context.getPropertyManager(), this.getMetadataManager(unit));
        context.getFontManager().registerWidget((Control)this.iviewer.getTextWidget());
        context.getThemeManager().registerWidget((Control)this.iviewer.getTextWidget());
        this.tsa = new ItemStyleProvider(context.getStyleManager());
        this.tsa.registerTextViewer(this.iviewer);
        this.iviewer.setStyleAdapter(this.tsa);
        this.finder = new GraphicalTextFinder<InteractiveTextFindResult>(this.iviewer, context);
        UIState uiState = context.getUIState(unit);
        this.textAnnotator = new UnitTextAnnotator(uiState, this.iviewer);
        this.iviewer.initialize(true);
        this.iviewer.getTextWidget().setDoubleClickEnabled(false);
        this.iviewer.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TextFragment.this.requestOperation(new OperationRequest(Operation.ITEM_FOLLOW));
            }
        });
        this.setPrimaryWidget((Control)this.iviewer.getTextWidget());
        this.iviewer.addPositionListener(new IPositionListener(){

            @Override
            public void positionChanged(ITextDocumentViewer viewer, ICoordinates coordinates, int focusChange) {
                Assert.a(viewer == TextFragment.this.iviewer);
                TextFragment.this.onPositionChanged(coordinates, focusChange);
            }

            @Override
            public void positionUnchangedAttemptBreakout(ITextDocumentViewer viewer, int direction) {
            }
        });
        this.iviewer.refreshStyles();
        this.iviewer.setHoverText(new TextHoverableProvider(context, unit, this.iviewer));
        this.addStandardContextMenu(new int[0]);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextFragment.this.iviewer.dispose();
                TextFragment.this.textAnnotator.dispose();
            }
        });
    }

    private int getFlags(IUnit unit) {
        int flags = 0;
        if (!(unit instanceof ISourceUnit)) {
            flags |= 1;
        }
        if (!Licensing.isDebugBuild() && !this.context.isDevelopmentMode()) {
            flags |= 2;
        }
        return flags;
    }

    private IMetadataManager getMetadataManager(IUnit unit) {
        IMetadataManager mm = null;
        if (unit instanceof IInteractiveUnit) {
            if (unit instanceof ISourceUnit) {
                return null;
            }
            mm = ((IInteractiveUnit)unit).getMetadataManager();
        }
        return mm;
    }

    private void onPositionChanged(ICoordinates coord, int focusChange) {
        if (OSType.determine().isWindows() || focusChange == 0) {
            this.context.refreshHandlersStates();
        }
        TextDocumentLocationGenerator locationGenerator = new TextDocumentLocationGenerator(this.unit, this.iviewer);
        String address = locationGenerator.getAddress(coord);
        String status = locationGenerator.generateStatus(coord);
        this.context.getStatusIndicator().setText(status);
        for (ILocationListener listener : this.locationListeners) {
            listener.locationChanged(address);
        }
    }

    public void addLocationListener(ILocationListener listener) {
        this.locationListeners.add(listener);
    }

    public void removeLocationListener(ILocationListener listener) {
        this.locationListeners.remove(listener);
    }

    @Override
    public ITextDocument getDocument() {
        return this.idoc;
    }

    public ICoordinates getCurrentCoordinates() {
        return this.iviewer.getCaretCoordinates();
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return this.tsa.isActiveItem(item);
    }

    @Override
    public IItem getActiveItem() {
        return this.tsa.getActiveItem();
    }

    @Override
    public String getActiveAddress() {
        return this.getActiveAddress(AddressConversionPrecision.FINE);
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        ICoordinates coord = this.iviewer.getCaretCoordinates();
        return this.getAddressAt(precision, coord);
    }

    @Override
    public String getActiveItemAsText() {
        ITextItem item;
        ILine line;
        ICoordinates coords = this.getCurrentCoordinates();
        if (this.getActiveItem() != null && coords != null && (line = TextPartUtil.getLineAt(this.iviewer.getCurrentDocumentPart(), coords)) != null && (item = TextPartUtil.getItemAt(line, coords.getColumnOffset())) != null) {
            return line.getText().subSequence(item.getOffset(), item.getOffsetEnd()).toString();
        }
        return null;
    }

    public String getAddressAt(AddressConversionPrecision precision, ICoordinates coord) {
        JebAddress lastJebAddress;
        if (coord == null) {
            return null;
        }
        if (this.lastKnownPart != this.iviewer.getCurrentDocumentPart() || !coord.equals(this.lastKnownCoordinates)) {
            this.lastKnownPart = this.iviewer.getCurrentDocumentPart();
            this.lastKnownCoordinates = coord;
            this.lastKnownAddress.clear();
        }
        if ((lastJebAddress = this.lastKnownAddress.get((Object)precision)) == null) {
            String lastAddress = this.idoc.coordinatesToAddress(coord, precision);
            lastJebAddress = new JebAddress(lastAddress, precision);
            this.lastKnownAddress.put(precision, lastJebAddress);
        }
        return lastJebAddress.getAddress();
    }

    @Override
    public Position getActivePosition() {
        String address = this.getActiveAddress();
        if (address == null) {
            return null;
        }
        BufferPoint vp = this.iviewer.getCaretViewportPoint();
        return new Position(address, vp);
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        try {
            ICoordinates coord = this.idoc.addressToCoordinates(address);
            if (coord != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.catching(e);
        }
        if (this.viewNavigatorHelper != null) {
            return this.viewNavigatorHelper.canHandleAddress(address);
        }
        return false;
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record) {
        boolean success;
        ICoordinates coord = null;
        try {
            coord = this.idoc.addressToCoordinates(address);
        }
        catch (Exception e) {
            logger.catching(e);
        }
        GlobalPosition pos0 = null;
        IViewManager viewManager = this.getViewManager();
        if (viewManager != null && record) {
            pos0 = viewManager.getCurrentGlobalPosition();
        }
        if (coord == null) {
            success = this.viewNavigatorHelper != null && this.viewNavigatorHelper.navigateTo(address, viewManager, false);
        } else {
            BufferPoint vp = null;
            if (extra instanceof BufferPoint) {
                vp = (BufferPoint)extra;
            }
            success = this.iviewer.setCaretCoordinates(coord, vp, true);
        }
        if (success && pos0 != null) {
            viewManager.recordGlobalPosition(pos0);
            this.context.refreshHandlersStates();
        }
        return success;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        if (this.iviewer.verifyOperation(req)) {
            return true;
        }
        switch (req.getOperation()) {
            case FIND: {
                return true;
            }
            case FIND_NEXT: {
                return this.finder != null;
            }
            case JUMP_TO: {
                return true;
            }
            case ITEM_FOLLOW: 
            case ITEM_PREVIOUS: 
            case ITEM_NEXT: {
                return this.getActiveItem() instanceof IActionableItem;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        if (this.iviewer.doOperation(req)) {
            return true;
        }
        if (!req.proceed()) {
            return false;
        }
        switch (req.getOperation()) {
            case FIND: {
                FindTextDialog dlg = FindTextDialog.getInstance(this);
                if (dlg != null) {
                    dlg.setFocus();
                    return true;
                }
                FindTextOptions opt = this.iviewer.getFindTextOptions(true);
                boolean searchCurrentSelection = true;
                String selection = this.iviewer.getTextWidget().getSelectionText();
                boolean retrieveSelection = false;
                if (searchCurrentSelection) {
                    if (!Strings.isBlank(selection)) {
                        retrieveSelection = true;
                    }
                } else if (Strings.isBlank(opt.getSearchString())) {
                    retrieveSelection = true;
                }
                if (retrieveSelection && !Strings.isBlank(selection)) {
                    int endline = selection.indexOf("\n");
                    if (endline == 0) {
                        int firstIndex = 0;
                        while (firstIndex == endline && firstIndex + 1 < selection.length()) {
                            endline = selection.indexOf("\n", ++firstIndex);
                        }
                        selection = firstIndex + 1 == selection.length() ? null : (endline >= 0 ? selection.substring(firstIndex, endline) : selection.substring(firstIndex));
                    } else if (endline > 0) {
                        selection = selection.substring(0, endline);
                    }
                    if (selection != null) {
                        opt.setSearchString(selection);
                    }
                }
                TextHistory history = RcpClientContext.getStandardFindTextHistory(this.context);
                dlg = new FindTextDialog(this.getShell(), this.finder, history, false, (Control)this, this.getUnit().getName());
                dlg.open(this);
                return true;
            }
            case FIND_NEXT: {
                this.finder.search(null);
                return true;
            }
            case JUMP_TO: {
                return this.doJumpTo();
            }
            case ITEM_FOLLOW: {
                return this.doItemFollow();
            }
            case ITEM_NEXT: {
                IItem item = this.getActiveItem();
                if (!(item instanceof IActionableItem)) {
                    return false;
                }
                return this.nextItem((IActionableItem)((Object)item));
            }
            case ITEM_PREVIOUS: {
                IItem item = this.getActiveItem();
                if (!(item instanceof IActionableItem)) {
                    return false;
                }
                return this.previousItem((IActionableItem)((Object)item));
            }
        }
        return false;
    }

    private boolean nextItem(IActionableItem _item) {
        if (_item == null || _item.getItemId() == 0L) {
            return false;
        }
        long _id = _item.getItemId();
        logger.debug("Searching for next item in current part: %s", _item);
        GlobalPosition pos0 = this.getViewManager() == null ? null : this.getViewManager().getCurrentGlobalPosition();
        ITextDocumentPart part = this.iviewer.getCurrentDocumentPart();
        long anchorId = TextPartUtil.getFirstAnchorId(part);
        if (anchorId < 0L) {
            return false;
        }
        ICoordinates _coord = this.iviewer.getCaretCoordinates();
        int _line = TextPartUtil.coordinatesToLineIndex(part, _coord);
        int _column = _coord.getColumnOffset();
        List<? extends ILine> lines = part.getLines();
        for (int lineIndex = _line; lineIndex < lines.size(); ++lineIndex) {
            ILine line = lines.get(lineIndex);
            for (ITextItem iTextItem : line.getItems()) {
                if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != _id || lineIndex == _line && iTextItem.getOffset() <= _column) continue;
                if (pos0 != null) {
                    this.getViewManager().recordGlobalPosition(pos0);
                }
                Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                return this.iviewer.setCaretCoordinates(coord, null, true);
            }
        }
        logger.debug("Next item in current part was not found", new Object[0]);
        return false;
    }

    private boolean previousItem(IActionableItem _item) {
        if (_item == null || _item.getItemId() == 0L) {
            return false;
        }
        long _id = _item.getItemId();
        logger.debug("Searching for previous item in current part: %s", _item);
        GlobalPosition pos0 = this.getViewManager() == null ? null : this.getViewManager().getCurrentGlobalPosition();
        ITextDocumentPart part = this.iviewer.getCurrentDocumentPart();
        long anchorId = TextPartUtil.getFirstAnchorId(part);
        if (anchorId < 0L) {
            return false;
        }
        ICoordinates _coord = this.iviewer.getCaretCoordinates();
        int _line = TextPartUtil.coordinatesToLineIndex(part, _coord);
        int _column = _coord.getColumnOffset();
        List<? extends ILine> lines = part.getLines();
        for (int lineIndex = _line; lineIndex >= 0; --lineIndex) {
            ILine line = lines.get(lineIndex);
            for (ITextItem iTextItem : line.getItems()) {
                if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != _id || lineIndex == _line && iTextItem.getOffset() + iTextItem.getLength() > _column) continue;
                if (pos0 != null) {
                    this.getViewManager().recordGlobalPosition(pos0);
                }
                Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                return this.iviewer.setCaretCoordinates(coord, null, true);
            }
        }
        logger.debug("Previous item in current part was not found", new Object[0]);
        return false;
    }

    public List<ICoordinates> collectItemCoordinates(long itemId) {
        ArrayList<ICoordinates> r = new ArrayList<ICoordinates>();
        long anchorId = TextPartUtil.getFirstAnchorId(this.iviewer.getCurrentDocumentPart());
        if (anchorId >= 0L) {
            int lineIndex = 0;
            for (ILine iLine : this.iviewer.getCurrentDocumentPart().getLines()) {
                for (ITextItem iTextItem : iLine.getItems()) {
                    if (!(iTextItem instanceof IActionableItem) || ((IActionableItem)((Object)iTextItem)).getItemId() != itemId) continue;
                    Coordinates coord = new Coordinates(anchorId, lineIndex, iTextItem.getOffset());
                    r.add(coord);
                }
                ++lineIndex;
            }
        }
        return r;
    }

    public void setCaretCoordinates(ICoordinates coord) {
        this.iviewer.setCaretCoordinates(coord, null, true);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.iviewer.getTextWidget().setMenu(menu);
    }

    public boolean setFocus() {
        return this.iviewer.getTextWidget().setFocus();
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.exportAsText(false));
    }

    @Override
    public String exportAsText(boolean formatAsHtml) {
        if (formatAsHtml) {
            HtmlFormatter formatter = new HtmlFormatter(this.idoc, this.context.getStyleManager(), this.unit.getName(), true);
            return formatter.generate();
        }
        ITextDocumentPart wholePart = this.idoc.getDocumentPart(this.idoc.getFirstAnchor(), Integer.MAX_VALUE);
        return TextPartUtil.buildRawTextFromPart(wholePart);
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TEXT;
    }
}

