/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.IImageSource;
import com.pnfsoftware.jeb.rcpclient.extensions.ImageViewer;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ImageFragment
extends AbstractUnitFragment<IBinaryUnit> {
    private static final ILogger logger = GlobalLog.getLogger(ImageFragment.class);
    private ImageViewer viewer;
    private IImageSource doc;

    public ImageFragment(Composite parent, int flags, RcpClientContext context, IBinaryUnit unit) {
        super(parent, flags, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        this.doc = new StaticImageDocument(this.getDisplay(), unit);
        this.viewer = new ImageViewer(this);
        this.viewer.setInput(this.doc);
        this.setPrimaryWidget((Control)this.viewer.getControl());
    }

    public ImageViewer getViewer() {
        return this.viewer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] export() {
        IInput input = ((IBinaryUnit)this.getUnit()).getInput();
        byte[] data = null;
        try (InputStream in = input.getStream();){
            byte[] byArray = data = IO.readInputStream(in);
            return byArray;
        }
        catch (IOException e) {
            logger.catching(e);
            return null;
        }
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.IMAGE;
    }

    static class StaticImageDocument
    extends EventSource
    implements IImageSource {
        private Image image;

        public StaticImageDocument(Display display, IBinaryUnit unit) {
            try (InputStream stream = unit.getInput().getStream();){
                this.image = new Image((Device)display, stream);
            }
            catch (Exception e) {
                logger.debug("Image rendering error: %s", e);
                logger.error("Cannot render image for unit %s, using a dummy 1x1 pixel image instead", unit);
                this.image = new Image((Device)display, new Rectangle(0, 0, 1, 1));
            }
        }

        @Override
        public Image getImage() {
            return this.image;
        }
    }
}

