/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.tree;

import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.rcpclient.iviewers.IStyleProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.InteractiveTreeViewer;
import com.pnfsoftware.jeb.rcpclient.util.regex.IValueProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

public class LabelProvider
extends StyledCellLabelProvider
implements IValueProvider {
    private InteractiveTreeViewer viewer;

    public LabelProvider(InteractiveTreeViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void update(ViewerCell cell) {
        Object e = cell.getElement();
        if (e instanceof INode) {
            Style style;
            IStyleProvider styleAdapter;
            INode n = (INode)e;
            int index = cell.getColumnIndex();
            cell.setText(Strings.safe(this.getStringAt(e, index)));
            if (index == 0 && (styleAdapter = this.viewer.getStyleAdapter()) != null && (style = this.viewer.getStyleAdapter().getStyle(n)) != null) {
                cell.setForeground(style.getColor());
                cell.setBackground(style.getBackgroungColor());
            }
        }
        super.update(cell);
    }

    @Override
    public String getString(Object element) {
        return this.getStringAt(element, 0);
    }

    @Override
    public String getStringAt(Object element, int index) {
        if (element instanceof INode) {
            INode n = (INode)element;
            if (index >= 1) {
                int i = index - 1;
                String[] additionalLabels = n.getAdditionalLabels();
                if (additionalLabels != null && i < additionalLabels.length) {
                    return Strings.replaceNewLines(additionalLabels[i], " / ");
                }
            } else if (index == 0) {
                return Strings.replaceNewLines(n.getLabel(), " / ");
            }
        }
        return null;
    }
}

