/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractFilteredViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredViewerComparator;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FilteredTableViewer
extends AbstractFilteredViewer<Table, TableViewer> {
    public FilteredTableViewer(AbstractFilteredView<Table> widget) {
        super(widget);
        this.comparator = new FilteredViewerComparator(Strings.getDefaultComparator(), this);
        ((TableViewer)this.getViewer()).setComparator(this.comparator);
        int colIndex = 0;
        for (TableColumn col : widget.getElement().getColumns()) {
            col.addSelectionListener((SelectionListener)new ColumnSelectionListener(colIndex, col));
            ++colIndex;
        }
    }

    @Override
    protected TableViewer buildViewer(AbstractFilteredView<Table> widget) {
        if ((widget.getElement().getStyle() & 0x20) == 0) {
            return new TableViewer(widget.getElement());
        }
        return new CheckboxTableViewer(widget.getElement());
    }

    @Override
    protected AbstractFilteredFilter buildFilter(TableViewer viewer) {
        return new Filter(viewer);
    }

    public void setInput(Object input, boolean pack) {
        super.setInput(input);
        if (pack) {
            this.getWidget().pack(false);
        }
    }

    public void setContentProvider(IFilteredTableContentProvider provider) {
        super.setContentProvider(provider);
    }

    public IFilteredTableContentProvider getProvider() {
        return (IFilteredTableContentProvider)this.provider;
    }

    public void setCheckStateProvider(ICheckStateProvider provider) {
        if (!(this.getViewer() instanceof CheckboxTableViewer)) {
            throw new RuntimeException();
        }
        ((CheckboxTableViewer)this.getViewer()).setCheckStateProvider(provider);
    }

    class Filter
    extends AbstractFilteredFilter {
        public Filter(StructuredViewer viewer) {
            super(viewer);
        }

        @Override
        public boolean select(Viewer viewer, Object parent, Object element) {
            return this.isElementMatch(element);
        }

        @Override
        public IFilteredContentProvider getProvider() {
            return FilteredTableViewer.this.getProvider();
        }
    }

    class ColumnSelectionListener
    extends SelectionAdapter {
        int columnIndex;
        TableColumn column;

        public ColumnSelectionListener(int columnIndex, TableColumn column) {
            this.columnIndex = columnIndex;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (FilteredTableViewer.this.comparator != null) {
                FilteredTableViewer.this.comparator.setColumn(this.columnIndex);
                int dir = FilteredTableViewer.this.comparator.getDirection();
                ((Table)FilteredTableViewer.this.getWidget().getElement()).setSortDirection(dir);
                ((Table)FilteredTableViewer.this.getWidget().getElement()).setSortColumn(this.column);
                FilteredTableViewer.this.refresh();
            }
        }
    }
}

