/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.binding;

import com.pnfsoftware.jeb.core.properties.impl.SimplePropertyManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.swt.SWT;

public class KeyShortcutsManager {
    private static final ILogger logger = GlobalLog.getLogger(KeyShortcutsManager.class);
    SimplePropertyManager props;
    Map<String, Integer> map = new HashMap<String, Integer>();
    Map<Integer, String> rmap = new HashMap<Integer, String>();

    public KeyShortcutsManager(SimplePropertyManager props) {
        this.props = props;
        for (String actionId : props.getConfiguration().getAllPropertyKeys()) {
            int keycode;
            if (Strings.isBlank(actionId)) {
                logger.error("Action id is blank \"%s\"", actionId);
            }
            if ((keycode = this.processEntry(actionId)) == 0) {
                logger.error("Illegal action definition \"%s=%s\"", actionId, props.getString(actionId));
            }
            if (this.map.containsKey(actionId)) {
                logger.error("Action \"%s\" is already defined", actionId);
            }
            if (this.rmap.containsKey(keycode)) {
                logger.error("Action \"%s\" is attempting to use a key reserved by action \"%s\"", actionId, this.rmap.get(keycode));
            }
            this.map.put(actionId, keycode);
            this.rmap.put(keycode, actionId);
        }
    }

    public boolean isReserved(int keycode) {
        return this.getActionIdForKeycode(keycode) != null;
    }

    public String getActionIdForKeycode(int keycode) {
        return this.rmap.get(keycode);
    }

    public int getShortcutKeycode(String actionId) {
        Integer r = this.map.get(actionId);
        return r == null ? 0 : r;
    }

    private int processEntry(String actionId) {
        if (Strings.isBlank(actionId)) {
            return 0;
        }
        String s = this.props.getString(actionId);
        if (Strings.isBlank(s)) {
            return 0;
        }
        return KeyShortcutsManager.parseShortcut(s);
    }

    public static int parseShortcut(String s) {
        KeyStroke ks;
        try {
            s = s.trim();
            s = s.replace("MOD", "M").replace("Mod", "M").replace("mod", "M");
            s = s.replace("CMD", "COMMAND").replace("Cmd", "COMMAND").replace("cmd", "COMMAND");
            ks = KeyStroke.getInstance(s.trim());
        }
        catch (ParseException e) {
            return 0;
        }
        int keycode = ks.getModifierKeys() | ks.getNaturalKey();
        if ((keycode & ~SWT.MODIFIER_MASK) == 0) {
            return 0;
        }
        return keycode;
    }
}

