/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.rcpclient.dialogs.FindTextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.search.GraphicalTextFinder;
import com.pnfsoftware.jeb.rcpclient.extensions.search.SimpleTextFindResults;
import com.pnfsoftware.jeb.rcpclient.extensions.search.StyledTextFindImpl;
import com.pnfsoftware.jeb.rcpclient.parts.MultiInterpreter;
import com.pnfsoftware.jeb.util.collect.ItemHistory;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.AutocompletionResult;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.interpreter.ICommandInterpreter;
import com.pnfsoftware.jeb.util.interpreter.InterpreterHistory;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ConsoleViewer
extends Viewer
implements IOperable {
    private static final ILogger logger = GlobalLog.getLogger(ConsoleViewer.class, Integer.MAX_VALUE);
    public static final String DEFAULT_PROMPT = "> ";
    private StyledText console;
    private StyledTextFindImpl findimpl;
    private GraphicalTextFinder<SimpleTextFindResults> finder;
    private ICommandInterpreter interpreter;
    private InterpreterHistory history;
    private String prompt = "> ";
    private boolean shouldSetNewPrompt;
    private String newPrompt;
    private boolean allowEmptyCommands = true;
    private final AtomicBoolean previousKeyWasTab = new AtomicBoolean(false);

    public ConsoleViewer(Composite parent, int style) {
        this.console = UIUtil.createStyledText(parent, (style &= 0x800) | 2 | 0x200 | 0x100);
        this.console.setFont(JFaceResources.getTextFont());
        this.findimpl = new StyledTextFindImpl(this.console);
        this.finder = new GraphicalTextFinder<SimpleTextFindResults>(this.findimpl, null);
        this.console.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (ConsoleViewer.this.console.isTextSelected() && ((ConsoleViewer)ConsoleViewer.this).console.getSelection().x < ConsoleViewer.this.getFirstValidCaretPosition()) {
                    e.doit = false;
                }
            }
        });
        this.console.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                int key = e.keyCode;
                int mask = e.stateMask;
                logger.i("key=%Xh mask=%Xh", key, e.stateMask);
                if (mask == 0 && (key & SWT.MODIFIER_MASK) != 0) {
                    return;
                }
                if (e.stateMask == SWT.MOD1) {
                    if (key == 108) {
                        ConsoleViewer.this.clearConsole();
                        return;
                    }
                    if (key == 99) {
                        return;
                    }
                    if (key == 118) {
                        String s;
                        if (!ConsoleViewer.this.isValidCaret()) {
                            ConsoleViewer.this.setCaretEnd();
                        }
                        if ((s = UIUtil.getTextFromClipboard()) != null && s.length() > 0) {
                            s = Strings.splitLines(s)[0];
                            logger.i("Pasting: %s", s);
                            ConsoleViewer.this.replaceSelection(s);
                        }
                        ConsoleViewer.this.showInputLine();
                        e.doit = false;
                        return;
                    }
                }
                if (e.stateMask == SWT.MOD2 && UIUtil.isArrowKey(key)) {
                    return;
                }
                if (!ConsoleViewer.this.isValidCaret()) {
                    ConsoleViewer.this.setCaretEnd();
                }
                if (key == 9) {
                    e.doit = false;
                    if (ConsoleViewer.this.previousKeyWasTab.get()) {
                        ConsoleViewer.this.previousKeyWasTab.set(false);
                        AutocompletionResult auto = ConsoleViewer.this.interpreter.autoComplete(ConsoleViewer.this.getCurrentUserInput());
                        if (auto == null || auto.getAutocompletes() == null || auto.getAutocompletes().isEmpty()) {
                            return;
                        }
                        ConsoleViewer.this.executeAutoComplete(auto);
                    } else {
                        ConsoleViewer.this.previousKeyWasTab.set(true);
                    }
                } else {
                    ConsoleViewer.this.previousKeyWasTab.set(false);
                }
                if (key == 0x1000001 || key == 0x1000002) {
                    ItemHistory h = ConsoleViewer.this.getHistoryData();
                    if (h != null) {
                        String s;
                        String string = s = key == 0x1000001 ? (String)h.getPrevious() : (String)h.getNext();
                        if (ConsoleViewer.this.getCurrentUserInput().equals(s)) {
                            s = key == 0x1000001 ? (String)h.getPrevious() : (String)h.getNext();
                        } else if (key == 0x1000002 && s == null) {
                            s = "";
                        }
                        if (s != null) {
                            ConsoleViewer.this.clearLine();
                            ConsoleViewer.this.appendText(s);
                            ConsoleViewer.this.setCaretEnd();
                        }
                    }
                    e.doit = false;
                } else if (key == 0x1000005 || key == 0x1000006) {
                    e.doit = false;
                } else if (key == 0x1000003) {
                    if (ConsoleViewer.this.getCaretColumnOffset() <= ConsoleViewer.this.prompt.length()) {
                        ConsoleViewer.this.console.setSelection(ConsoleViewer.this.console.getCaretOffset());
                        e.doit = false;
                    }
                } else if (key == 8) {
                    int thres = ConsoleViewer.this.prompt.length();
                    if (ConsoleViewer.this.console.getSelectionCount() == 0) {
                        ++thres;
                    }
                    if (ConsoleViewer.this.getCaretColumnOffset() < thres) {
                        ConsoleViewer.this.console.setSelection(ConsoleViewer.this.console.getCaretOffset());
                        e.doit = false;
                    }
                } else if (key == 0x1000007) {
                    if (e.stateMask == SWT.MOD2) {
                        if (!ConsoleViewer.this.isValidCaret()) {
                            ConsoleViewer.this.setCaretEnd();
                        }
                        ConsoleViewer.this.console.setSelection(ConsoleViewer.this.console.getCaretOffset(), ConsoleViewer.this.getFirstValidCaretPosition());
                    } else {
                        ConsoleViewer.this.setCaretBegin();
                    }
                    e.doit = false;
                } else if (key == 13 || key == 0x1000050) {
                    String userInput = ConsoleViewer.this.getCurrentUserInput();
                    logger.i("User requested execution of command: \"%s\"", userInput);
                    if (ConsoleViewer.this.allowEmptyCommands || !userInput.trim().isEmpty()) {
                        ConsoleViewer.this.executeCommand(userInput);
                    }
                    ConsoleViewer.this.showInputLine();
                    e.doit = false;
                }
            }
        });
        this.generatePromp();
    }

    public void setFont(Font font) {
        this.console.setFont(font);
    }

    public Font getFont() {
        return this.console.getFont();
    }

    public void setInterpreter(ICommandInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public ICommandInterpreter getInterpreter() {
        return this.interpreter;
    }

    public void setAllowEmptyCommands(boolean enabled) {
        this.allowEmptyCommands = enabled;
    }

    public boolean getAllowEmptyCommands() {
        return this.allowEmptyCommands;
    }

    public void updatePromptAfterCommand(String prompt) {
        this.shouldSetNewPrompt = true;
        this.newPrompt = prompt;
    }

    public void updatePrompt(String prompt) {
        String currentPrompt;
        if (prompt == null) {
            prompt = DEFAULT_PROMPT;
        }
        if (prompt.equals(currentPrompt = this.getPrompt())) {
            return;
        }
        String line = this.getLastLine();
        String currentCommand = "";
        if (line.startsWith(currentPrompt)) {
            currentCommand = line.substring(currentPrompt.length());
        }
        int caretOffset = this.console.getCaretOffset();
        this.removeTrailingCharacters(line.length());
        this.appendText(prompt);
        this.appendText(currentCommand);
        if (this.console.getCaretOffset() != caretOffset) {
            this.console.setCaretOffset(caretOffset + prompt.length() - currentPrompt.length());
        }
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    private void generatePromp() {
        this.appendText(this.getPrompt());
        this.setCaretEnd();
        this.updateNewPrompt();
    }

    public void updateNewPrompt() {
        if (this.shouldSetNewPrompt) {
            this.updatePrompt(this.newPrompt);
            this.shouldSetNewPrompt = false;
            this.setCaretEnd();
        }
    }

    public void clearConsole() {
        this.setText("", true);
        this.generatePromp();
    }

    public void clearLine() {
        this.removeTrailingCharacters(this.getCurrentUserInput().length());
    }

    private int getCaretColumnOffset() {
        int offset = this.console.getCaretOffset();
        int lineIndex = this.console.getLineAtOffset(offset);
        return offset - this.console.getOffsetAtLine(lineIndex);
    }

    private String getLastLine() {
        return this.console.getLine(this.console.getLineCount() - 1);
    }

    private String getCurrentUserInput() {
        String raw = this.console.getLine(this.console.getLineCount() - 1);
        if (raw.length() < this.getPrompt().length()) {
            return "";
        }
        return raw.substring(this.getPrompt().length());
    }

    public void simulateInputAndExecute(String command) {
        this.setCaretEnd();
        this.appendText(command);
        this.executeCommand(command);
    }

    private void executeCommand(String command) {
        InterpreterHistory h;
        if (!command.trim().isEmpty() && (h = this.getHistory()) != null) {
            h.get().add(command);
        }
        if (this.interpreter == null) {
            this.appendText("\rInterpreter is unavailable\r");
        } else {
            ExecutionResult result = this.interpreter.executeCommand(command);
            String msg = "\r";
            if (this.interpreter.shouldDisplayRawResults()) {
                if (result.getMessage() != null && !Strings.isBlank(msg = msg + Strings.rtrim(result.getMessage()))) {
                    msg = msg + "\r";
                }
            } else if (result.getCode() != 0) {
                msg = msg + String.format("%d: ", result.getCode());
                msg = !Strings.isBlank(result.getMessage()) ? msg + Strings.rtrim(result.getMessage()) : msg + "An error occurred";
                msg = msg + String.format(" (\"%s\")", command);
                msg = msg + "\r";
            } else if (result.getMessage() != null && !Strings.isBlank(msg = msg + Strings.rtrim(result.getMessage()))) {
                msg = msg + "\r";
            }
            this.appendText(msg);
        }
        this.generatePromp();
    }

    private void appendText(String text) {
        this.console.append(text);
    }

    private void executeAutoComplete(AutocompletionResult auto) {
        String userInput = this.getCurrentUserInput();
        if (auto.getAutocompletes().size() > 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("\r");
            int maxSize = 0;
            for (String tok : auto.getAutocompletes()) {
                maxSize = Math.max(maxSize, tok.length());
            }
            maxSize += 4;
            int perLine = 80;
            int currentLine = 0;
            for (String tok : auto.getAutocompletes()) {
                if (currentLine + maxSize > perLine) {
                    msg.append('\r');
                    currentLine = 0;
                }
                msg.append(String.format("%-" + maxSize + "s", tok));
                currentLine += maxSize;
            }
            msg.append('\r');
            this.appendText(msg.toString());
            this.generatePromp();
            int from = userInput.lastIndexOf(auto.getLastSeparator());
            if (from == -1) {
                this.appendText(userInput);
            } else {
                this.appendText(userInput.substring(0, from + 1));
                this.appendText(this.getCommon(auto.getAutocompletes()));
            }
        } else {
            int from = userInput.lastIndexOf(auto.getLastSeparator()) + 1;
            String autocompl = auto.getAutocompletes().get(0);
            int fromAuto = userInput.length() - from;
            this.appendText(autocompl.substring(fromAuto));
        }
        this.setCaretEnd();
        this.showInputLine();
    }

    private String getCommon(List<String> autocompletes) {
        String reference = autocompletes.get(0);
        for (int i = 1; i < autocompletes.size(); ++i) {
            String comparison = autocompletes.get(i);
            int commonLength = this.getCommonLength(reference, comparison);
            if (reference.length() > commonLength) {
                reference = reference.substring(0, commonLength);
            }
            if (commonLength != 0) continue;
            return reference;
        }
        return reference;
    }

    private int getCommonLength(String reference, String comparison) {
        int i;
        for (i = 0; i < reference.length() && i < comparison.length(); ++i) {
            if (reference.charAt(i) == comparison.charAt(i)) continue;
            return i;
        }
        return i;
    }

    private void replaceSelection(String text) {
        int offset = -1;
        if (this.console.getSelectionCount() == 0) {
            offset = this.console.getCaretOffset() + text.length();
        }
        this.console.insert(text);
        if (offset >= 0) {
            this.console.setCaretOffset(offset);
        }
    }

    private void removeTrailingCharacters(int count) {
        String text = this.console.getText();
        this.console.replaceTextRange(text.length() - count, count, "");
    }

    private void setText(String text, boolean show) {
        this.console.setText(text);
        if (show) {
            this.showInputLine();
        }
    }

    private void showInputLine() {
        this.console.setTopIndex(this.console.getLineCount() - 1);
    }

    private void setCaretBegin() {
        int offset = this.console.getCaretOffset();
        int lineIndex = this.console.getLineAtOffset(offset);
        this.console.setCaretOffset(this.console.getOffsetAtLine(lineIndex) + this.getPrompt().length());
    }

    private int getFirstValidCaretPosition() {
        return this.console.getOffsetAtLine(this.console.getLineCount() - 1) + this.getPrompt().length();
    }

    private boolean isValidCaret() {
        int offset = this.console.getCaretOffset();
        if (offset == this.console.getText().length()) {
            return true;
        }
        int lineIndex = this.console.getLineAtOffset(offset);
        if (lineIndex != this.console.getLineCount() - 1) {
            return false;
        }
        int delta = offset - this.console.getOffsetAtLine(lineIndex);
        return delta >= this.getPrompt().length();
    }

    private void setCaretEnd() {
        this.console.setCaretOffset(this.console.getText().length());
    }

    @Override
    public Control getControl() {
        return this.console;
    }

    @Override
    public void setInput(Object input) {
        if (!(input instanceof ICommandInterpreter)) {
            throw new IllegalArgumentException();
        }
        this.setInterpreter((ICommandInterpreter)input);
    }

    @Override
    public ICommandInterpreter getInput() {
        return this.interpreter;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
    }

    @Override
    public ISelection getSelection() {
        return null;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case SELECT_ALL: {
                return true;
            }
            case COPY: {
                return this.console.isTextSelected();
            }
            case CLEAR: {
                return true;
            }
            case FIND: {
                return true;
            }
            case FIND_NEXT: {
                return this.finder.isReady();
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case SELECT_ALL: {
                this.console.selectAll();
                return true;
            }
            case COPY: {
                this.console.copy();
                return true;
            }
            case CLEAR: {
                this.clearConsole();
                return true;
            }
            case FIND: {
                String selectedText = this.console.getSelectionText();
                if (selectedText.length() > 0) {
                    this.findimpl.getFindTextOptions(false).setSearchString(selectedText);
                }
                FindTextDialog dlg = new FindTextDialog(this.console.getShell(), this.finder, null);
                dlg.open();
                return true;
            }
            case FIND_NEXT: {
                this.finder.search(null);
                return true;
            }
        }
        return false;
    }

    private ItemHistory<String> getHistoryData() {
        InterpreterHistory h = this.getHistory();
        return h == null ? null : h.get();
    }

    public InterpreterHistory getHistory() {
        if (this.history != null) {
            return this.history;
        }
        if (this.interpreter instanceof MultiInterpreter) {
            return ((MultiInterpreter)this.interpreter).getHistory();
        }
        return null;
    }

    public void setHistory(InterpreterHistory history) {
        this.history = history;
    }
}

