/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.ethereum;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EthereumContractDownloaderDialog
extends TitleAreaDialog {
    private static final ILogger logger = GlobalLog.getLogger(EthereumContractDownloaderDialog.class);
    private static final String propertyName = "openContractInfo";
    private static final String propLastFolderPath = "lastFolderPath";
    private static final String propLastNetworkIndex = "lastNetworkIndex";
    private static final String propLastContractAddress = "lastContractAddress";
    RcpClientContext context;
    Map<String, String> info;
    String filepath;
    boolean downloaded;
    Text txtFilepath;
    Combo cNetwork;
    Text txtAddress;
    Button btnDownload;
    String[] networks = new String[]{"mainnet", "testnet (Ropsten)", "testnet (Kovan)", "testnet (Rinkeby)"};
    String[] network_names = new String[]{"mainnet", "ropsten", "kovan", "rinkeby"};

    public EthereumContractDownloaderDialog(Shell shell, RcpClientContext context) {
        super(shell);
        this.context = context;
        this.info = Strings.decodeMap(context.getPropertyManager().getString(propertyName));
    }

    public String getFilePath() {
        return this.filepath;
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    public boolean isHelpAvailable() {
        return false;
    }

    private void updateMessage() {
        String path;
        String string = path = this.txtFilepath == null ? null : this.txtFilepath.getText();
        if (path == null || path.isEmpty()) {
            this.setMessage("Select a local file or download a contract via Etherscan", 1);
        } else if (new File(path).isFile()) {
            this.setMessage("Click OK to process this file as an Ethereum contract", 1);
        } else {
            this.setMessage("Illegal file path!", 2);
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Open a Contract");
        this.setTitle("Process an Ethereum Smart Contract");
        this.updateMessage();
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        Composite container1 = new Composite(container, 0);
        container1.setLayoutData((Object)new GridData(4, 4, true, true));
        container1.setLayout((Layout)new GridLayout(2, false));
        this.createSelectFileField(container1, "");
        Group container2 = new Group(container, 0);
        container2.setText("Download");
        container2.setLayoutData((Object)new GridData(4, 4, true, true));
        container2.setLayout((Layout)new GridLayout(2, false));
        this.createNetworkField((Composite)container2, Conversion.stringToInt(this.info.get(propLastNetworkIndex)));
        this.createAddressField((Composite)container2, this.info.get(propLastContractAddress));
        this.createDownloadButton((Composite)container2);
        this.txtAddress.setFocus();
        return area;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 0, "OK", false);
        this.createButton(parent, 1, "Cancel", false);
    }

    private void createSelectFileField(final Composite container, String defValue) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        UIUtil.createPushbox(container, "Open contract file...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(container.getShell(), 4096);
                dlg.setText("Select...");
                String folderPath = EthereumContractDownloaderDialog.this.info.get(EthereumContractDownloaderDialog.propLastFolderPath);
                if (folderPath != null) {
                    dlg.setFilterPath(folderPath);
                }
                dlg.setFilterExtensions(new String[]{"*.*", "*.evm-bytecode", "*.runtime", "*.bin-runtime"});
                String path = dlg.open();
                if (path != null) {
                    EthereumContractDownloaderDialog.this.txtFilepath.setText(path);
                    EthereumContractDownloaderDialog.this.downloaded = false;
                }
            }
        });
        this.txtFilepath = new Text(container, 2048);
        this.txtFilepath.setLayoutData((Object)data);
        this.txtFilepath.setText(Strings.safe(defValue));
        this.txtFilepath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EthereumContractDownloaderDialog.this.updateMessage();
            }
        });
        this.txtFilepath.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EthereumContractDownloaderDialog.this.txtFilepath.selectAll();
            }
        });
    }

    private void createNetworkField(Composite container, int defIndex) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Network Name:");
        this.cNetwork = new Combo(container, 8);
        this.cNetwork.setItems(this.networks);
        this.cNetwork.select(defIndex);
    }

    private void createAddressField(Composite container, String defValue) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Contract Address:");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtAddress = new Text(container, 2048);
        this.txtAddress.setLayoutData((Object)data);
        this.txtAddress.setText(Strings.safe(defValue));
        this.txtAddress.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EthereumContractDownloaderDialog.this.txtAddress.selectAll();
            }
        });
        this.txtAddress.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EthereumContractDownloaderDialog.this.download();
                }
            }
        });
    }

    private void createDownloadButton(Composite container) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.btnDownload = new Button(container, 8);
        this.btnDownload.setFont(JFaceResources.getDialogFont());
        this.btnDownload.setLayoutData((Object)data);
        this.btnDownload.setText("Download");
        this.btnDownload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EthereumContractDownloaderDialog.this.download();
            }
        });
    }

    @Override
    protected void okPressed() {
        File file = new File(this.txtFilepath.getText());
        if (!file.isFile()) {
            UI.error("Not a file.");
            return;
        }
        this.filepath = file.getAbsolutePath();
        this.info.put(propLastFolderPath, file.getParent());
        this.info.put(propLastNetworkIndex, "" + this.cNetwork.getSelectionIndex());
        this.info.put(propLastContractAddress, this.txtAddress.getText());
        this.context.getPropertyManager().setString(propertyName, Strings.encodeMap(this.info));
        super.okPressed();
    }

    private void download() {
        int id = Math.max(0, this.cNetwork.getSelectionIndex());
        String network = this.network_names[id];
        String address = this.txtAddress.getText();
        if (Strings.isBlank(address)) {
            UI.error("Please provide a contract address");
            return;
        }
        ContractInfo c = null;
        try {
            c = this.retrieveContract(network, address);
        }
        catch (Exception e) {
            logger.catching(e);
            UI.error("A network error has occurred.");
            return;
        }
        if (c == null) {
            UI.error("Some data was retrieved from Etherscan but no EVM code could be extracted.\n\nIs the contract address correct?");
            return;
        }
        logger.info("Fetched contract: %s", c);
        if (c.bytecode == null) {
            UI.warn("The EVM code could not be downloaded from Etherscan since the contract source code is available.");
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setOverwrite(true);
        String filename = String.format("%s%s", c.address, ".evm-bytecode");
        dlg.setFileName(filename);
        String path = dlg.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        try {
            c.dumpToDisk(file);
        }
        catch (IOException e1) {
            UI.error("Cannot write contract to disk");
            return;
        }
        this.txtFilepath.setText(file.getAbsolutePath());
        this.downloaded = true;
    }

    private ContractInfo retrieveContract(String network, String address) throws IOException {
        byte[] a;
        network = network.trim().toLowerCase();
        if ((address = address.trim().toLowerCase()).startsWith("0x")) {
            address = address.substring(2);
        }
        if ((a = Formatter.hexStringToByteArray(address)).length != 20) {
            return null;
        }
        address = "0x" + Formatter.byteArrayToHexString(a);
        String url = String.format("https://%setherscan.io/address/%s", network.equals("mainnet") ? "" : network + ".", address);
        String r = this.context.getNetworkUtility().query(url);
        byte[] bytecode = null;
        int pos = r.indexOf("<div id=\"dividcode\">");
        if (pos >= 0) {
            int end;
            int beg = r.indexOf("0x", pos);
            if (pos >= 0 && (end = r.indexOf("<", beg)) >= 0) {
                String str_bytecode = r.substring(beg + 2, end);
                bytecode = Formatter.hexStringToByteArray(str_bytecode);
            }
            if (bytecode == null && r.indexOf("sourcecode", pos) >= 0) {
                return new ContractInfo(network, address, null);
            }
        }
        if (bytecode == null) {
            return null;
        }
        return new ContractInfo(network, address, bytecode);
    }

    static class ContractInfo {
        String network;
        String address;
        byte[] bytecode;

        public ContractInfo(String network, String address, byte[] bytecode) {
            this.network = network;
            this.address = address;
            this.bytecode = bytecode;
        }

        public void dumpToDisk(File file) throws IOException {
            if (this.bytecode == null) {
                throw new IOException("Nothing to dump");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("0x%s\n", Formatter.byteArrayToHexString(this.bytecode)));
            sb.append(String.format(";contract: %s on %s\n", this.address, this.network));
            IO.writeFile(file, sb.toString());
        }

        public String toString() {
            if (this.bytecode == null) {
                return String.format("%s:%s", this.network, this.address);
            }
            return String.format("%s:%s:bytecode_len=%d", this.network, this.address, this.bytecode.length);
        }
    }
}

