/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IEnginesPlugin;
import com.pnfsoftware.jeb.core.IOptionDefinition;
import com.pnfsoftware.jeb.core.ITypedOptionDefinition;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OptionsForEnginesPluginDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(OptionsForEnginesPluginDialog.class);
    private IEnginesPlugin plugin;
    private List<IWidgetData> widgetDatas = new ArrayList<IWidgetData>();
    private Map<String, String> options;

    public OptionsForEnginesPluginDialog(Shell parent, IEnginesPlugin plugin) {
        super(parent, S.s(317), true, true);
        this.scrolledContainer = true;
        this.plugin = plugin;
    }

    @Override
    public Map<String, String> open() {
        super.open();
        return this.options;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        new Label(parent, 0).setText(S.s(651));
        Group g = new Group(parent, 0);
        g.setText("Options");
        g.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
        g.setLayout((Layout)new GridLayout(2, false));
        List<? extends IOptionDefinition> deflist = this.plugin.getExecutionOptionDefinitions();
        if (deflist != null) {
            block5: for (IOptionDefinition iOptionDefinition : deflist) {
                String name = iOptionDefinition.getName();
                String desc = Strings.safe(iOptionDefinition.getDescription());
                String defaultValue = iOptionDefinition.getDefaultValue();
                if (iOptionDefinition instanceof ITypedOptionDefinition) {
                    switch (((ITypedOptionDefinition)iOptionDefinition).getType()) {
                        case Text: 
                        case Description: {
                            break;
                        }
                        case Checkbox: {
                            if (Strings.isBlank(name)) {
                                logger.warn("Invalid property definition (empty)", new Object[0]);
                                continue block5;
                            }
                            this.addLabel((Composite)g, desc);
                            Button widgetData = new Button((Composite)g, 2080);
                            widgetData.setSelection(Boolean.valueOf(Strings.safe(defaultValue)).booleanValue());
                            this.widgetDatas.add(() -> this.options.put(name, Boolean.toString(widgetData.getSelection())));
                            continue block5;
                        }
                        case List: {
                            if (Strings.isBlank(name)) {
                                logger.warn("Invalid property definition (empty)", new Object[0]);
                                continue block5;
                            }
                            this.addLabel((Composite)g, desc);
                            Combo combo = new Combo((Composite)g, 2060);
                            GridData layoutData = UIUtil.createGridDataFillHorizontally();
                            layoutData.widthHint = UIUtil.determineTextWidth((Control)combo, 40);
                            combo.setLayoutData((Object)layoutData);
                            combo.setItems((String[])((ITypedOptionDefinition)iOptionDefinition).getOptions());
                            this.widgetDatas.add(() -> this.options.put(name, combo.getText()));
                            continue block5;
                        }
                        default: {
                            logger.error("Not implemented type %s", new Object[]{((ITypedOptionDefinition)iOptionDefinition).getType()});
                            continue block5;
                        }
                    }
                }
                if (name == null) {
                    Label label = new Label((Composite)g, 0);
                    label.setText(desc);
                    label.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
                    continue;
                }
                if (name.isEmpty()) {
                    logger.warn("Invalid property definition (empty)", new Object[0]);
                    continue;
                }
                this.addLabel((Composite)g, desc);
                Text widgetData = new Text((Composite)g, 2052);
                widgetData.setLayoutData((Object)UIUtil.createGridDataForText((Control)widgetData, 30));
                widgetData.setText(Strings.safe(defaultValue));
                this.widgetDatas.add(() -> this.options.put(name, widgetData.getText()));
            }
        }
        this.createOkayCancelButtons(parent);
    }

    private void addLabel(Composite parent, String description) {
        CLabel l = new CLabel(parent, 0);
        l.setText(description);
        l.setMargins(0, 0, 5, 0);
    }

    @Override
    protected void onConfirm() {
        this.options = new HashMap<String, String>();
        for (IWidgetData widgetData : this.widgetDatas) {
            widgetData.saveData();
        }
        super.onConfirm();
    }

    @FunctionalInterface
    private static interface IWidgetData {
        public void saveData();
    }
}

