/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.AbstractClientContext;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ProxyConfigDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.net.NetProxyInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FloatingControllerSetupDialog
extends JebDialog {
    private AbstractClientContext context;
    private boolean success;
    private Text widgetHostname;
    private Text widgetPort;
    private Combo widgetProtocol;
    private NetProxyInfo proxyinfo;

    public FloatingControllerSetupDialog(Shell parent, AbstractClientContext context) {
        super(parent, S.s(221), true, true);
        this.scrolledContainer = true;
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.success;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        Label label = new Label(parent, 64);
        label.setText(String.format("%s. Please specify your Controller configuration.", S.s(223)));
        label.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
        Group g0 = UIUtil.createGroupGrid(parent, "Controller", 2, 2);
        Label l = new Label((Composite)g0, 64);
        l.setText("All fields are mandatory.");
        l.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
        new Label((Composite)g0, 0).setText(S.s(670));
        this.widgetHostname = new Text((Composite)g0, 2052);
        this.widgetHostname.setText(Strings.safe(this.context.getControllerInterface()));
        this.widgetHostname.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.widgetHostname.selectAll();
        this.widgetHostname.setFocus();
        new Label((Composite)g0, 0).setText(S.s(671));
        this.widgetPort = new Text((Composite)g0, 2052);
        this.widgetPort.setText(Integer.toString(this.context.getControllerPort()));
        this.widgetPort.selectAll();
        this.widgetPort.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label((Composite)g0, 0).setText("Protocol");
        this.widgetProtocol = new Combo((Composite)g0, 8);
        this.widgetProtocol.setItems(new String[]{"http", "https"});
        this.widgetProtocol.select(0);
        this.widgetProtocol.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        Group g1 = UIUtil.createGroupGrid(parent, "Connection", 2, 2);
        UIUtil.createPushbox((Composite)g1, "Proxy settings...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyConfigDialog dlg = new ProxyConfigDialog(UIUtil.getParentShell((Composite)FloatingControllerSetupDialog.this.shell), null, null);
                NetProxyInfo r = dlg.open();
                if (r != null) {
                    FloatingControllerSetupDialog.this.proxyinfo = r;
                }
            }
        });
        this.createOkayCancelButtons(parent);
    }

    @Override
    protected void onConfirm() {
        String hostname = this.widgetHostname.getText();
        if (Strings.isBlank(hostname)) {
            UI.error("Illegal hostname for controller");
            return;
        }
        int port = Conversion.stringToInt(this.widgetPort.getText());
        if (port <= 0 || port >= 65535) {
            UI.error("Illegal port number for controller");
            return;
        }
        int protocol = 0;
        int protoIndex = this.widgetProtocol.getSelectionIndex();
        if (protoIndex == 1) {
            protocol = 1;
        }
        this.context.setControllerInterface(hostname);
        this.context.setControllerPort(port);
        this.context.setControllerProtocol(protocol);
        if (this.proxyinfo != null) {
            this.context.setProxyString(this.proxyinfo.toString());
        }
        this.success = Boolean.TRUE;
        super.onConfirm();
    }
}

