/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DirectorySelectorView;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDecompiledCodeDialog
extends JebDialog {
    private Text text;
    private ExportStatus exportStatus;
    private State exportState = State.ALL;
    private String initialFilter;
    private String initialDirectory;
    private DirectorySelectorView folderText;
    private String outputDirectory;
    private Button mergeAll;
    private boolean merge;
    private Text fileText;
    private String outputFile;
    private Button resume;
    private boolean resumeValue = false;

    public ExportDecompiledCodeDialog(Shell parent) {
        super(parent, S.s(327), true, true);
        this.scrolledContainer = true;
    }

    public void setInitialState(State state) {
        this.exportState = state;
    }

    public void setInitialState(ExportStatus state) {
        this.setInitialState(state.state);
        this.setInitialFilter(state.filter);
    }

    public State getState() {
        return this.exportState;
    }

    public void setInitialFilter(String initialFilter) {
        this.initialFilter = initialFilter;
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectory = initialDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isMergeFiles() {
        return this.merge;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean shoudResume() {
        return this.resumeValue;
    }

    @Override
    public ExportStatus open() {
        super.open();
        return this.exportStatus;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        Group c0 = new Group(parent, 0);
        c0.setText(S.s(324));
        GridData exportGridData = UIUtil.createGridDataFillHorizontally();
        exportGridData.horizontalSpan = 2;
        c0.setLayoutData((Object)exportGridData);
        c0.setLayout((Layout)new GridLayout(1, false));
        Button all = new Button((Composite)c0, 16);
        all.setText(S.s(54));
        all.addSelectionListener((SelectionListener)new ExportSelectionListener(State.ALL));
        Button filter = new Button((Composite)c0, 16);
        filter.setText(S.s(343));
        filter.addSelectionListener((SelectionListener)new ExportSelectionListener(State.FILTER));
        this.text = new Text((Composite)c0, 2048);
        this.text.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.text.setMessage(S.s(343));
        Button decomp = new Button((Composite)c0, 16);
        decomp.setText(S.s(607));
        decomp.addSelectionListener((SelectionListener)new ExportSelectionListener(State.DECOMPILED));
        Button current = new Button((Composite)c0, 16);
        current.setText(S.s(228));
        current.addSelectionListener((SelectionListener)new ExportSelectionListener(State.CURRENT));
        Text currentUnitText = new Text((Composite)c0, 2048);
        currentUnitText.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        currentUnitText.setEnabled(false);
        switch (this.exportState) {
            case ALL: {
                all.setSelection(true);
                all.setFocus();
                this.text.setEnabled(false);
                current.setEnabled(false);
                break;
            }
            case FILTER: {
                filter.setSelection(true);
                filter.setFocus();
                current.setEnabled(false);
                break;
            }
            case DECOMPILED: {
                decomp.setSelection(true);
                decomp.setFocus();
                this.text.setEnabled(false);
                current.setEnabled(false);
                break;
            }
            case CURRENT: {
                current.setSelection(true);
                current.setFocus();
                this.text.setEnabled(false);
                if (this.initialFilter == null) break;
                currentUnitText.setText(this.initialFilter);
                break;
            }
        }
        Group c1 = new Group(parent, 0);
        c1.setText("Destination");
        c1.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
        c1.setLayout((Layout)new GridLayout(1, false));
        this.folderText = new DirectorySelectorView((Composite)c1, S.s(269) + ": ", this.initialDirectory);
        this.folderText.setLayoutData(UIUtil.createGridDataFillHorizontally());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.folderText.setLayoutData(gd);
        this.mergeAll = new Button((Composite)this.folderText, 32);
        this.mergeAll.setText("Merge to one file: ");
        this.mergeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportDecompiledCodeDialog.this.mergeAll.getSelection()) {
                    ExportDecompiledCodeDialog.this.fileText.setEnabled(true);
                } else {
                    ExportDecompiledCodeDialog.this.fileText.setEnabled(false);
                }
            }
        });
        this.fileText = new Text((Composite)this.folderText, 2048);
        this.fileText.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.fileText.setMessage("File name");
        this.fileText.setEnabled(false);
        this.resume = new Button(parent, 32);
        this.resume.setText("Resume (won't decompile if file \"method.*\" already exists)");
        if (this.initialFilter != null) {
            this.text.setText(this.initialFilter);
        }
        Composite buttons = this.createButtons(parent, 288, 32);
        GridData gdButtons = new GridData();
        gdButtons.verticalIndent = 20;
        buttons.setLayoutData((Object)gdButtons);
    }

    @Override
    protected void onConfirm() {
        if (Strings.isBlank(this.folderText.getText())) {
            MessageDialog.openError(this.shell, "Empty directory", "Destination directory can not be empty. Please select one.");
        } else if (this.mergeAll.getSelection() && Strings.isBlank(this.fileText.getText())) {
            MessageDialog.openError(this.shell, "Empty file name", "File name can not be empty. Please enter one.");
        } else if (this.resume.getSelection() && this.mergeAll.getSelection()) {
            MessageDialog.openError(this.shell, "Uncompatible options", "Resume can not be performed on merged decompilation.");
        } else {
            this.exportStatus = new ExportStatus(this.exportState, this.text.getText());
            this.outputDirectory = this.folderText.getText();
            this.merge = this.mergeAll.getSelection();
            this.outputFile = this.fileText.getText();
            this.resumeValue = this.resume.getSelection();
            super.onConfirm();
        }
    }

    @Override
    protected void onCancel() {
        this.exportStatus = null;
        super.onCancel();
    }

    private class ExportSelectionListener
    implements SelectionListener {
        private State state;

        public ExportSelectionListener(State state) {
            this.state = state;
        }

        public void widgetSelected(SelectionEvent e) {
            switch (this.state) {
                case ALL: 
                case CURRENT: 
                case DECOMPILED: {
                    ExportDecompiledCodeDialog.this.text.setEnabled(false);
                    break;
                }
                case FILTER: {
                    ExportDecompiledCodeDialog.this.text.setEnabled(true);
                    break;
                }
            }
            ExportDecompiledCodeDialog.this.exportState = this.state;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public static class ExportStatus {
        private State state;
        private String filter;

        public ExportStatus(State state, String filter) {
            this.state = state;
            this.filter = filter;
        }

        public State getState() {
            return this.state;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    public static enum State {
        ALL,
        FILTER,
        DECOMPILED,
        CURRENT;

    }
}

