/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataOutputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.NativeTypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Serializer {
    private static final ILogger logger = GlobalLog.getLogger(Serializer.class);
    private static final int VERSION = 4;
    private LEDataOutputStream out;
    private ITypeIdProvider nativeTypeIdProvider;
    private ITypeIdProvider customTypeIdProvider;
    private IdentityHashMap<Object, Integer> objmap = new IdentityHashMap();
    private LinkedHashMap<String, Integer> stringpool;
    private Map<String, Integer> t2omap = new HashMap<String, Integer>();
    private int currentObjectId = 1;
    private int rootCount;
    private boolean cancelled;
    private int depth;
    private int maxDepthReached;
    private int maxDepthAllowed = Integer.MAX_VALUE;
    private static Map<Class<?>, List<Field>> fieldCache = new HashMap();
    private static Map<Field, Integer> fieldIdCache = new HashMap<Field, Integer>();
    private Set<Field> impTransientFields = new HashSet<Field>();
    private static Map<Class<?>, Method> customWriters = new HashMap();
    private static Map<Class<?>, Integer> versionFields = new HashMap();

    public Serializer(ITypeIdProvider iTypeIdProvider, OutputStream outputStream, boolean bl2) {
        this.out = new LEDataOutputStream(new BufferedOutputStream(outputStream));
        this.stringpool = bl2 ? new LinkedHashMap() : null;
        this.nativeTypeIdProvider = NativeTypeIdProvider.getInstance();
        this.customTypeIdProvider = iTypeIdProvider;
    }

    void writeHeader() throws IOException {
        int n = 0;
        if (this.stringpool != null) {
            n |= 1;
        }
        this.out.write("PNF-ORPD".getBytes("UTF-8"));
        this.out.writeByte(4);
        this.out.writeByte(n);
        this.out.writeByte(0);
        this.out.writeByte(0);
        this.out.writeInt(0);
    }

    OutputStream getStream() {
        return new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                Serializer.this.out.write(n);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                Serializer.this.out.write(byArray);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                Serializer.this.out.write(byArray, n, n2);
            }
        };
    }

    public int getObjectCount() {
        return this.objmap.size();
    }

    public int getMaxDepthReached() {
        return this.maxDepthReached;
    }

    public List<String> getStringPool() {
        if (this.stringpool == null) {
            throw new IllegalStateException("This serializer was not configured to generate a string pool");
        }
        return new ArrayList<String>(this.stringpool.keySet());
    }

    public void serialize(Object object) throws IOException {
        if (this.rootCount == 0) {
            this.writeHeader();
        }
        this.write(object);
        if (this.cancelled) {
            throw new SerializationException(String.format("The serialization of object \"%s\" was cancelled", object));
        }
        ++this.rootCount;
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.out = null;
    }

    void write(Object object) throws IOException {
        this.write(object, null);
    }

    private void write(Object object, Class<?> clazz) throws IOException {
        try {
            ++this.depth;
            if (this.depth > this.maxDepthReached) {
                this.maxDepthReached = this.depth;
                if (this.depth > this.maxDepthAllowed) {
                    throw new SerializationException("Serialization is going too deep: " + this.depth);
                }
            }
            this.writeI(object, clazz);
        }
        finally {
            --this.depth;
        }
    }

    private void writeI(Object object, Class<?> clazz) throws IOException {
        boolean bl2;
        if (this.cancelled) {
            return;
        }
        if (Thread.interrupted()) {
            this.cancelled = true;
            return;
        }
        boolean bl3 = bl2 = clazz == null;
        if (object == null) {
            if (!bl2) {
                throw new SerializationException("A null object must be a leaf object", clazz);
            }
            this.out.writeIntULEB128(1);
            return;
        }
    }

    void writeFields(Object object, Class<?> clazz) throws IOException {
        List<Field> list = fieldCache.get(clazz);
        if (list == null) {
            list = new ArrayList<Field>();
            fieldCache.put(clazz, list);
            HashSet hashSet = new HashSet();
            for (Field field : clazz.getDeclaredFields()) {
                int n = field.getModifiers();
                if ((n & 8) != 0) continue;
                SerId serId = field.getAnnotation(SerId.class);
                if (serId == null) {
                    if (field.getAnnotation(SerTransient.class) != null || this.impTransientFields.contains(field)) continue;
                    this.impTransientFields.add(field);
                    String string = String.format("Field %s is implicitly transient", field);
                    logger.debug(string, new Object[0]);
                    continue;
                }
                int n2 = serId.value();
                if (n2 == 0) {
                    String string = String.format("Invalid field serialization id (0) for field: %s", field);
                    logger.warn(string, new Object[0]);
                    continue;
                }
                if (serId.deprecated()) continue;
                list.add(field);
                fieldIdCache.put(field, n2);
                if (hashSet.add(n2)) continue;
                throw new SerializationException("Duplicate field id: " + n2, clazz);
            }
        }
        for (Field field : list) {
            int n = fieldIdCache.get(field);
            this.writeField(object, field, n);
        }
        this.out.writeIntULEB128(0);
    }

    private void writeField(Object object, Field field, int n) throws IOException {
        Object object2;
        boolean bl2 = field.isAccessible();
        if (!bl2) {
            field.setAccessible(true);
        }
        try {
            object2 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SerializationException(illegalAccessException);
        }
        this.out.writeIntULEB128(n);
        this.write(object2);
        if (!bl2) {
            field.setAccessible(false);
        }
    }

    private boolean attemptCustomWrite(Object object, Class<?> clazz) throws SerializationException {
        Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
        try {
            Method method;
            if (customWriters.containsKey(clazz2)) {
                method = customWriters.get(clazz2);
            } else {
                method = null;
                for (Method method2 : clazz2.getDeclaredMethods()) {
                    SerCustomWrite serCustomWrite = method2.getAnnotation(SerCustomWrite.class);
                    if (serCustomWrite == null) continue;
                    if (!this.isValidSerializerHelper(method2)) {
                        throw new SerializationException("Invalid prototype for serialization helper method: " + method2, clazz2);
                    }
                    method = method2;
                    break;
                }
                customWriters.put(clazz2, method);
            }
            if (method == null) {
                return false;
            }
            ReflectionHelper.invoke2(method, object, new SerializerHelper(this, object, clazz2));
            return true;
        }
        catch (Exception exception) {
            throw new SerializationException("Custom write failed", exception, clazz2);
        }
    }

    private boolean isValidSerializerHelper(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || classArray[0] != SerializerHelper.class) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        return (method.getModifiers() & 2) != 0;
    }

    private int getVersionField(Object object, Class<?> clazz) throws SerializationException {
        try {
            Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
            Integer n = versionFields.get(clazz2);
            if (n == null) {
                SerVersion serVersion = clazz2.getAnnotation(SerVersion.class);
                n = serVersion != null ? Integer.valueOf(serVersion.value()) : Integer.valueOf(0);
                versionFields.put(clazz2, n);
            }
            return n;
        }
        catch (SecurityException securityException) {
            throw new SerializationException(securityException);
        }
    }

    private void writeNativeObject(Object object, Class<?> clazz) throws IOException {
        if (clazz != Object.class) {
            if (clazz == Boolean.class) {
                this.out.writeByte((Boolean)object != false ? 1 : 0);
            } else if (clazz == boolean[].class) {
                boolean[] blArray = (boolean[])object;
                this.out.writeIntULEB128(blArray.length);
                for (boolean bl2 : blArray) {
                    this.out.writeByte(bl2 ? 1 : 0);
                }
            } else if (clazz == Byte.class) {
                this.out.writeByte(((Byte)object).byteValue());
            } else if (clazz == byte[].class) {
                byte[] byArray = (byte[])object;
                this.out.writeIntULEB128(byArray.length);
                this.out.write(byArray);
            } else if (clazz == Short.class) {
                this.out.writeShort(((Short)object).shortValue());
            } else if (clazz == short[].class) {
                short[] sArray = (short[])object;
                this.out.writeIntULEB128(sArray.length);
                for (short s2 : sArray) {
                    this.out.writeShort(s2);
                }
            } else if (clazz == Character.class) {
                this.out.writeChar(((Character)object).charValue());
            } else if (clazz == char[].class) {
                char[] cArray = (char[])object;
                this.out.writeIntULEB128(cArray.length);
                for (char c : cArray) {
                    this.out.writeChar(c);
                }
            } else if (clazz == Integer.class) {
                this.out.writeIntULEB128((Integer)object);
            } else if (clazz == int[].class) {
                int[] nArray = (int[])object;
                this.out.writeIntULEB128(nArray.length);
                for (int n : nArray) {
                    this.out.writeIntULEB128(n);
                }
            } else if (clazz == Long.class) {
                this.out.writeLongULEB128((Long)object);
            } else if (clazz == long[].class) {
                long[] lArray = (long[])object;
                this.out.writeIntULEB128(lArray.length);
                for (long l2 : lArray) {
                    this.out.writeLongULEB128(l2);
                }
            } else if (clazz == Float.class) {
                this.out.writeFloat(((Float)object).floatValue());
            } else if (clazz == float[].class) {
                float[] fArray = (float[])object;
                this.out.writeIntULEB128(fArray.length);
                for (float f : fArray) {
                    this.out.writeFloat(f);
                }
            } else if (clazz == Double.class) {
                this.out.writeDouble((Double)object);
            } else if (clazz == double[].class) {
                double[] dArray = (double[])object;
                this.out.writeIntULEB128(dArray.length);
                for (double d2 : dArray) {
                    this.out.writeDouble(d2);
                }
            } else if (clazz == String.class) {
                String string = (String)object;
                if (this.stringpool != null) {
                    Integer n = this.stringpool.get(string);
                    if (n == null) {
                        n = this.stringpool.size();
                        this.stringpool.put(string, n);
                    }
                    this.out.writeIntULEB128(n);
                } else {
                    byte[] byArray = Strings.encodeUTF8(string);
                    int n = byArray.length;
                    this.out.writeIntULEB128(n);
                    this.out.write(byArray);
                }
            } else if (clazz == BigInteger.class) {
                BigInteger bigInteger = (BigInteger)object;
                byte[] byArray = bigInteger.toByteArray();
                this.out.writeIntULEB128(byArray.length);
                this.out.write(byArray);
            } else if (clazz == BigDecimal.class) {
                BigDecimal bigDecimal = (BigDecimal)object;
                byte[] byArray = Strings.encodeUTF8(bigDecimal.toString());
                this.out.writeIntULEB128(byArray.length);
                this.out.write(byArray);
            } else if (clazz == AtomicBoolean.class) {
                this.out.writeByte(((AtomicBoolean)object).get() ? 1 : 0);
            } else if (clazz == AtomicInteger.class) {
                this.out.writeIntULEB128(((AtomicInteger)object).get());
            } else if (clazz == AtomicLong.class) {
                this.out.writeLongULEB128(((AtomicLong)object).get());
            } else if (clazz == SoftReference.class) {
                this.write(((SoftReference)object).get());
            } else if (clazz == WeakReference.class) {
                this.write(((WeakReference)object).get());
            } else if (Collection.class.isAssignableFrom(clazz) && (clazz == ArrayList.class || clazz == LinkedList.class || clazz == ArrayDeque.class || clazz == HashSet.class || clazz == TreeSet.class || clazz == LinkedHashSet.class || clazz == CopyOnWriteArrayList.class || clazz == CopyOnWriteArraySet.class || clazz == ConcurrentSkipListSet.class)) {
                Collection collection = (Collection)object;
                this.out.writeIntULEB128(collection.size());
                for (Object e2 : collection) {
                    this.write(e2);
                }
            } else if (Map.class.isAssignableFrom(clazz) && (clazz == HashMap.class || clazz == TreeMap.class || clazz == LinkedHashMap.class || clazz == IdentityHashMap.class || clazz == ConcurrentHashMap.class || clazz == ConcurrentSkipListMap.class)) {
                Map map = (Map)object;
                this.out.writeIntULEB128(map.size());
                for (Object k2 : map.keySet()) {
                    Object v2 = map.get(k2);
                    this.write(k2);
                    this.write(v2);
                }
            } else {
                throw new SerializationException("Native object cannot be serialized", clazz);
            }
        }
    }
}

