/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.io.NoopInputStream;
import com.pnfsoftware.jeb.util.io.NoopOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class StreamWrappers {
    public static FilterOutputStream getCompressedStream(OutputStream outputStream) {
        return new LZ4BlockOutputStream(outputStream);
    }

    public static FilterInputStream getUncompressedStream(InputStream inputStream) {
        return new LZ4BlockInputStream(inputStream);
    }

    public static FilterOutputStream getEncryptedStream(OutputStream outputStream, byte[] byArray) {
        return StreamWrappers.getEncryptedStream(outputStream, "RC4", byArray);
    }

    public static FilterInputStream getDecryptedStream(InputStream inputStream, byte[] byArray) {
        return StreamWrappers.getDecryptedStream(inputStream, "RC4", byArray);
    }

    public static FilterOutputStream getEncryptedStream(OutputStream outputStream, String string, byte[] byArray) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, byArray.length, string);
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(1, secretKeySpec);
            return new CipherOutputStream(outputStream, cipher);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            return new NoopOutputStream(outputStream);
        }
    }

    public static FilterInputStream getDecryptedStream(InputStream inputStream, String string, byte[] byArray) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, byArray.length, string);
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(2, secretKeySpec);
            return new CipherInputStream(inputStream, cipher);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            return new NoopInputStream(inputStream);
        }
    }
}

