/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class IO {
    private static final ILogger logger = GlobalLog.getLogger(IO.class);
    private static File tempFolder = null;
    private static Set<String> windowsIllegalFileNames;

    public static String setCwd(String string) {
        String string2 = IO.getCwd();
        System.setProperty("user.dir", string);
        return string2;
    }

    public static String getCwd() {
        return Strings.safe(System.getProperty("user.dir"));
    }

    public static boolean isFile(String string) {
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    public static boolean createDirectory(String string) {
        return IO.createDirectory(new File(string));
    }

    public static boolean createDirectory(File file) {
        try {
            return file.mkdir();
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return false;
        }
    }

    public static boolean deleteDirectory(String string) {
        return IO.deleteDirectory(new File(string));
    }

    public static boolean deleteDirectory(File file) {
        int[] nArray = new int[1];
        IO.deleteDirectory(file, nArray);
        return nArray[0] == 0;
    }

    private static void deleteDirectory(File file, int[] nArray) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IO.deleteDirectory(file2, nArray);
                    continue;
                }
                if (file2.delete()) continue;
                nArray[0] = nArray[0] + 1;
                return;
            }
        }
        if (!file.delete()) {
            nArray[0] = nArray[0] + 1;
        }
    }

    public static boolean deleteDirectoryContents(File file) {
        int[] nArray = new int[1];
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IO.deleteDirectory(file2, nArray);
                    continue;
                }
                if (file2.delete()) continue;
                nArray[0] = nArray[0] + 1;
            }
        }
        return nArray[0] == 0;
    }

    public static boolean deleteFile(File file) {
        file.setWritable(true);
        return file.delete();
    }

    public static boolean renameFile(File file, File file2, int n) {
        boolean bl2 = file.renameTo(file2);
        if (bl2) {
            return true;
        }
        if (n == 0 || !file.exists() || !file2.exists()) {
            return false;
        }
        if (n == 1) {
            return IO.deleteFile(file2) && file.renameTo(file2);
        }
        if (n == 2) {
            return IO.deleteFile(file);
        }
        throw new IllegalArgumentException();
    }

    public static List<File> listFiles(String string) {
        return IO.listFiles(new File(string));
    }

    public static List<File> listFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        IO.listFilesRecurse(file, arrayList);
        return arrayList;
    }

    private static void listFilesRecurse(File file, List<File> list) {
        if (file.isDirectory()) {
            for (String string : file.list()) {
                IO.listFilesRecurse(new File(file, string), list);
            }
        } else if (file.isFile()) {
            list.add(file);
        }
    }

    public static File getTempFolder() {
        return tempFolder;
    }

    public static File createTempFolder(String string) throws IOException {
        File file = new File(tempFolder, string);
        file.mkdir();
        return file;
    }

    public static File createTempFile() throws IOException {
        return File.createTempFile("file-" + System.nanoTime(), null);
    }

    public static File createTempFile(String string) throws IOException {
        return new File(IO.getTempFolder(), string);
    }

    public static boolean createFile(File file, boolean bl2) throws IOException {
        if (bl2) {
            IO.createFoldersForFile(file);
        }
        return file.createNewFile();
    }

    public static void createFoldersForFile(File file) throws IOException {
        File file2 = file.getAbsoluteFile().getParentFile();
        if (file2 != null) {
            if (file2.isDirectory()) {
                return;
            }
            if (!file2.mkdirs()) {
                throw new IOException("Cannot create full directory structure for a file: " + file.getAbsolutePath());
            }
        }
    }

    public static void deleteDirectoryOnExit(File file) {
        file.deleteOnExit();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IO.deleteDirectoryOnExit(file2);
                    continue;
                }
                file2.deleteOnExit();
            }
        }
    }

    public static void copyFile(File file, File file2, boolean bl2) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("Source file not found: " + file);
        }
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists() && !bl2) {
            throw new FileAlreadyExistsException("Copy would overwrite an existing file: " + file2);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));){
            IO.copyStream(bufferedInputStream, bufferedOutputStream, new byte[4096]);
        }
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        long l2 = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l2 += (long)n;
        }
        return l2;
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IO.copyStream(inputStream, outputStream, new byte[4096]);
    }

    public static void writeFile(File file, byte[] byArray, int n, int n2, boolean bl2) throws IOException {
        Object object;
        if (bl2 && (object = file.getAbsoluteFile().getParentFile()) != null) {
            ((File)object).mkdirs();
        }
        object = new DataOutputStream(new FileOutputStream(file));
        Throwable throwable = null;
        try {
            ((DataOutputStream)object).write(byArray, n, n2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((FilterOutputStream)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((FilterOutputStream)object).close();
                }
            }
        }
    }

    public static void writeFile(File file, byte[] byArray, boolean bl2) throws IOException {
        IO.writeFile(file, byArray, 0, byArray.length, bl2);
    }

    public static void writeFile(File file, byte[] byArray, int n, int n2) throws IOException {
        IO.writeFile(file, byArray, n, n2, false);
    }

    public static void writeFile(File file, byte[] byArray) throws IOException {
        IO.writeFile(file, byArray, 0, byArray.length, false);
    }

    public static void writeFile(File file, String string) throws IOException {
        IO.writeFile(file, string.getBytes(Charset.defaultCharset()));
    }

    public static void writeFile(File file, String string, String string2) throws IOException {
        IO.writeFile(file, string.getBytes(string2));
    }

    public static byte[] readFile(File file, long l2) throws IOException {
        long l3 = file.length();
        if (l2 >= 0L && l3 > l2) {
            throw new IOException("File is too large");
        }
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            byte[] byArray = new byte[(int)l3];
            dataInputStream.readFully(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    public static byte[] readFile(File file) throws IOException {
        return IO.readFile(file, -1L);
    }

    public static byte[] readFile(String string) throws IOException {
        return IO.readFile(new File(string), -1L);
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        int n;
        if (inputStream instanceof FileInputStream) {
            long l2 = ((FileInputStream)inputStream).getChannel().size();
            if (l2 > Integer.MAX_VALUE) {
                throw new IOException(String.format("This method cannot read files larger than 2Gb: size=%d", l2));
            }
            byte[] byArray = new byte[(int)l2];
            int n2 = inputStream.read(byArray);
            if ((long)n2 != l2) {
                throw new IOException(String.format("Unexpected amount of bytes read from file: %d != %d", n2, l2));
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public static List<String> readLines(InputStream inputStream) throws IOException {
        return IO.readLines(inputStream, Charset.forName("UTF-8"));
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            List<String> list = IO.readLines(fileInputStream, charset);
            return list;
        }
    }

    public static List<String> readLines(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            List<String> list = IO.readLines(fileInputStream, Charset.forName("UTF-8"));
            return list;
        }
    }

    public static List<String> readLinesSafe(File file, Charset charset) {
        try {
            return IO.readLines(file, charset);
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return null;
        }
    }

    public static List<String> readLinesSafe(File file) {
        return IO.readLinesSafe(file, Charset.forName("UTF-8"));
    }

    public static void writeLines(OutputStream outputStream, List<? extends CharSequence> list, Charset charset) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            for (CharSequence charSequence : list) {
                bufferedWriter.write(charSequence.toString());
                bufferedWriter.newLine();
            }
        }
    }

    public static void writeLines(OutputStream outputStream, List<? extends CharSequence> list) throws IOException {
        IO.writeLines(outputStream, list, Charset.forName("UTF-8"));
    }

    public static void writeLines(File file, List<? extends CharSequence> list, Charset charset) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IO.writeLines(fileOutputStream, list, charset);
        }
    }

    public static void writeLines(File file, List<? extends CharSequence> list) throws IOException {
        IO.writeLines(file, list, Charset.forName("UTF-8"));
    }

    public static boolean writeLinesSafe(OutputStream outputStream, List<? extends CharSequence> list, Charset charset) {
        try {
            IO.writeLines(outputStream, list, charset);
            return true;
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
    }

    public static boolean writeLinesSafe(OutputStream outputStream, List<? extends CharSequence> list) {
        return IO.writeLinesSafe(outputStream, list, Charset.forName("UTF-8"));
    }

    public static boolean writeLinesSafe(File file, List<? extends CharSequence> list, Charset charset) {
        try {
            IO.writeLines(file, list, charset);
            return true;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    public static boolean writeLinesSafe(File file, List<? extends CharSequence> list) {
        return IO.writeLinesSafe(file, list, Charset.forName("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFirstIntLE(String string) {
        File file = new File(string);
        LEDataInputStream lEDataInputStream = null;
        try {
            lEDataInputStream = new LEDataInputStream(new FileInputStream(file));
            int n = lEDataInputStream.readInt();
            return n;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            int n = 0;
            return n;
        }
        finally {
            try {
                if (lEDataInputStream != null) {
                    lEDataInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getFirstShortLE(String string) {
        File file = new File(string);
        LEDataInputStream lEDataInputStream = null;
        try {
            lEDataInputStream = new LEDataInputStream(new FileInputStream(file));
            short s2 = lEDataInputStream.readShort();
            return s2;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            short s3 = 0;
            return s3;
        }
        finally {
            try {
                if (lEDataInputStream != null) {
                    lEDataInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte getFirstByte(String string) {
        File file = new File(string);
        LEDataInputStream lEDataInputStream = null;
        try {
            lEDataInputStream = new LEDataInputStream(new FileInputStream(file));
            byte by2 = lEDataInputStream.readByte();
            return by2;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            byte by3 = 0;
            return by3;
        }
        finally {
            try {
                if (lEDataInputStream != null) {
                    lEDataInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compressFolder(String string, String string2) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return false;
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(new File(string2)));){
            IO.compressFolderRecurse(zipOutputStream, file, "/");
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    private static void compressFolderRecurse(ZipOutputStream zipOutputStream, File file, String string) throws IOException {
        File file2 = new File(file, string);
        if (file2.isFile()) {
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = IO.readFile(file2.getAbsolutePath());
            zipOutputStream.write(byArray);
            zipOutputStream.closeEntry();
        } else if (file2.isDirectory()) {
            for (String string2 : file2.list()) {
                IO.compressFolderRecurse(zipOutputStream, file, new File(string, string2).getPath());
            }
        }
    }

    public static void extractToFolder(File file, File file2) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    byte[] byArray = IO.readInputStream(inputStream);
                    File file3 = new File(file2, zipEntry.getName());
                    IO.writeFile(file3, byArray, true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFileSafe(File file) {
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            byte[] byArray2 = new byte[(int)file.length()];
            dataInputStream.readFully(byArray2);
            byte[] byArray = byArray2;
            return byArray;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return new byte[0];
        }
    }

    public static boolean writeFileSafe(File file, byte[] byArray, int n, int n2, boolean bl2) {
        try {
            IO.writeFile(file, byArray, n, n2, bl2);
            return true;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    public static boolean writeFileSafe(File file, byte[] byArray, boolean bl2) {
        try {
            IO.writeFile(file, byArray, 0, byArray.length, bl2);
            return true;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    public static String readInputLineSafe() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return null;
        }
    }

    public static File getParentFile2(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        }
        return file2;
    }

    public static String expandPath(String string) {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            return string;
        }
        return string.replaceFirst("^~", Matcher.quoteReplacement(string2));
    }

    public static Thread copyAsync(final InputStream inputStream, final OutputStream outputStream) {
        return ThreadUtil.start("Async-Stream-Copy", new Runnable(){

            @Override
            public void run() {
                long l2 = 0L;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                    byte[] byArray;
                    int n;
                    while ((n = bufferedInputStream.read(byArray = new byte[4096])) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                        bufferedOutputStream.flush();
                        l2 += (long)n;
                    }
                    bufferedOutputStream.flush();
                    logger.trace("Background stream copy completed: %d bytes copied", l2);
                }
                catch (IOException iOException) {
                    logger.trace("Background stream copy stopped: %d bytes copied (error: %s)", l2, iOException);
                }
            }
        });
    }

    public static List<String> parsePathElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split("(/|\\\\)")) {
            if (string2.isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String escapeFileName(String string) {
        return IO.escapeFileName(string, '_');
    }

    public static String escapeFileName(String string, char c) {
        return string.replaceAll("[:\\\\/*\"?|<>]", c + "");
    }

    public static String escapeFileNameStrict(String string) {
        return IO.escapeFileNameStrict(string, '_');
    }

    public static String escapeFileNameStrict(String string, char c) {
        return string.replaceAll("[^a-zA-Z0-9-_\\.']", c + "");
    }

    public static String sanitizePathUnsafe(String string) {
        return IO.sanitizePath(string, false, false);
    }

    public static String sanitizePath(String string, boolean bl2, boolean bl3) {
        char c;
        int n;
        if (OSType.determine().isWindows()) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = -1;
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c == '/' || c == '\\') {
                    if (n2 != -1) {
                        stringBuilder.append(IO.sanitizeReservedWindowsFileName(string.substring(n2, n)));
                        n2 = -1;
                    }
                    stringBuilder.append(c);
                    continue;
                }
                if (n2 != -1) continue;
                n2 = n;
            }
            if (n2 != -1) {
                stringBuilder.append(IO.sanitizeReservedWindowsFileName(string.substring(n2, string.length())));
                n2 = -1;
            }
            string = stringBuilder.toString();
        }
        int n3 = -1;
        while (true) {
            try {
                Paths.get(string, new String[0]);
                if (bl3) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (n = 0; n < string.length(); ++n) {
                        c = string.charAt(n);
                        if (Character.isWhitespace(c)) {
                            stringBuilder.append(String.format("_x%04x", c & 0xFFFF));
                            continue;
                        }
                        stringBuilder.append(c);
                    }
                    string = stringBuilder.toString();
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (n = 0; n < string.length(); ++n) {
                    c = string.charAt(n);
                    if (c == '?' || c == '%' || c == '*' || c == '|' || c == '<' || c == '>' || c == '\"' || bl2 && (c == '/' || c == '\\' || c == ':')) {
                        stringBuilder.append(String.format("_x%04x", c & 0xFFFF));
                        continue;
                    }
                    stringBuilder.append(c);
                }
                string = stringBuilder.toString();
                return string;
            }
            catch (InvalidPathException invalidPathException) {
                n = invalidPathException.getIndex();
                if (n > n3) {
                    n3 = n;
                    string = invalidPathException.getInput();
                    c = string.charAt(n);
                    string = string.substring(0, n) + String.format("_x%04x", c & 0xFFFF) + string.substring(n + 1);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (n = 0; n < string.length(); ++n) {
                    c = string.charAt(n);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append(String.format("_x%04x", c & 0xFFFF));
                }
                string = stringBuilder.toString();
                Paths.get(string, new String[0]);
                return string;
            }
            break;
        }
    }

    private static String sanitizeReservedWindowsFileName(String string) {
        String string2 = string.toLowerCase();
        int n = string2.indexOf(46);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        if (windowsIllegalFileNames.contains(string2)) {
            string = n < 0 ? string + "\u00a0" : string.substring(0, n) + "\u00a0" + string.substring(n);
        }
        return string;
    }

    public static String getRelativePath(File file, File file2) throws IOException {
        String string;
        String string2 = file.getCanonicalPath();
        if (!string2.startsWith(string = file2.getCanonicalPath())) {
            return null;
        }
        String string3 = string2.substring(string.length());
        string3 = Strings.ltrim(string3, '/');
        string3 = Strings.ltrim(string3, '\\');
        return string3;
    }

    /*
     * Exception decompiling
     */
    public static boolean compareFiles(File var0, File var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean compareStreams(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n;
        int n2;
        do {
            n2 = inputStream.read();
            n = inputStream2.read();
            if (n2 != -1 || n != -1) continue;
            return true;
        } while (n2 == n);
        return false;
    }

    public static String getExtension(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String noExtension(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getExtension(File file) {
        return IO.getExtension(file.getAbsolutePath());
    }

    public static File noExtension(File file) {
        return new File(IO.noExtension(file.getAbsolutePath()));
    }

    public static File replaceExtension(File file, String string) {
        return new File(IO.noExtension(file.getAbsolutePath()) + string);
    }

    static {
        File file = null;
        try {
            file = File.createTempFile("jebgettemp", null);
            tempFolder = file.getParentFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        windowsIllegalFileNames = new HashSet<String>();
        windowsIllegalFileNames.add("con");
        windowsIllegalFileNames.add("prn");
        windowsIllegalFileNames.add("aux");
        windowsIllegalFileNames.add("nul");
        for (int j = 1; j <= 9; ++j) {
            windowsIllegalFileNames.add("com" + j);
            windowsIllegalFileNames.add("lpt" + j);
        }
    }
}

