/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ArraySeekableByteChannel
implements SeekableByteChannel {
    private byte[] data;
    private int arrayBaseOffset;
    private int length;
    private int position;

    public ArraySeekableByteChannel(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ArraySeekableByteChannel(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.arrayBaseOffset = n;
        this.length = n2;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = this.length - this.position;
        if (n <= 0) {
            return -1;
        }
        int n2 = byteBuffer.remaining();
        int n3 = n2 <= n ? n2 : n;
        byteBuffer.put(this.data, this.arrayBaseOffset + this.position, n3);
        this.position += n3;
        return n3;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new IOException("Buffer is not writeable");
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException(String.format("Negative position: %d", l2));
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException(String.format("Position is too large: %d", l2));
        }
        this.position = (int)l2;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.length;
    }

    @Override
    public SeekableByteChannel truncate(long l2) throws IOException {
        throw new IOException("Buffer cannot be truncated");
    }
}

