/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

public class TokenExtractor {
    public static final IDelimiterFinder DF_WhiteSpace = new WSPDelimiterFinder();
    public static final IDelimiterFinder DF_CommonSymbolChars = new SymbolDelimiterFinder();
    public static final IDelimiterFinder DF_NonAlphaNum = new PunctuationDelimiterFinder();
    private IDelimiterFinder delimiterFinder;

    public TokenExtractor(IDelimiterFinder iDelimiterFinder) {
        if (iDelimiterFinder == null) {
            throw new NullPointerException();
        }
        this.delimiterFinder = iDelimiterFinder;
    }

    public String extract(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        int n4 = 0;
        for (n2 = n; n2 < string.length(); ++n2) {
            c = string.charAt(n2);
            if (!this.delimiterFinder.isDelimiter(c)) continue;
            n3 = n2;
            break;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            c = string.charAt(n2);
            if (!this.delimiterFinder.isDelimiter(c)) continue;
            n4 = n2 + 1;
            break;
        }
        if (n4 >= n3) {
            return null;
        }
        return string.substring(n4, n3);
    }

    private static class PunctuationDelimiterFinder
    implements IDelimiterFinder {
        private PunctuationDelimiterFinder() {
        }

        @Override
        public boolean isDelimiter(char c) {
            return !Character.isAlphabetic(c) && !Character.isDigit(c);
        }
    }

    private static class SymbolDelimiterFinder
    implements IDelimiterFinder {
        private SymbolDelimiterFinder() {
        }

        @Override
        public boolean isDelimiter(char c) {
            return !Character.isJavaIdentifierPart(c);
        }
    }

    private static class WSPDelimiterFinder
    implements IDelimiterFinder {
        private WSPDelimiterFinder() {
        }

        @Override
        public boolean isDelimiter(char c) {
            return Character.isSpaceChar(c);
        }
    }

    public static interface IDelimiterFinder {
        public boolean isDelimiter(char var1);
    }
}

