/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.Strings;
import java.text.ParseException;
import java.util.Collection;
import java.util.Set;

public class Formatter {
    public static String formatBinaryBlock(byte[] byArray, int n, int n2, long l2, boolean bl2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n;
        for (int j = n2; j > 0; j -= n3) {
            int n5;
            if (bl2) {
                stringBuilder.append(String.format("%016X  ", (long)n4 - l2));
            } else {
                stringBuilder.append(String.format("%08X  ", n4 - (int)l2));
            }
            for (n5 = 0; n5 < 16 && n5 < j; ++n5) {
                stringBuilder.append(String.format("%02X ", byArray[n4 + n5]));
            }
            n3 = n5;
            while (n5 < 16) {
                stringBuilder.append("   ");
                ++n5;
            }
            stringBuilder.append(" ");
            for (n5 = 0; n5 < n3; ++n5) {
                byte by2 = byArray[n4 + n5];
                if (by2 >= 32 && by2 < 127) {
                    stringBuilder.append((char)by2);
                    continue;
                }
                stringBuilder.append(".");
            }
            stringBuilder.append("\n");
            n4 += n3;
        }
        return stringBuilder.toString();
    }

    public static String formatBinaryBlock(byte[] byArray, int n, int n2, int n3) {
        return Formatter.formatBinaryBlock(byArray, n, n2, n3, false);
    }

    public static String formatBinaryBlock(byte[] byArray, int n, int n2) {
        return Formatter.formatBinaryBlock(byArray, n, n2, 0);
    }

    public static String formatBinaryBlock(byte[] byArray) {
        return Formatter.formatBinaryBlock(byArray, 0, byArray.length);
    }

    public static String formatBinaryLine(byte[] byArray, int n, int n2, int n3) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        for (n4 = 0; n4 < n2; ++n4) {
            stringBuilder.append(String.format("%02X ", byArray[n + n4]));
        }
        while (n4 < n3) {
            stringBuilder.append("   ");
            ++n4;
        }
        return stringBuilder.toString();
    }

    public static String formatBinaryLine(byte[] byArray, int n, int n2) {
        return Formatter.formatBinaryLine(byArray, n, n2, n2);
    }

    public static String formatBinaryLine(byte[] byArray) {
        return Formatter.formatBinaryLine(byArray, 0, byArray.length, 0);
    }

    public static String formatBinaryLineTruncate(byte[] byArray, int n, int n2, int n3, char c) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = n2 <= n3 ? n2 : n3;
        for (n4 = 0; n4 < n5; ++n4) {
            if (n4 >= 1) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%02X", byArray[n + n4]));
        }
        if (n2 <= n3) {
            stringBuilder.append(" ");
            while (n4 < n3) {
                stringBuilder.append("   ");
                ++n4;
            }
        } else {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String formatBinaryLineTruncate(byte[] byArray, int n, int n2, int n3) {
        return Formatter.formatBinaryLineTruncate(byArray, n, n2, n3, '+');
    }

    public static String byteArrayToHexString(byte[] byArray) {
        return Formatter.byteArrayToHexString(byArray, 0, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n) {
        return Formatter.byteArrayToHexString(byArray, n, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        if (byArray == null || n < 0 || n2 > byArray.length || n > n2) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = n; j < n2; ++j) {
            stringBuilder.append(String.format("%02X", byArray[j]));
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToByteArray(String string, int n, int n2) {
        if (n < 0 || n > n2 || (n2 - n) % 2 != 0) {
            return null;
        }
        int n3 = (n2 - n) / 2;
        byte[] byArray = new byte[n3];
        for (int j = 0; j < n3; ++j) {
            try {
                byArray[j] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
                n += 2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return byArray;
    }

    public static byte[] hexStringToByteArray(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        if (string.endsWith("h")) {
            --n2;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n += 2;
        }
        return Formatter.hexStringToByteArray(string, n, n2);
    }

    public static boolean isPrintableChar(char c) {
        if (Character.isISOControl(c)) {
            return false;
        }
        if (Character.isSurrogate(c)) {
            return false;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        if (unicodeBlock == null) {
            return false;
        }
        return unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }

    public static String escapeCharacter(char c, boolean bl2) {
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (bl2 && Formatter.isPrintableChar(c)) {
            return Character.toString(c);
        }
        if (c >= '\u007f') {
            return String.format("\\u%04X", c);
        }
        if (c >= ' ') {
            return Character.toString(c);
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\f') {
            return "\\f";
        }
        return String.format("\\u%04X", c);
    }

    public static String escapeCharacter(char c) {
        return Formatter.escapeCharacter(c, true);
    }

    public static String escapeString(CharSequence charSequence) {
        return Formatter.escapeString(charSequence.toString(), true);
    }

    public static String escapeString(String string, boolean bl2) {
        return Formatter.escapeString(string, 1, bl2, null);
    }

    public static String escapeString(String string, int n, boolean bl2, Set<Character> set) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        if (n != 0 && Strings.hasRtl(string)) {
            if (n == 1) {
                stringBuilder.append('\u202a');
            } else if (n == 2) {
                stringBuilder.append('\u202b');
            } else {
                throw new IllegalArgumentException("Illegal directionality argument: " + n);
            }
            bl3 = true;
        }
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (set != null && set.contains(Character.valueOf(c))) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(Formatter.escapeCharacter(c, bl2));
        }
        if (bl3) {
            stringBuilder.append('\u202c');
        }
        return stringBuilder.toString();
    }

    public static String unescapeString(String string) throws ParseException {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\\') {
                if (n >= string.length()) {
                    throw new ParseException("String too short, need 1 char for escape", n);
                }
                if ((c = string.charAt(n++)) == '\'') {
                    string2 = string2 + '\\';
                    continue;
                }
                if (c == '\"') {
                    string2 = string2 + '\"';
                    continue;
                }
                if (c == '\'') {
                    string2 = string2 + '\'';
                    continue;
                }
                if (c == 'n') {
                    string2 = string2 + '\n';
                    continue;
                }
                if (c == 'r') {
                    string2 = string2 + '\r';
                    continue;
                }
                if (c == 't') {
                    string2 = string2 + '\t';
                    continue;
                }
                if (c == 'b') {
                    string2 = string2 + '\b';
                    continue;
                }
                if (c == 'f') {
                    string2 = string2 + '\f';
                    continue;
                }
                if (c == 'u') {
                    if (n + 4 > string.length()) {
                        throw new ParseException("String too short, need 4 chars for escape", n);
                    }
                    int n2 = Integer.parseInt(string.substring(n, n + 4), 16);
                    n += 4;
                    string2 = string2 + Character.valueOf((char)n2);
                    continue;
                }
                if (c == 'x') {
                    throw new ParseException("Cannot parse C escape \\x??", n);
                }
                throw new ParseException("Unknown escape: " + c, n);
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static String escapeToJavaStringArray(Collection<? extends Object> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new String[]{\n");
        for (Object object : collection) {
            stringBuilder.append("    \"").append(Formatter.escapeString(object.toString())).append("\",\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String escapeBytes(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = n; j < n + n2; ++j) {
            stringBuilder.append(Formatter.escapeCharacter((char)(byArray[j] & 0xFF), false));
        }
        return stringBuilder.toString();
    }

    public static String escapeBytes(byte[] byArray) {
        return Formatter.escapeBytes(byArray, 0, byArray.length);
    }

    public static String escapeByte(int n) {
        return Formatter.escapeBytes(new byte[]{(byte)n});
    }

    public static String formatHexNumbers(Collection<? extends Number> collection) {
        return Formatter.formatNumbers(collection, 16, null, null);
    }

    public static String formatNumbers(Collection<? extends Number> collection, int n, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("[");
        int n2 = 0;
        string = Strings.safe(string);
        string2 = Strings.safe(string2);
        if (n == 8) {
            for (Number number : collection) {
                if (n2 >= 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string).append(Long.toOctalString(number.longValue())).append(string2);
                ++n2;
            }
        } else if (n == 10) {
            for (Number number : collection) {
                if (n2 >= 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string).append(number.longValue()).append(string2);
                ++n2;
            }
        } else if (n == 16) {
            for (Number number : collection) {
                if (n2 >= 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string).append(Long.toHexString(number.longValue()).toUpperCase()).append(string2);
                ++n2;
            }
        } else {
            throw new IllegalArgumentException("Invalid base: " + n);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String integerToAlphaString(int n) {
        String string = "";
        boolean bl2 = false;
        if (n < 0) {
            n = -n;
            bl2 = true;
        }
        int n2 = 1;
        int n3 = 26;
        while (n >= n3) {
            n -= n3;
            n3 *= 26;
            ++n2;
        }
        for (int j = 0; j < n2; ++j) {
            int n4 = n % 26;
            n /= 26;
            string = (char)(97 + n4) + string;
        }
        return bl2 ? "-" + string : string;
    }

    public static String toHexString(long l2, boolean bl2, int n) {
        String string = Formatter.toHexString(l2, bl2);
        if (string.length() < n) {
            string = Strings.pad('0', n - string.length()) + string;
        }
        return string;
    }

    public static String toHexString(long l2, boolean bl2) {
        String string = Long.toHexString(l2);
        if (bl2) {
            string = string.toUpperCase();
        }
        return string;
    }

    public static String toHexString(int n, boolean bl2, int n2) {
        String string = Formatter.toHexString(n, bl2);
        if (string.length() < n2) {
            string = Strings.pad('0', n2 - string.length()) + string;
        }
        return string;
    }

    public static String toHexString(int n, boolean bl2) {
        String string = Integer.toHexString(n);
        if (bl2) {
            string = string.toUpperCase();
        }
        return string;
    }
}

