/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.encoding.zip.fsr.CentralDirFileHeader;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.EndOfCentralDir;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.LocalFileHeader;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipData;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipEntry;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ZipFailSafeReader
implements AutoCloseable {
    private static final ILogger logger = GlobalLog.getLogger(ZipFailSafeReader.class);
    static byte[] MAGIC_CENTRALDIR_FILEHDR = new byte[]{80, 75, 1, 2};
    static byte[] MAGIC_LOCAL_FILEHDR = new byte[]{80, 75, 3, 4};
    static byte[] MAGIC_END_OF_CENTRALDIR = new byte[]{80, 75, 5, 6};
    static byte[] MAGIC_DATA = new byte[]{80, 75, 7, 8};
    FileChannel fc;
    boolean treatUnsupportedCompressionAsDeflate;
    int archsize;
    int eocdRecordOffset;
    EndOfCentralDir eocr;
    List<ZipEntry> entries = new ArrayList<ZipEntry>();
    Map<String, ZipEntry> map = new LinkedHashMap<String, ZipEntry>();
    int offsetFirstEntry = Integer.MAX_VALUE;
    int offsetAppendedData;

    public ZipFailSafeReader(File file) throws IOException {
        this(file, true);
    }

    public ZipFailSafeReader(File file, boolean bl2) throws IOException {
        this.fc = FileChannel.open(file.toPath(), StandardOpenOption.READ);
        this.treatUnsupportedCompressionAsDeflate = bl2;
        if (this.fc.size() >= Integer.MAX_VALUE) {
            throw new IOException("Cannot handle archive greater than 2Gb");
        }
        this.archsize = (int)this.fc.size();
        if (this.archsize < 22) {
            throw new IOException("Illegal zip file: too small");
        }
        this.eocdRecordOffset = -1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);
        int n = this.archsize;
        while (n > 0) {
            n = Math.max(0, n - 509);
            this.fc.position(n);
            byteBuffer.clear();
            int n2 = this.fc.read(byteBuffer);
            int n3 = ZipFailSafeReader.find(byteBuffer.array(), n2, MAGIC_END_OF_CENTRALDIR);
            if (n3 < 0) continue;
            this.eocdRecordOffset = n + n3;
            break;
        }
        if (this.eocdRecordOffset < 0) {
            throw new IOException("The EOCD record was not found");
        }
        EndOfCentralDir endOfCentralDir = EndOfCentralDir.parse(this.fc, this.eocdRecordOffset);
        if (endOfCentralDir.diskNumber != 0 || endOfCentralDir.cdDiskStartIndex != 0) {
            throw new IOException("Multi-file archive not supported");
        }
        this.offsetAppendedData = this.eocdRecordOffset + endOfCentralDir.entrysize;
        ArrayList<CentralDirFileHeader> arrayList = new ArrayList<CentralDirFileHeader>();
        n = endOfCentralDir.cdOffset;
        for (int j = 0; j < endOfCentralDir.cdRecordCountOnThisDisk; ++j) {
            CentralDirFileHeader centralDirFileHeader = CentralDirFileHeader.parse(this.fc, n);
            arrayList.add(centralDirFileHeader);
            n += centralDirFileHeader.entrysize;
            LocalFileHeader localFileHeader = null;
            try {
                localFileHeader = LocalFileHeader.parse(this.fc, centralDirFileHeader.fileHeaderOffset);
            }
            catch (Exception exception) {
                logger.error("Zip File %s discrepancy: invalid local header", file);
                logger.catchingSilent(exception);
                return;
            }
            int n4 = centralDirFileHeader.fileHeaderOffset + localFileHeader.entrysize;
            ZipEntry zipEntry = new ZipEntry(localFileHeader, centralDirFileHeader, n4);
            this.entries.add(zipEntry);
            this.map.put(zipEntry.getFilenameUTF8(), zipEntry);
            if (!Arrays.equals(localFileHeader.filename, centralDirFileHeader.filename)) {
                String string = Strings.decodeUTF8(localFileHeader.filename);
                String string2 = Strings.decodeUTF8(centralDirFileHeader.filename);
                int n5 = Math.max(255, Math.min(string.length(), string2.length()));
                string = string.length() > n5 ? string.substring(0, n5 - 3) + "..." : string;
                string2 = string2.length() > n5 ? string2.substring(0, n5 - 3) + "..." : string2;
                logger.warn("Zip entry: name discrepancy: local_header=%s, center_header=%s", string, string2);
            }
            if (localFileHeader.flags != centralDirFileHeader.flags) {
                logger.warn("Zip entry: %s: flag discrepancy: local_header=0x%X, central_header=0x%X", zipEntry.getFilenameUTF8(), localFileHeader.flags, centralDirFileHeader.flags);
            }
            if (centralDirFileHeader.fileHeaderOffset >= this.offsetFirstEntry) continue;
            this.offsetFirstEntry = centralDirFileHeader.fileHeaderOffset;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fc != null) {
            this.fc.close();
            this.fc = null;
        }
    }

    public boolean isClosed() {
        return this.fc == null;
    }

    public int getOffsetFirstEntry() {
        return this.offsetFirstEntry;
    }

    public boolean hasPrependedData() {
        return this.offsetFirstEntry > 0;
    }

    public int getOffsetAppendedData() {
        return this.offsetAppendedData;
    }

    public boolean hasAppendedData() {
        return this.offsetAppendedData < this.archsize;
    }

    public boolean isTruncated() {
        return this.offsetAppendedData > this.archsize;
    }

    public int getNumberOfEntries() {
        return this.entries.size();
    }

    public List<ZipEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public ZipEntry getEntry(String string) {
        return this.map.get(string);
    }

    public boolean hasEntry(String string) {
        return this.map.containsKey(string);
    }

    public ZipData readData(String string) throws IOException {
        ZipEntry zipEntry = this.getEntry(string);
        if (zipEntry == null) {
            throw new IOException("Entry not found: " + string);
        }
        return this.readData(zipEntry);
    }

    public ZipData readData(ZipEntry zipEntry) throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("The archive is closed");
        }
        int n = zipEntry.getCompressedSize();
        if (n == 0) {
            return ZipData.EMPTY;
        }
        if (zipEntry.cdhdr.isEncrypted() && zipEntry.hdr.isEncrypted()) {
            throw new IOException("Entry is encrypted");
        }
        int n2 = zipEntry.cdhdr.compressionMethod;
        if (n2 != 0 && n2 != 8) {
            if (this.treatUnsupportedCompressionAsDeflate) {
                n2 = 8;
            } else {
                throw new IOException("Unsupported compression method: " + n2);
            }
        }
        ByteBuffer byteBuffer = ChannelUtil.read(this.fc, zipEntry.offsetToData, n, false);
        byte[] byArray = null;
        int n3 = 0;
        try {
            Object object;
            if (n2 == 0) {
                byArray = byteBuffer.array();
                n3 = byArray.length;
            } else if (n2 == 8) {
                object = new Inflater(true);
                ((Inflater)object).setInput(byteBuffer.array());
                byArray = new byte[zipEntry.getFilesize()];
                try {
                    n3 = ((Inflater)object).inflate(byArray);
                }
                catch (DataFormatException dataFormatException) {
                    throw new IOException(dataFormatException);
                }
                ((Inflater)object).end();
            } else {
                throw new RuntimeException("Unsupported compression method: " + n2);
            }
            if (n3 != zipEntry.getFilesize()) {
                throw new IOException(String.format("Corrupted entry: unexpected decompressed size: %d (expected %d)", n3, zipEntry.getFilesize()));
            }
            object = new CRC32();
            object.update(byArray);
            int n4 = (int)((CRC32)object).getValue();
            if (n4 != zipEntry.cdhdr.crc) {
                throw new IOException(String.format("Corrupted entry: unexpected CRC: %Xh (expected %Xh)", n4, zipEntry.cdhdr.crc));
            }
        }
        catch (IOException iOException) {
            return new ZipData(byArray, iOException);
        }
        return new ZipData(byArray);
    }

    private static int find(byte[] byArray, int n, byte[] byArray2) {
        block0: for (int j = 0; j < n; ++j) {
            if (byArray[j] != byArray2[0]) continue;
            int n2 = j + 1;
            for (int i2 = 1; n2 < n && i2 < byArray2.length; ++n2, ++i2) {
                if (byArray[n2] != byArray2[i2]) continue block0;
            }
            return j;
        }
        return -1;
    }

    public String toString() {
        return String.format("Zip archive: %d entries", this.getNumberOfEntries());
    }
}

