/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class EndOfCentralDir {
    int diskNumber;
    int cdDiskStartIndex;
    int cdRecordCountOnThisDisk;
    int cdRecordCountTotal;
    int cdSize;
    int cdOffset;
    byte[] comment = ArrayUtil.NO_BYTE;
    int entrysize;
    boolean corrupted;

    public static EndOfCentralDir parse(FileChannel fileChannel, int n) throws IOException {
        EndOfCentralDir endOfCentralDir = new EndOfCentralDir();
        try {
            endOfCentralDir.diskNumber = ChannelUtil.getLEShort(fileChannel, n + 4) & 0xFFFF;
            endOfCentralDir.cdDiskStartIndex = ChannelUtil.getLEShort(fileChannel, n + 6) & 0xFFFF;
            endOfCentralDir.cdRecordCountOnThisDisk = ChannelUtil.getLEShort(fileChannel, n + 8) & 0xFFFF;
            endOfCentralDir.cdRecordCountTotal = ChannelUtil.getLEShort(fileChannel, n + 10) & 0xFFFF;
            endOfCentralDir.cdSize = ChannelUtil.getLEInt(fileChannel, n + 12);
            endOfCentralDir.cdOffset = ChannelUtil.getLEInt(fileChannel, n + 16);
            int n2 = ChannelUtil.getLEShort(fileChannel, n + 20) & 0xFFFF;
            if (n2 > 0) {
                ByteBuffer byteBuffer = ChannelUtil.readBestEffort(fileChannel, n + 22, n2, false, null);
                if (byteBuffer.limit() != n2) {
                    endOfCentralDir.corrupted = true;
                }
                endOfCentralDir.comment = byteBuffer.array();
            }
            endOfCentralDir.entrysize = 22 + n2;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException);
        }
        return endOfCentralDir;
    }

    public String toString() {
        return String.format("%d/%d/offset=%Xh,size=%Xh,entries=%d/%d%s", this.diskNumber, this.cdDiskStartIndex, this.cdOffset, this.cdSize, this.cdRecordCountOnThisDisk, this.cdRecordCountTotal, this.corrupted ? "[BAD!]" : "");
    }
}

