/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class CentralDirFileHeader {
    int versionCreated;
    int versionRequired;
    int flags;
    int compressionMethod;
    int modTime;
    int modDate;
    int crc;
    int compressedSize;
    int filesize;
    byte[] filename = ArrayUtil.NO_BYTE;
    byte[] extra = ArrayUtil.NO_BYTE;
    byte[] comment = ArrayUtil.NO_BYTE;
    int diskNumber;
    int internalFileAttr;
    int externalFileAttr;
    int fileHeaderOffset;
    int entrysize;
    boolean corrupted;

    public static CentralDirFileHeader parse(FileChannel fileChannel, int n) throws IOException {
        CentralDirFileHeader centralDirFileHeader = new CentralDirFileHeader();
        try {
            ByteBuffer byteBuffer;
            centralDirFileHeader.versionCreated = ChannelUtil.getLEShort(fileChannel, n + 4) & 0xFFFF;
            centralDirFileHeader.versionRequired = ChannelUtil.getLEShort(fileChannel, n + 6) & 0xFFFF;
            centralDirFileHeader.flags = ChannelUtil.getLEShort(fileChannel, n + 8) & 0xFFFF;
            centralDirFileHeader.compressionMethod = ChannelUtil.getLEShort(fileChannel, n + 10) & 0xFFFF;
            centralDirFileHeader.modTime = ChannelUtil.getLEShort(fileChannel, n + 12) & 0xFFFF;
            centralDirFileHeader.modDate = ChannelUtil.getLEShort(fileChannel, n + 14) & 0xFFFF;
            centralDirFileHeader.crc = ChannelUtil.getLEInt(fileChannel, n + 16);
            centralDirFileHeader.compressedSize = ChannelUtil.getLEInt(fileChannel, n + 20);
            centralDirFileHeader.filesize = ChannelUtil.getLEInt(fileChannel, n + 24);
            int n2 = ChannelUtil.getLEShort(fileChannel, n + 28) & 0xFFFF;
            int n3 = ChannelUtil.getLEShort(fileChannel, n + 30) & 0xFFFF;
            int n4 = ChannelUtil.getLEShort(fileChannel, n + 32) & 0xFFFF;
            centralDirFileHeader.diskNumber = ChannelUtil.getLEShort(fileChannel, n + 34) & 0xFFFF;
            centralDirFileHeader.internalFileAttr = ChannelUtil.getLEShort(fileChannel, n + 36) & 0xFFFF;
            centralDirFileHeader.externalFileAttr = ChannelUtil.getLEInt(fileChannel, n + 38);
            centralDirFileHeader.fileHeaderOffset = ChannelUtil.getLEInt(fileChannel, n + 42);
            if (n2 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(fileChannel, n + 46, n2, false, null);
                if (byteBuffer.limit() != n2) {
                    centralDirFileHeader.corrupted = true;
                }
                centralDirFileHeader.filename = byteBuffer.array();
            }
            if (n3 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(fileChannel, n + 46 + n2, n3, false, null);
                if (byteBuffer.limit() != n3) {
                    centralDirFileHeader.corrupted = true;
                }
                centralDirFileHeader.extra = byteBuffer.array();
            }
            if (n4 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(fileChannel, n + 46 + n2 + n3, n4, false, null);
                if (byteBuffer.limit() != n4) {
                    centralDirFileHeader.corrupted = true;
                }
                centralDirFileHeader.extra = byteBuffer.array();
            }
            centralDirFileHeader.entrysize = 46 + n2 + n3 + n4;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException);
        }
        return centralDirFileHeader;
    }

    public String getFilename() {
        return new String(this.filename, Charset.forName("UTF-8"));
    }

    public boolean isEncrypted() {
        return (this.flags & 1) != 0;
    }

    public String toString() {
        return String.format("%s:%d(%d)%s", this.getFilename(), this.filesize, this.compressionMethod, this.corrupted ? "[BAD!]" : "");
    }
}

