/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.KeyOrder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Ser
public class MultiMap<K, V> {
    @SerId(value=1)
    private Map<K, List<V>> map;
    @SerId(value=2)
    private int cachedSize;

    public MultiMap() {
        this(KeyOrder.NONE);
    }

    public MultiMap(KeyOrder keyOrder) {
        if (keyOrder == null) {
            throw new NullPointerException("Illegal key order");
        }
        switch (keyOrder) {
            case NONE: {
                this.map = new HashMap<K, List<V>>();
                break;
            }
            case INSERTION: {
                this.map = new LinkedHashMap<K, List<V>>();
                break;
            }
            case NATURAL: {
                this.map = new TreeMap<K, List<V>>();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.cachedSize = 0;
    }

    public void clear() {
        this.map.clear();
        this.cachedSize = 0;
    }

    public int keySize() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    public int size() {
        return this.cachedSize;
    }

    public int put(K k2, V v2) {
        List<V> list = this.map.get(k2);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(k2, list);
        }
        list.add(v2);
        ++this.cachedSize;
        return list.size();
    }

    public void putMulti(K k2, Collection<? extends V> collection) {
        for (V v2 : collection) {
            this.put(k2, v2);
        }
    }

    public void putAll(Map<? extends K, List<? extends V>> map) {
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            for (V v2 : entry.getValue()) {
                this.put(entry.getKey(), v2);
            }
        }
    }

    public boolean createKey(K k2) {
        List<V> list = this.map.get(k2);
        if (list != null) {
            return false;
        }
        this.map.put(k2, new ArrayList());
        return true;
    }

    public boolean containsKey(K k2) {
        return this.map.containsKey(k2);
    }

    public boolean containsValue(V v2) {
        for (List<V> list : this.map.values()) {
            if (!list.contains(v2)) continue;
            return true;
        }
        return false;
    }

    public List<V> get(K k2) {
        return this.get(k2, false);
    }

    public List<V> get(K k2, boolean bl2) {
        List<V> list = this.map.get(k2);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        if (bl2) {
            return Collections.emptyList();
        }
        return null;
    }

    public List<V> getSafe(K k2) {
        return this.get(k2, true);
    }

    public List<V> remove(K k2) {
        List<V> list = this.map.remove(k2);
        if (list != null) {
            this.cachedSize -= list.size();
        }
        return list;
    }

    public V removeValue(K k2, V v2) {
        List<V> list = this.map.get(k2);
        if (list == null) {
            return null;
        }
        if (!list.remove(v2)) {
            return null;
        }
        --this.cachedSize;
        return v2;
    }

    public int removeMulti(K k2, Collection<? extends V> collection) {
        List<V> list = this.map.get(k2);
        if (collection == null) {
            return 0;
        }
        int n = 0;
        for (V v2 : collection) {
            if (!list.remove(v2)) continue;
            --this.cachedSize;
            ++n;
        }
        return n;
    }

    public Collection<V> values() {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (List<V> list : this.map.values()) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public String toString() {
        return this.map.toString();
    }
}

