/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

@Ser
public class CFBytesTrie<T> {
    @SerId(value=1)
    private IKeyExtractor<T> keyExtractor;
    @SerId(value=2)
    private Node[] array0;
    @SerId(value=3)
    private int cnt;

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        serializerHelper.getStream().write(this.keyExtractor == null ? 0 : 1);
        if (this.keyExtractor == null) {
            serializerHelper.saveStandard();
            return;
        }
        List<T> list = this.getValues();
        if (list.size() != this.cnt) {
            throw new RuntimeException(String.format("Unexpected size: actual=%d, expected=%d", list.size(), this.cnt));
        }
        serializerHelper.write(this.keyExtractor);
        serializerHelper.write(this.cnt);
        for (T t : list) {
            serializerHelper.write(t);
        }
    }

    @SerCustomRead
    private void load(DeserializerHelper deserializerHelper) throws IOException {
        int n = deserializerHelper.getStream().read();
        if (n == 0) {
            deserializerHelper.loadStandard();
            return;
        }
        this.keyExtractor = (IKeyExtractor)deserializerHelper.read();
        int n2 = (Integer)deserializerHelper.read();
        for (int j = 0; j < n2; ++j) {
            Object object = deserializerHelper.read();
            this.put(object);
        }
    }

    public void setKeyExtractor(IKeyExtractor<T> iKeyExtractor) {
        this.keyExtractor = iKeyExtractor;
    }

    public IKeyExtractor<T> getKeyExtractor() {
        return this.keyExtractor;
    }

    public void clear() {
        this.array0 = null;
        this.cnt = 0;
    }

    public int size() {
        return this.cnt;
    }

    public boolean isEmpty() {
        return this.cnt == 0;
    }

    public void put(T t) {
        if (this.keyExtractor == null) {
            throw new IllegalStateException();
        }
        this.put(this.keyExtractor.extract(t), t);
    }

    public void put(byte[] byArray, T t) {
        this.put(byArray, 0, byArray.length, t);
    }

    public T put(byte[] byArray, int n, int n2, T t) {
        Node node;
        if (t == null) {
            throw new NullPointerException("The value cannot be null");
        }
        if (n >= n2) {
            throw new IllegalArgumentException("Needs at least one byte of key data");
        }
        int n3 = byArray[n] & 0xFF;
        if (this.array0 == null) {
            this.array0 = new Node[256];
        }
        if ((node = this.array0[n3]) == null) {
            this.array0[n3] = node = new Node();
        }
        for (int j = n + 1; j < n2; ++j) {
            Node node2;
            int n4 = byArray[j] & 0xF;
            if (node.next == null) {
                if (node.object != null) {
                    throw new IllegalStateException("Prefix collision");
                }
                node.next = new Node[16];
            }
            if ((node2 = node.next[n4]) == null) {
                node.next[n4] = node2 = new Node();
            }
            node = node2;
            int n5 = byArray[j] >> 4 & 0xF;
            if (node.next == null) {
                if (node.object != null) {
                    throw new IllegalStateException("Prefix collision");
                }
                node.next = new Node[16];
            }
            if ((node2 = node.next[n5]) == null) {
                node.next[n5] = node2 = new Node();
            }
            node = node2;
        }
        if (node.next != null) {
            throw new IllegalStateException("Prefix collision");
        }
        Object object = node.object;
        if (object == null) {
            ++this.cnt;
        }
        node.object = t;
        return (T)object;
    }

    public T get(byte[] byArray, boolean bl2) {
        return this.get(byArray, 0, byArray.length, bl2);
    }

    public T get(byte[] byArray, int n, int n2, boolean bl2) {
        int n3;
        Object object = null;
        if (n >= n2) {
            throw new IllegalArgumentException("Needs at least one byte of key data");
        }
        if (this.array0 == null) {
            return null;
        }
        int n4 = byArray[n] & 0xFF;
        Node node = this.array0[n4];
        if (node == null) {
            return null;
        }
        if (node.object != null) {
            object = node.object;
        }
        if (object == null) {
            for (n3 = n + 1; n3 < n2; ++n3) {
                if (node.next == null) {
                    return null;
                }
                int n5 = byArray[n3] & 0xF;
                node = node.next[n5];
                if (node == null) {
                    return null;
                }
                if (node.object != null) {
                    object = node.object;
                    break;
                }
                if (node.next == null) {
                    return null;
                }
                int n6 = byArray[n3] >> 4 & 0xF;
                node = node.next[n6];
                if (node == null) {
                    return null;
                }
                if (node.object == null) continue;
                object = node.object;
                break;
            }
        }
        if (bl2 && n3 != n2) {
            return null;
        }
        return (T)object;
    }

    public String formatInternalState() {
        State state = new State();
        if (this.array0 != null) {
            state.nodeCount = 1;
            for (Node node : this.array0) {
                this.checkNodeRecurse(node, state, 1);
            }
        }
        Node[] nodeArray = new StringBuilder();
        double d2 = -1.0;
        if (state.nodeCount > 0) {
            d2 = (double)state.objectCount / (double)(256 + (state.nodeCount - 1) * 16);
        }
        nodeArray.append(String.format("cnt=%d nodes=%d depth=%d occupancy=%.3f", state.objectCount, state.nodeCount, state.maxDepth, d2));
        return nodeArray.toString();
    }

    private void checkNodeRecurse(Node node, State state, int n) {
        if (node == null) {
            return;
        }
        if (n > state.maxDepth) {
            state.maxDepth = n;
        }
        if (node.object != null) {
            ++state.objectCount;
        }
        if (node.next != null) {
            ++state.nodeCount;
            for (Node node2 : node.next) {
                this.checkNodeRecurse(node2, state, n + 1);
            }
        }
    }

    public List<T> getValues() {
        ArrayList arrayList = new ArrayList();
        if (this.array0 != null) {
            for (Node node : this.array0) {
                this.getValuesRecurse(node, arrayList);
            }
        }
        return arrayList;
    }

    private void getValuesRecurse(Node node, List<T> list) {
        if (node == null) {
            return;
        }
        if (node.object != null) {
            list.add(node.object);
        }
        if (node.next != null) {
            for (Node node2 : node.next) {
                this.getValuesRecurse(node2, list);
            }
        }
    }

    public List<Couple<byte[], T>> getItems() {
        ArrayList<Couple<byte[], T>> arrayList = new ArrayList<Couple<byte[], T>>();
        if (this.array0 != null) {
            ArrayDeque<Byte> arrayDeque = new ArrayDeque<Byte>();
            int n = 0;
            for (Node node : this.array0) {
                arrayDeque.push((byte)n);
                this.getItemsRecurse(node, arrayList, arrayDeque);
                arrayDeque.pop();
                ++n;
            }
        }
        return arrayList;
    }

    private void getItemsRecurse(Node node, List<Couple<byte[], T>> list, Deque<Byte> deque) {
        if (node == null) {
            return;
        }
        if (node.object != null) {
            list.add(new Couple<byte[], Object>(this.buildKey(deque), node.object));
        }
        if (node.next != null) {
            int n = 0;
            for (Node node2 : node.next) {
                deque.push((byte)n);
                this.getItemsRecurse(node2, list, deque);
                deque.pop();
                ++n;
            }
        }
    }

    private byte[] buildKey(Deque<Byte> deque) {
        int n = deque.size();
        Assert.a(n >= 1 && n % 2 == 1);
        byte[] byArray = new byte[1 + (n - 1) / 2];
        int n2 = 0;
        Iterator<Byte> iterator = deque.descendingIterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            byte by2 = iterator.next();
            if (n2 == 0) {
                byArray[0] = by2;
            } else if (n2 % 2 != 0) {
                byArray[n3] = by2;
            } else {
                byArray[n3] = (byte)(byArray[n3] | by2 << 4);
                ++n3;
            }
            ++n2;
        }
        return byArray;
    }

    static class State {
        int objectCount;
        int nodeCount;
        int maxDepth;

        State() {
        }
    }

    @Ser
    public static class Node {
        @SerId(value=1)
        Node[] next;
        @SerId(value=2)
        Object object;
    }

    @Ser
    public static interface IKeyExtractor<T> {
        public byte[] extract(T var1);
    }
}

