/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

public class BytePipe {
    private static final int pageSize = 4096;
    private byte[] buffer;
    private volatile int capacity;
    private volatile int position;
    private volatile int limit;
    private Object consumer = new Object();
    private int waitingOn = 0;

    public BytePipe() {
        this(4096);
    }

    public BytePipe(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Capacity cannot be negative");
        }
        this.capacity = n;
        this.buffer = new byte[this.capacity];
        this.position = 0;
        this.limit = 0;
    }

    private int round(int n) {
        return (n + 4096 - 1) / 4096 * 4096;
    }

    public int capacity() {
        return this.capacity;
    }

    public int available() {
        return this.limit - this.position;
    }

    protected int position() {
        return this.position;
    }

    protected int limit() {
        return this.limit;
    }

    public synchronized void reset() {
        this.limit = 0;
        this.position = 0;
    }

    public synchronized void append(byte[] byArray, int n, int n2) {
        if (this.limit + n2 > this.capacity) {
            int n3 = this.available();
            if (n3 + n2 > this.capacity) {
                int n4 = this.round(2 * (n3 + n2));
                byte[] byArray2 = new byte[n4];
                this.copyBytes(byArray2, 0, this.buffer, this.position, this.limit);
                this.buffer = byArray2;
                this.capacity = n4;
            } else {
                this.copyBytes(this.buffer, 0, this.buffer, this.position, this.limit);
            }
            this.position = 0;
            this.limit = n3;
        }
        this.copyBytes(this.buffer, this.limit, byArray, n, n + n2);
        this.limit += n2;
        this.makeAvailable();
    }

    public synchronized void append(byte[] byArray) {
        this.append(byArray, 0, byArray.length);
    }

    public synchronized void append(byte by2) {
        if (this.limit >= this.capacity) {
            int n = this.available();
            if (n >= this.capacity) {
                int n2 = this.round(2 * (n + 1));
                byte[] byArray = new byte[n2];
                this.copyBytes(byArray, 0, this.buffer, this.position, this.limit);
                this.buffer = byArray;
                this.capacity = n2;
            } else {
                this.copyBytes(this.buffer, 0, this.buffer, this.position, this.limit);
            }
            this.position = 0;
            this.limit = n;
        }
        this.buffer[this.limit] = by2;
        ++this.limit;
        this.makeAvailable();
    }

    public synchronized void append(int n) {
        this.append((byte)n);
    }

    public synchronized void get(byte[] byArray, int n, int n2) {
        this.verifyAvailable(n2);
        this.copyBytes(byArray, n, this.buffer, this.position, this.position + n2);
        this.position += n2;
    }

    public synchronized void get(byte[] byArray) {
        this.get(byArray, 0, byArray.length);
    }

    public synchronized int get() {
        this.verifyAvailable(1);
        return this.buffer[this.position++] & 0xFF;
    }

    public synchronized byte[] getAll() {
        byte[] byArray = new byte[this.available()];
        this.get(byArray);
        return byArray;
    }

    public synchronized void peek(byte[] byArray, int n, int n2) {
        this.verifyAvailable(n2);
        this.copyBytes(byArray, n, this.buffer, this.position, this.position + n2);
    }

    public synchronized void peek(byte[] byArray) {
        this.peek(byArray, 0, byArray.length);
    }

    public synchronized byte peek() {
        this.verifyAvailable(1);
        return this.buffer[this.position];
    }

    public synchronized void skip(int n) {
        this.verifyAvailable(n);
        this.position += n;
    }

    private void verifyAvailable(int n) {
        int n2 = this.available();
        if (n2 < n) {
            throw new RuntimeException("Not enough bytes are available: requesting " + n + ", has only " + n2);
        }
    }

    private void copyBytes(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2 && n >= n2) {
            throw new IllegalArgumentException(String.format("Illegal offsets for idem-buffers: src:%d dst:%d", n2, n));
        }
        System.arraycopy(byArray2, n2, byArray, n, n3 - n2);
    }

    public int readWait(long l2) {
        int n;
        if (this.available() < 1 && (n = this.blockUntilAvailable(1, l2)) < 1) {
            return -1;
        }
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockUntilAvailable(int n, long l2) {
        if (n > 0) {
            Object object = this.consumer;
            synchronized (object) {
                this.waitingOn = n;
                try {
                    long l3 = System.nanoTime();
                    while (this.available() < this.waitingOn) {
                        long l4;
                        this.consumer.wait(l2);
                        if (l2 == 0L || (l4 = (System.nanoTime() - l3) / 1000000L) < l2) continue;
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.waitingOn = 0;
            }
        }
        return this.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAvailable() {
        Object object = this.consumer;
        synchronized (object) {
            if (this.waitingOn > 0 && this.available() >= this.waitingOn) {
                this.consumer.notify();
            }
        }
    }
}

