/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Arrays;

@Ser
public class BitMap {
    @SerId(value=1)
    private int bitsize;
    @SerId(value=2)
    private boolean[] array;

    public BitMap(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal size for bitmap: " + n);
        }
        this.bitsize = n;
        this.array = new boolean[n];
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + Arrays.hashCode(this.array);
        n2 = 31 * n2 + this.bitsize;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BitMap bitMap = (BitMap)object;
        if (!Arrays.equals(this.array, bitMap.array)) {
            return false;
        }
        return this.bitsize == bitMap.bitsize;
    }

    public int size() {
        return this.bitsize;
    }

    public int countOnes() {
        int n = 0;
        for (int j = 0; j < this.bitsize; ++j) {
            if (!this.get(j)) continue;
            ++n;
        }
        return n;
    }

    public int countZeros() {
        return this.size() - this.countOnes();
    }

    public void clear() {
        for (int j = 0; j < this.bitsize; ++j) {
            this.set(j, false);
        }
    }

    public boolean set(int n, boolean bl2) {
        if (n < 0 || n >= this.bitsize) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        boolean bl3 = this.array[n];
        this.array[n] = bl2;
        return bl3;
    }

    public boolean get(int n) {
        if (n < 0 || n >= this.bitsize) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.array[n];
    }

    public boolean isFull() {
        for (int j = 0; j < this.bitsize; ++j) {
            if (this.get(j)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (int j = 0; j < this.bitsize; ++j) {
            if (!this.get(j)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < this.bitsize; ++j) {
            stringBuilder.append(this.get(j) ? "1" : "0");
        }
        return stringBuilder.toString();
    }

    public String formatAsRanges() {
        return this.formatAsRanges(true);
    }

    public String formatAsRanges(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        for (int j = 0; j < this.bitsize; ++j) {
            if (n < 0 && this.get(j)) {
                n = j;
                continue;
            }
            if (n < 0 || this.get(j)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("U");
            }
            if (n + 1 == j) {
                stringBuilder.append(String.format("[%d]", n));
            } else if (bl2) {
                stringBuilder.append(String.format("[%d,%d)", n, j));
            } else {
                stringBuilder.append(String.format("[%d,%d]", n, j - 1));
            }
            n = -1;
        }
        if (stringBuilder.length() == 0) {
            return "[]";
        }
        return stringBuilder.toString();
    }
}

