/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.winpe;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.SubInput;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.codeobject.AbstractCodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFSectionHeader;
import com.pnfsoftware.jeb.core.units.codeobject.IPECOFFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.IPEOptionalHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.corei.parsers.winpe.OI;
import com.pnfsoftware.jeb.corei.parsers.winpe.Rf;
import com.pnfsoftware.jeb.corei.parsers.winpe.ej;
import com.pnfsoftware.jeb.corei.parsers.winpe.of;
import com.pnfsoftware.jeb.corei.parsers.winpe.pX;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.AS;
import com.pnfsoftware.jebglobal.Au;
import com.pnfsoftware.jebglobal.FM;
import com.pnfsoftware.jebglobal.RU;
import com.pnfsoftware.jebglobal.ZK;
import com.pnfsoftware.jebglobal.cL;
import com.pnfsoftware.jebglobal.gN;
import com.pnfsoftware.jebglobal.ge;
import com.pnfsoftware.jebglobal.wA;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

@Ser
public class Io
extends AbstractCodeObjectUnit
implements IPECOFFUnit {
    private static final ILogger KQ = GlobalLog.getLogger(Io.class);
    @SerId(value=1)
    ej eO;
    @SerId(value=2)
    pX Le;
    @SerId(value=3)
    Rf[] Qx;
    @SerId(value=4)
    boolean lS;
    @SerId(value=5)
    boolean ae;
    @SerId(value=6)
    boolean TI;
    @SerId(value=7)
    boolean vT;

    public Io(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(iInput, "winpe", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean processInternal() {
        Object object;
        int n;
        Object object2;
        Object object3;
        long l2 = 0L;
        try {
            object3 = this.getInput().getChannel();
            Throwable throwable = null;
            try {
                int n2;
                int n3;
                long l3 = object3.size();
                if (l3 <= 64L) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (ChannelUtil.getLEShort((SeekableByteChannel)object3, 0L) != 23117) {
                    boolean bl3 = false;
                    return bl3;
                }
                int n4 = ChannelUtil.getLEInt((SeekableByteChannel)object3, 60L);
                if (n4 < 0 || (long)(n4 + 4) > l3) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (ChannelUtil.getLEInt((SeekableByteChannel)object3, n4) != 17744) {
                    boolean bl5 = false;
                    return bl5;
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
                object3.position(n4 + 4);
                if (object3.read(byteBuffer) != 20) {
                    boolean bl6 = false;
                    return bl6;
                }
                byteBuffer.rewind();
                this.eO = ej.eO(byteBuffer);
                short s2 = ChannelUtil.getLEShort((SeekableByteChannel)object3, n4 + 4 + 20);
                if (s2 == 523) {
                    this.lS = true;
                } else if (s2 != 267) {
                    KQ.error("Invalid optional header magic: %X", s2);
                    boolean bl7 = false;
                    return bl7;
                }
                byteBuffer = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);
                object3.position(n4 + 4 + 20);
                int n5 = object3.read(byteBuffer);
                if (n5 < 69) {
                    boolean bl8 = false;
                    return bl8;
                }
                byteBuffer.rewind();
                byteBuffer.limit(n5);
                this.Le = pX.eO(byteBuffer, this.lS);
                int n6 = this.Le.qo;
                int n7 = this.Le.lo;
                if (!MathUtil.isPowerOfTwo(n6) || !MathUtil.isPowerOfTwo(n7)) {
                    KQ.error("Invalid alignments, must be a power of 2 (file=%Xh, section=%Xh)", n6, n7);
                    boolean bl9 = false;
                    return bl9;
                }
                if (n7 <= 4096) {
                    this.ae = true;
                }
                if (n6 > n7) {
                    KQ.error("Invalid alignments (file=%Xh, section=%Xh)", n6, n7);
                    boolean bl10 = false;
                    return bl10;
                }
                this.Qx = new Rf[this.eO.Le];
                if (this.Qx.length > 0) {
                    object3.position(n4 + 4 + 20 + this.eO.TI);
                    byteBuffer = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
                    long l4 = -1L;
                    for (n3 = 0; n3 < this.Qx.length; ++n3) {
                        String string;
                        int n8;
                        long l5;
                        long l6;
                        long l7;
                        byteBuffer.rewind();
                        if (object3.read(byteBuffer) != 40) {
                            boolean bl11 = false;
                            return bl11;
                        }
                        byteBuffer.rewind();
                        object2 = Rf.eO(byteBuffer);
                        this.Qx[n3] = object2;
                        long l8 = ((Rf)object2).ae;
                        long l9 = ((Rf)object2).lS;
                        long l10 = ((Rf)object2).Le;
                        if (!this.ae) {
                            l7 = l8 & 0xFFFFFFFFFFFFFE00L;
                            l6 = (l8 + l9 + (long)n6 - 1L & (long)(~(n6 - 1))) - l7;
                            l6 = Math.min(l6, l9 + 4095L & 0xFFFFFFFFFFFFF000L);
                            if (l10 != 0L) {
                                l6 = Math.min(l6, l10 + 4095L & 0xFFFFFFFFFFFFF000L);
                            }
                        } else {
                            l7 = l8 & (long)(~(n6 - 1));
                            l6 = l9;
                            if (l10 != 0L) {
                                l6 = Math.min(l6, l10 + (long)n7 - 1L & (long)(~(n7 - 1)));
                            }
                        }
                        if (l6 > Integer.MAX_VALUE) {
                            throw new RuntimeException("Section is too large");
                        }
                        long l11 = l7 + l6;
                        if (l11 > l2) {
                            l2 = l11;
                        }
                        if ((l5 = ((Rf)object2).Qx) % (long)n7 != 0L) {
                            KQ.error("Invalid segment memory address", new Object[0]);
                            boolean bl12 = false;
                            return bl12;
                        }
                        if (l10 == 0L) {
                            l10 = l6;
                        }
                        if (l4 != -1L && l4 != l5) {
                            String string2 = String.format("Illegal section, PE unlikely to load: expected RVA= %Xh, actual=%Xh", l4, l5);
                            this.addNotification(new UnitNotification(NotificationType.CORRUPTION, string2));
                        }
                        long l12 = (l10 + (long)n7 - 1L) / (long)n7 * (long)n7;
                        l4 = l5 + l12;
                        try {
                            for (n8 = 0; n8 < ((Rf)object2).eO.length && ((Rf)object2).eO[n8] != 0; ++n8) {
                            }
                            string = Strings.decodeASCII(((Rf)object2).eO, 0, n8);
                        }
                        catch (Exception exception) {
                            string = "";
                        }
                        n8 = this.Le(((Rf)object2).XV);
                        this.addSegment(new SegmentInformation(string, l7, l6, l5, l12, n8));
                        KQ.i("Segment '%s': file=%Xh(size=%Xh) memory=%Xh(size=%Xh)", string, l7, l6, l5, l12);
                    }
                }
                int n9 = (int)object3.size();
                if (this.Qx.length >= 1) {
                    n2 = (int)this.Qx[0].ae;
                    for (n3 = 1; n2 == 0 && n3 < this.Qx.length; ++n3) {
                        n2 = (int)this.Qx[n3].ae;
                    }
                    if (n2 != 0 && n2 < n9) {
                        n9 = n2;
                    }
                }
                if ((n2 = (int)this.Le.OP) < n9) {
                    n9 = n2;
                }
                this.insertSegment(0, new SegmentInformation("<hdr>", 0L, n9, 0L, n9, 2));
                if (this.eO.lS != 0 && this.eO.ae >= 0) {
                    this.eO((SeekableByteChannel)object3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object3 != null) {
                    if (throwable != null) {
                        try {
                            object3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object3.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            KQ.i("Not a PE file: %s", iOException);
            return false;
        }
        object3 = new LoaderInformation.Builder();
        int n10 = 0;
        if ((this.eO.vT & 0x2000) != 0) {
            n10 |= 4;
        }
        ((LoaderInformation.Builder)object3).setFlags(n10);
        ((LoaderInformation.Builder)object3).setTargetProcessor(this.Qx(this.eO.eO));
        ((LoaderInformation.Builder)object3).setTargetSubsystem(this.ae(this.Le.Vj));
        ((LoaderInformation.Builder)object3).setEndianness(this.lS(this.eO.eO));
        ((LoaderInformation.Builder)object3).setWordSize(this.lS ? 64 : 32);
        ((LoaderInformation.Builder)object3).setCompilationTimestamp(this.eO.getTimestampMs());
        ((LoaderInformation.Builder)object3).setImageBase(this.Le.XV);
        ((LoaderInformation.Builder)object3).setImageSize(this.Le.hd);
        ((LoaderInformation.Builder)object3).setEntryPoint(this.Le.vT);
        ((LoaderInformation.Builder)object3).setOverlayOffset(l2);
        this.setLoaderInformation(((LoaderInformation.Builder)object3).build());
        for (n = 0; n < this.Le.BQ.length; ++n) {
            object = this.Le.BQ[n];
            String string = n < OI.eO.length ? OI.eO[n] : "-";
            long l13 = 0L;
            if (((OI)object).Qx != 0L) {
                l13 = this.convertRelativeAddressToFileOffset(((OI)object).Qx);
            }
            this.addSection(new SegmentInformation(string, l13, ((OI)object).lS, ((OI)object).Qx, ((OI)object).lS, 0));
        }
        if ((this.eO.vT & 2) != 0) {
            Assert.a(this.getRawMemoryMappedImage() != null);
            try {
                this.Le();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to process Exports", new Object[0]);
            }
            try {
                this.eO();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to process Imports", new Object[0]);
            }
            try {
                this.Qx();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to process Thread Local Storage", new Object[0]);
            }
            try {
                this.lS();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to parse Rich header", new Object[0]);
            }
            n = 1;
            if (this.TI) {
                // empty if block
            }
            if (n != 0) {
                try {
                    IUnit iUnit;
                    object = Io.eO(this.eO);
                    if (object != null && (iUnit = this.getUnitProcessor().process((String)object + " image", this.getInput(), this, (String)object, true)) != null) {
                        this.addChildUnit(iUnit);
                    }
                }
                catch (Exception exception) {
                    KQ.catching(exception);
                    this.addNotification(new UnitNotification(NotificationType.UNSUPPORTED_FEATURE, "The machine code was not disassembled"));
                }
            }
        }
        if (this.Le.BQ.length > 2) {
            OI oI = this.Le.BQ[2];
            if (oI.Qx > 0L && oI.lS > 0L) {
                object = new Au(this.getRawMemoryMappedImage(), this.Le.XV + oI.Qx, oI.lS);
                try {
                    ((Au)object).TI();
                    int n11 = ((Au)object).ae();
                    if (n11 > 3) {
                        this.logWarn(true, "PE uses a non-standard type/name/language resource tree; max tree depth is %d when It should be 3", n11);
                    }
                    if (((Au)object).Le() && !((Au)object).Qx()) {
                        this.logWarn(true, "PE has a resource tree but does not contain resource data", new Object[0]);
                    }
                    if (((Au)object).Qx()) {
                        ContainerUnit containerUnit = new ContainerUnit("Resources", this.getUnitProcessor(), this, this.getPropertyDefinitionManager());
                        containerUnit.process();
                        this.addChild(containerUnit);
                        StringBuilder stringBuilder = new StringBuilder();
                        ge ge2 = new ge();
                        FM fM = ((Au)object).eO();
                        for (FM fM2 : fM.TI()) {
                            if (fM2.vT()) continue;
                            String string = ((Au)object).eO(fM2);
                            String string3 = ((Au)object).Le(fM2);
                            object2 = new ContainerUnit(string3, containerUnit.getUnitProcessor(), containerUnit, containerUnit.getPropertyDefinitionManager());
                            ((ContainerUnit)object2).process();
                            containerUnit.addChild((IUnit)object2);
                            for (gN gN2 : fM2.LZ()) {
                                String string4 = ((Au)object).Le(gN2.eO());
                                byte[] byArray = new byte[gN2.Qx()];
                                this.getRawMemoryMappedImage().read(this.Le.XV + (long)gN2.Le(), gN2.Qx(), byArray, 0);
                                IUnit iUnit = this.getUnitProcessor().process(string4, new BytesInput(byArray), (IUnitCreator)object2);
                                if (iUnit != null) {
                                    ((AbstractUnit)object2).addChildUnit(iUnit);
                                } else {
                                    this.logError(true, "Cannot parse Resource entry \"%s\"", string4);
                                }
                                if (((Au)object).eO(fM2).equals("VERSION")) {
                                    try {
                                        RU rU2 = new RU(byArray);
                                        String string5 = rU2.eO();
                                        if (stringBuilder.length() > 0) {
                                            stringBuilder.append(Strings.generate('-', 80) + "\n");
                                        }
                                        stringBuilder.append(string5);
                                    }
                                    catch (Exception exception) {
                                        KQ.catching(exception);
                                    }
                                    continue;
                                }
                                if (string.equals("ICON") || string.equals("GROUP_ICON") || !string.equals("STRING")) continue;
                                try {
                                    ge2.eO(gN2, byArray);
                                }
                                catch (Exception exception) {
                                    KQ.catching(exception);
                                }
                            }
                        }
                        if (stringBuilder.length() > 0) {
                            IUnit iUnit = this.getUnitProcessor().process("versions.txt", new BytesInput(Strings.encodeUTF8(stringBuilder.toString())), containerUnit);
                            containerUnit.addChild(iUnit);
                        }
                        ge2.eO(containerUnit);
                    }
                }
                catch (Exception exception) {
                    KQ.catching(exception);
                    this.logError(true, "Resources processing failed! (%s)", exception.toString());
                    JebCoreService.notifySilentExceptionToClient(exception);
                }
            }
        }
        if (this.Le.BQ.length > 4) {
            OI oI = this.Le.BQ[4];
            long l14 = oI.Qx;
            long l15 = this.getInput().getCurrentSize();
            if (l14 > 0L && l14 < l15 && oI.lS > 0L && oI.lS < l15 && l14 + oI.lS <= l15) {
                cL cL2 = new cL(this.getInput(), (int)oI.Qx, (int)oI.lS);
                try {
                    cL2.Qx();
                    if (cL2.eO()) {
                        ContainerUnit containerUnit = new ContainerUnit("Certificates", this.getUnitProcessor(), this, this.getPropertyDefinitionManager());
                        containerUnit.process();
                        this.addChild(containerUnit);
                        int n12 = 0;
                        for (AS aS : cL2.Le()) {
                            String string = aS.lS();
                            object2 = aS.ae();
                            String string6 = String.format("Certificate #%d (%s, %s)", n12, string, object2);
                            IUnit iUnit = this.getUnitProcessor().process(string6, new BytesInput(aS.Qx()), containerUnit);
                            if (iUnit != null) {
                                containerUnit.addChildUnit(iUnit);
                                continue;
                            }
                            this.logError(true, "Cannot parse Certificate entry \"%s\"", string6);
                        }
                    }
                }
                catch (Exception exception) {
                    KQ.catching(exception);
                    this.logError(true, "Certificates processing failed! (%s)", exception.toString());
                    JebCoreService.notifySilentExceptionToClient(exception);
                }
            }
        }
        if (this.Qx != null && this.Qx.length > 0) {
            try (SeekableByteChannel seekableByteChannel = this.getInput().getChannel();){
                long l16 = seekableByteChannel.size();
                if (l16 > l2) {
                    this.vT = true;
                    long l17 = l16 - l2;
                    SubInput subInput = new SubInput(this.getInput(), l2, l17);
                    IUnit iUnit = this.getUnitProcessor().process("Appended Data", subInput, this);
                    this.addChild(iUnit);
                }
            }
            catch (IOException iOException) {
                KQ.catching(iOException);
            }
        }
        return true;
    }

    private boolean eO(SeekableByteChannel seekableByteChannel) {
        if (this.eO.lS == 0 || this.eO.ae == 0) {
            return false;
        }
        com.pnfsoftware.jeb.corei.parsers.wincoff.ej[] ejArray = new com.pnfsoftware.jeb.corei.parsers.wincoff.ej[this.eO.ae];
        int n = 0;
        try {
            seekableByteChannel.position(this.eO.lS);
            ByteBuffer byteBuffer = ByteBuffer.allocate(18).order(ByteOrder.LITTLE_ENDIAN);
            for (int j = 0; j < ejArray.length; ++j) {
                byteBuffer.rewind();
                if (seekableByteChannel.read(byteBuffer) != 18) {
                    return false;
                }
                byteBuffer.rewind();
                if (n == 0) {
                    com.pnfsoftware.jeb.corei.parsers.wincoff.ej ej2;
                    ejArray[j] = ej2 = com.pnfsoftware.jeb.corei.parsers.wincoff.ej.eO(byteBuffer);
                    n = ej2.gU;
                    String string = this.eO(ejArray[j].qo);
                    if (ej2.DA != 776 || ej2.aO != 3 && ej2.aO != 2 || ej2.Kg <= 0) continue;
                    ISegmentInformation iSegmentInformation = this.getSegment(ej2.Kg);
                    SymbolInformation symbolInformation = new SymbolInformation(SymbolType.UNKNOWN, 0, 0L, string, 0L, iSegmentInformation.getOffsetInMemory() + (long)ej2.kZ, 1L);
                    this.addSymbol(symbolInformation);
                    continue;
                }
                --n;
                KQ.i("Auxiliary record", new Object[0]);
            }
        }
        catch (Exception exception) {
            this.logError(true, "Golang COFF symbol parsing failed (%s)", exception.toString());
            JebCoreService.notifySilentExceptionToClient(exception);
            return false;
        }
        return true;
    }

    private String eO(byte[] byArray) {
        String string;
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            int n = EndianUtil.littleEndianBytesToInt(byArray, 4);
            string = this.eO(n);
        } else {
            try {
                int n;
                for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
                }
                string = Strings.decodeASCII(byArray, 0, n);
            }
            catch (Exception exception) {
                string = "";
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String eO(int n) {
        String string = null;
        try (SeekableByteChannel seekableByteChannel = this.getInput().getChannel();){
            seekableByteChannel.position(this.eO.lS + this.eO.ae * 18 + n);
            int n2 = 1;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            if (seekableByteChannel.read(byteBuffer) == -1) {
                String string2 = null;
                return string2;
            }
            byte[] byArray = byteBuffer.array();
            while (byArray[byArray.length - 1] != 0) {
                byteBuffer = ByteBuffer.allocate(++n2);
                seekableByteChannel.position(this.eO.lS + this.eO.ae * 18 + n);
                if (seekableByteChannel.read(byteBuffer) == -1) {
                    String string3 = null;
                    return string3;
                }
                byArray = byteBuffer.array();
            }
            if (byArray.length == 1) {
                String string4 = "";
                return string4;
            }
            string = Strings.decodeASCII(byArray, 0, n2 - 1);
            return string;
        }
        catch (IOException iOException) {
            KQ.i("Problem with COFF strings table: %s", iOException);
        }
        return string;
    }

    private static String eO(ej ej2) {
        switch (ej2.eO) {
            case 332: {
                return "x86";
            }
            case 34404: {
                return "x86_64";
            }
            case 448: 
            case 450: 
            case 452: {
                return "arm";
            }
            case 43620: {
                return "arm64";
            }
            case 352: 
            case 354: 
            case 358: 
            case 360: 
            case 361: 
            case 870: {
                return "mips";
            }
        }
        return null;
    }

    private void eO() throws MemoryException {
        if (this.Le.BQ.length <= 1) {
            return;
        }
        if (this.Le.BQ[1].Qx == 0L) {
            return;
        }
        IVirtualMemory iVirtualMemory = this.getRawMemoryMappedImage();
        ArrayList<SymbolInformation> arrayList = new ArrayList<SymbolInformation>();
        long l2 = this.Le.XV;
        long l3 = this.eO(l2, this.Le.BQ[1].Qx);
        if (!this.Le(l3)) {
            return;
        }
        HashMap<String, SymbolInformation> hashMap = new HashMap<String, SymbolInformation>();
        while (true) {
            long l4;
            long l5 = iVirtualMemory.readLEInt(l3);
            int n = iVirtualMemory.readLEInt(l3 + 4L);
            int n2 = iVirtualMemory.readLEInt(l3 + 8L);
            long l6 = (long)iVirtualMemory.readLEInt(l3 + 12L) & 0xFFFFFFFFL;
            if (l6 == 0L || (l4 = (long)iVirtualMemory.readLEInt(l3 + 16L) & 0xFFFFFFFFL) == 0L) break;
            boolean bl2 = l5 != 0L && iVirtualMemory.check(l2 + l5, 1, 1) != 0;
            String string = this.eO(iVirtualMemory, l2 + l6);
            ZK zK2 = wA.eO(string);
            KQ.i("Imports for library: \"%s\"", Strings.truncate(string, 100));
            int n3 = this.lS ? 8 : 4;
            long l7 = this.lS ? Long.MIN_VALUE : 0x80000000L;
            while (true) {
                int n4;
                long l8 = 0L;
                if (bl2) {
                    l8 = this.lS ? iVirtualMemory.readLELong(l2 + l5) : (long)iVirtualMemory.readLEInt(l2 + l5) & 0xFFFFFFFFL;
                } else {
                    long l9 = l8 = this.lS ? iVirtualMemory.readLELong(l2 + l4) : (long)iVirtualMemory.readLEInt(l2 + l4) & 0xFFFFFFFFL;
                }
                if (l8 == 0L) break;
                String string2 = null;
                if ((l8 & l7) != 0L) {
                    n4 = (int)l8 & 0xFFFF;
                    if (zK2 != null) {
                        string2 = zK2.eO(n4);
                    }
                    if (string2 == null) {
                        string2 = "#" + n4;
                    }
                } else {
                    n4 = iVirtualMemory.readLEShort(l2 + l8) & 0xFFFF;
                    string2 = this.eO(iVirtualMemory, l2 + l8 + 2L);
                }
                KQ.i("  Function #%d: \"%s\"", n4, Strings.truncate(string2, 100));
                String string3 = string + "!" + string2;
                SymbolInformation symbolInformation = new SymbolInformation(SymbolType.PTRFUNCTION, 1, n4, string3, 0L, l4, n3);
                arrayList.add(symbolInformation);
                hashMap.put(string3, symbolInformation);
                l5 += (long)n3;
                l4 += (long)n3;
            }
            l3 += 20L;
        }
        this.TI = this.Le.BQ[1].lS >= 40L && hashMap.containsKey("mscoree.dll!_CorExeMain");
        this.addAllSymbols(arrayList);
    }

    private void Le() throws MemoryException {
        if (this.Le.BQ.length <= 0) {
            return;
        }
        if (this.Le.BQ[0].Qx == 0L) {
            return;
        }
        IVirtualMemory iVirtualMemory = this.getRawMemoryMappedImage();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l2 = this.Le.XV;
        long l3 = this.eO(l2, this.Le.BQ[0].Qx);
        if (!this.Le(l3)) {
            return;
        }
        long l4 = this.Le.BQ[0].Qx;
        long l5 = l4 + this.Le.BQ[0].lS;
        int n = iVirtualMemory.readLEInt(l3);
        int n2 = iVirtualMemory.readLEInt(l3 + 4L);
        int n3 = iVirtualMemory.readLEShort(l3 + 8L) & 0xFFFF;
        int n4 = iVirtualMemory.readLEShort(l3 + 10L) & 0xFFFF;
        long l6 = (long)iVirtualMemory.readLEInt(l3 + 12L) & 0xFFFFFFFFL;
        int n5 = iVirtualMemory.readLEInt(l3 + 16L) & 0xFFFF;
        int n6 = iVirtualMemory.readLEInt(l3 + 20L);
        int n7 = iVirtualMemory.readLEInt(l3 + 24L);
        long l7 = (long)iVirtualMemory.readLEInt(l3 + 28L) & 0xFFFFFFFFL;
        long l8 = (long)iVirtualMemory.readLEInt(l3 + 32L) & 0xFFFFFFFFL;
        long l9 = (long)iVirtualMemory.readLEInt(l3 + 36L) & 0xFFFFFFFFL;
        String string = null;
        if (l6 != 0L) {
            string = this.eO(iVirtualMemory, l2 + l6);
        }
        KQ.i("Exports for library: \"%s\"", Strings.truncate(Strings.safe(string, "-"), 100));
        while (n6 > 0) {
            Object object;
            long l10 = (long)iVirtualMemory.readLEInt(l2 + l7) & 0xFFFFFFFFL;
            SymbolType symbolType = SymbolType.FUNCTION_MAYBE;
            if (l10 >= l4 && l10 < l5) {
                object = this.eO(iVirtualMemory, l2 + l10);
                symbolType = SymbolType.FORWARDED_FUNCTION;
            }
            object = new SymbolInformation(symbolType, 2, 0L, null, 0L, l10, 0L);
            arrayList.add(object);
            l7 += 4L;
            --n6;
        }
        String string2 = "";
        boolean bl2 = true;
        while (n7 > 0) {
            int n8 = iVirtualMemory.readLEShort(l2 + l9) & 0xFFFF;
            l9 += 2L;
            int n9 = n5 + n8;
            long l11 = (long)iVirtualMemory.readLEInt(l2 + l8) & 0xFFFFFFFFL;
            l8 += 4L;
            String string3 = this.eO(iVirtualMemory, l2 + l11);
            if (bl2 && string3.compareTo(string2) < 0) {
                bl2 = false;
            }
            if (n8 < arrayList.size()) {
                SymbolInformation symbolInformation = (SymbolInformation)arrayList.get(n8);
                symbolInformation.setName(string3);
                symbolInformation.setIdentifier(n9);
            }
            string2 = string3;
            --n7;
        }
        if (!bl2) {
            this.addNotification(new UnitNotification(NotificationType.ERROR, "PE export names are out of order"));
        }
        this.addAllSymbols(arrayList);
    }

    private void Qx() throws MemoryException {
        long l2;
        if (this.Le.BQ.length < 10) {
            return;
        }
        OI oI = this.Le.BQ[9];
        if (oI.Qx == 0L) {
            return;
        }
        IVirtualMemory iVirtualMemory = this.getRawMemoryMappedImage();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        long l3 = this.Le.XV;
        long l4 = this.eO(l3, oI.Qx);
        if (!this.Le(l4)) {
            return;
        }
        if (this.lS) {
            if ((l4 = iVirtualMemory.readLELong(l4 + 24L)) != 0L) {
                while ((l2 = iVirtualMemory.readLELong(l4)) != 0L) {
                    arrayList.add((int)(l2 - l3));
                    l4 += 8L;
                }
            }
        } else if ((l4 = (long)iVirtualMemory.readLEInt(l4 + 12L) & 0xFFFFFFFFL) != 0L) {
            while ((l2 = (long)iVirtualMemory.readLEInt(l4) & 0xFFFFFFFFL) != 0L) {
                arrayList.add((int)(l2 - l3));
                l4 += 4L;
            }
        }
        ArrayList<SymbolInformation> arrayList2 = new ArrayList<SymbolInformation>();
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            String string = "__tls_callback_" + n;
            SymbolInformation symbolInformation = new SymbolInformation(SymbolType.FUNCTION, 2, 0L, string, 0L, n2, 0L);
            arrayList2.add(symbolInformation);
            ++n;
        }
        this.addAllSymbols(arrayList2);
    }

    private void lS() throws MemoryException {
        of of2 = new of(this.getRawMemoryMappedImage(), this.Le.XV);
        if (of2.eO()) {
            IUnit iUnit = this.getUnitProcessor().process("Rich header", new BytesInput(Strings.encodeUTF8(of2.toString())), this);
            this.addChild(iUnit);
        }
    }

    private String eO(IVirtualMemory iVirtualMemory, long l2) {
        int n;
        int n2 = 256;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        block2: while ((n = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2 + (long)n4, byArray.length - n4, byArray, n4, 1)) != -1) {
            n3 += n;
            while (n4 < n3) {
                if (byArray[n4] == 0) break block2;
                ++n4;
            }
            if (n3 != byArray.length) break;
            byArray = Arrays.copyOf(byArray, n2 *= 2);
        }
        try {
            return new String(byArray, 0, n4, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            KQ.catching(unsupportedEncodingException);
            return "";
        }
    }

    private int Le(int n) {
        int n2 = 0;
        n2 |= (n & 0x40000000) != 0 ? 2 : 0;
        n2 |= (n & Integer.MIN_VALUE) != 0 ? 1 : 0;
        return n2 |= (n & 0x20000000) != 0 ? 4 : 0;
    }

    private ProcessorType Qx(int n) {
        switch (n) {
            case 332: {
                return ProcessorType.X86;
            }
            case 34404: {
                return ProcessorType.X86_64;
            }
            case 448: 
            case 450: 
            case 452: {
                return ProcessorType.ARM;
            }
            case 43620: {
                return ProcessorType.ARM64;
            }
            case 354: 
            case 358: 
            case 360: 
            case 361: 
            case 870: {
                return ProcessorType.MIPS;
            }
            case 352: {
                return ProcessorType.MIPS;
            }
        }
        return null;
    }

    private Endianness lS(int n) {
        switch (n) {
            case 352: {
                return Endianness.BIG_ENDIAN;
            }
        }
        return Endianness.LITTLE_ENDIAN;
    }

    private SubsystemType ae(int n) {
        switch (n) {
            case 8: {
                return SubsystemType.WINDOWS_KERNEL;
            }
            case 2: 
            case 3: {
                return SubsystemType.WINDOWS_USER;
            }
        }
        return null;
    }

    public long eO(long l2, long l3) {
        return this.eO(l2 + l3);
    }

    public long eO(long l2) {
        return this.lS ? l2 : l2 & 0xFFFFFFFFL;
    }

    public boolean Le(long l2) {
        return l2 >= this.Le.XV && l2 < this.eO(this.Le.XV, this.Le.hd);
    }

    @Override
    public long convertFileOffsetToRelativeAddress(long l2) {
        for (Rf rf2 : this.Qx) {
            if (l2 < rf2.ae || l2 > rf2.ae + rf2.lS) continue;
            return rf2.Qx + (l2 - rf2.ae);
        }
        return -1L;
    }

    @Override
    public long convertRelativeAddressToFileOffset(long l2) {
        for (Rf rf2 : this.Qx) {
            if (l2 < rf2.Qx || l2 >= rf2.Qx + rf2.Le) continue;
            return rf2.ae + (l2 - rf2.Qx);
        }
        return -1L;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        if (this.isProcessed()) {
            stringBuilder.append("\nNotes:\n");
            if (this.lS) {
                stringBuilder.append("- This is a 64-bit PE file\n");
            }
            if (this.vT) {
                stringBuilder.append("- This PE file contains appended data (unmapped)\n");
            }
            if (this.TI) {
                stringBuilder.append("- This PE file is a .NET executable\n");
            }
            if (this.ae) {
                stringBuilder.append("- This PE file has low-alignment values\n");
            }
            if (this.Le.kZ >= 10) {
                stringBuilder.append(String.format("- The raw timeDateStamp value is 0x%08X (Win10+: may be a reproducible build id)\n", this.eO.Qx));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter iUnitFormatter = super.getFormatter();
        return iUnitFormatter;
    }

    @Override
    public ICOFFHeader getCOFFHeader() {
        return this.eO;
    }

    @Override
    public IPEOptionalHeader getPEOptionalHeader() {
        return this.Le;
    }

    @Override
    public ICOFFSectionHeader[] getSectionHeaders() {
        return this.Qx;
    }

    @Override
    protected boolean shouldAllocateFullImage() {
        return true;
    }

    @Override
    protected boolean applyRelocations(IVirtualMemory iVirtualMemory, long l2) {
        if (this.Le.BQ.length < 5) {
            return true;
        }
        OI oI = this.Le.BQ[5];
        if (oI.Qx == 0L || oI.lS == 0L) {
            return true;
        }
        long l3 = this.Le.XV;
        long l4 = l2 - l3;
        if (l4 == 0L) {
            return true;
        }
        int n = (int)l4;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        try {
            int n2;
            long l5 = l2 + oI.Qx;
            for (long j = oI.lS; j >= 8L; j -= (long)n2) {
                int n3 = iVirtualMemory.readInt(l5);
                n2 = iVirtualMemory.readInt(l5 + 4L);
                if (j < (long)n2 || n2 < 8) {
                    throw new JebRuntimeException(String.format("Bad BaseRelocation block at RVA 0x%X", l5 - l2));
                }
                long l6 = l2 + ((long)n3 & 0xFFFFFFFFL);
                byte[] byArray = new byte[(n2 - 8) / 2 * 2];
                iVirtualMemory.read(l5 + 8L, byArray.length, byArray, 0);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int n4 = byArray.length / 2;
                block9: while (n4-- > 0) {
                    int n5 = byteBuffer.getShort() & 0xFFFF;
                    int n6 = n5 >>> 12;
                    int n7 = n5 & 0xFFF;
                    long l7 = l6 + (long)n7;
                    switch (n6) {
                        case 0: {
                            continue block9;
                        }
                        case 1: {
                            Io.Le(iVirtualMemory, l7, n);
                            continue block9;
                        }
                        case 2: {
                            Io.eO(iVirtualMemory, l7, n);
                            continue block9;
                        }
                        case 3: {
                            Io.Qx(iVirtualMemory, l7, n);
                            continue block9;
                        }
                    }
                    hashSet.add(n6);
                }
                l5 += (long)n2;
            }
            if (!hashSet.isEmpty()) {
                throw new JebRuntimeException("Unsupported relocation types: " + hashSet);
            }
            return true;
        }
        catch (Exception exception) {
            JebRuntimeException jebRuntimeException = new JebRuntimeException("Cannot apply relocations", exception);
            JebCoreService.notifySilentExceptionToClient(jebRuntimeException);
            return false;
        }
    }

    private static void eO(IVirtualMemory iVirtualMemory, long l2, int n) throws MemoryException {
        iVirtualMemory.writeShort(l2, (short)(iVirtualMemory.readShort(l2) + (n & 0xFFFF)));
    }

    private static void Le(IVirtualMemory iVirtualMemory, long l2, int n) throws MemoryException {
        iVirtualMemory.writeShort(l2, (short)(iVirtualMemory.readShort(l2) + (n >>> 16)));
    }

    private static void Qx(IVirtualMemory iVirtualMemory, long l2, int n) throws MemoryException {
        iVirtualMemory.writeInt(l2, iVirtualMemory.readInt(l2) + n);
    }
}

