/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.cert;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.ICertificateUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.cert.pX;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.encoding.Base64;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;

@Ser
public class ej
extends AbstractBinaryUnit
implements ICertificateUnit {
    private static final ILogger eO = GlobalLog.getLogger(ej.class);
    private static final String Le = "-----BEGIN CERTIFICATE-----";
    private static final String Qx = "-----END CERTIFICATE-----";
    private static final byte[] lS = Strings.encodeASCII("-----BEGIN CERTIFICATE-----");
    @SerId(value=1)
    private String ae;
    @SerTransient
    private Certificate TI;

    public ej(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, "cert", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    public boolean isProcessed() {
        return super.isProcessed() && this.TI != null;
    }

    @Override
    protected boolean processInternal() {
        byte[] byArray;
        Object object;
        Object object2;
        try {
            object2 = this.getInput().getStream();
            object = null;
            try {
                byArray = IO.readInputStream((InputStream)object2);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray.length >= lS.length && ArrayUtil.compareBytes(byArray, 0, lS, 0, lS.length) == 0) {
            object2 = Strings.decodeASCII(byArray);
            if (((String)(object2 = Strings.trim((String)object2))).endsWith(Qx)) {
                object2 = ((String)object2).substring(Le.length(), ((String)object2).length() - Qx.length());
                object2 = Strings.trim((String)object2);
                object2 = Strings.replaceNewLines(((String)object2).trim(), "");
                try {
                    byArray = Base64.decode((String)object2);
                }
                catch (IOException iOException) {
                    eO.catchingSilent(iOException);
                }
            }
        }
        try {
            object2 = CertificateFactory.getInstance("X.509");
            object = new ByteArrayInputStream(byArray);
            this.TI = ((CertificateFactory)object2).generateCertificate((InputStream)object);
        }
        catch (CertificateException certificateException) {
            eO.catchingSilent(certificateException);
            return false;
        }
        this.ae = this.eO(this.TI);
        return true;
    }

    @Override
    public String getDescription() {
        String string = super.getDescription();
        return string + "- Human-readable dump:\n" + this.ae;
    }

    private String eO(Certificate certificate) {
        String string;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Type: %s\n", certificate.getType()));
        if (certificate instanceof X509Certificate) {
            object = (X509Certificate)certificate;
            string = String.format("Version: %d\nSerial Number: 0x%s\nIssuer: %s\nValidity: from = %s\n            to = %s\nSubject: %s\n\nPublic Key:\n%s\nSignature:\n  type = %s, OID = %s\n  hexdata = %s\n", ((X509Certificate)object).getVersion(), ((X509Certificate)object).getSerialNumber().toString(16), ((X509Certificate)object).getIssuerDN(), ((X509Certificate)object).getNotBefore(), ((X509Certificate)object).getNotAfter(), ((X509Certificate)object).getSubjectDN(), this.eO(((Certificate)object).getPublicKey()), ((X509Certificate)object).getSigAlgName(), ((X509Certificate)object).getSigAlgOID(), Formatter.formatBinaryLine(((X509Certificate)object).getSignature()));
            stringBuilder.append(string);
        } else {
            stringBuilder.append(certificate.toString());
        }
        object = null;
        try {
            object = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        if (object != null) {
            string = Formatter.formatBinaryLine(Hash.calculateMD5((byte[])object));
            String string2 = Formatter.formatBinaryLine(Hash.calculateSHA1((byte[])object));
            String string3 = Formatter.formatBinaryLine(Hash.calculateSHA256((byte[])object));
            stringBuilder.append(String.format("\nMD5 Fingerprint: %s\nSHA-1 Fingerprint: %s\nSHA-256 Fingerprint: %s\n", string, string2, string3));
        }
        return stringBuilder.toString();
    }

    private String eO(PublicKey publicKey) {
        StringBuilder stringBuilder = new StringBuilder();
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            stringBuilder.append(String.format("  type = %s %d bits\n  exponent = %s\n  modulus = %s", rSAPublicKey.getAlgorithm(), rSAPublicKey.getModulus().bitLength(), rSAPublicKey.getPublicExponent(), rSAPublicKey.getModulus()));
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            stringBuilder.append(String.format("  type = %s %d bits\n  y = %s\n  g = %s\n  p = %s\n  q = %s", dSAPublicKey.getAlgorithm(), dSAPublicKey.getY().bitLength(), dSAPublicKey.getY(), dSAPublicKey.getParams().getG(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ()));
        } else {
            stringBuilder.append(String.format("  %s", publicKey.toString()));
        }
        return stringBuilder.toString();
    }

    @Override
    public Certificate getCertificate() {
        return this.TI;
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter iUnitFormatter = super.getFormatter();
        if (UnitFormatterUtil.getPresentationByIdentifier(iUnitFormatter, 1L) == null) {
            iUnitFormatter.addPresentation(new pX(this, 1L, "Certificate", true), false);
        }
        return iUnitFormatter;
    }
}

