/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk.decoder;

import com.google.common.base.Preconditions;
import com.google.common.io.LittleEndianDataInputStream;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.Ll;
import com.pnfsoftware.jebglobal.Oc;
import com.pnfsoftware.jebglobal.PD;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

@Ser
public class PC
extends AbstractBinaryUnit {
    private static final ILogger eO = GlobalLog.getLogger(PC.class);
    @SerId(value=1)
    private short[] Le;

    public PC(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, "arsc_meta", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    protected boolean processInternal() {
        try (DataInputStream dataInputStream = new DataInputStream(this.getInput().getStream());){
            int n;
            int n2 = dataInputStream.readInt();
            this.Le = new short[n2];
            for (n = 0; n < n2; ++n) {
                this.Le[n] = dataInputStream.readShort();
            }
            n = 0;
            for (short s2 : this.Le) {
                String string = String.format("%c%c", s2 >> 8 & 0xFF, s2 & 0xFF);
                String string2 = String.format("resources-%s.arsc", string);
                eO.i("-> Processing for locale: '%s' (%d)", string, s2);
                try (InputStream inputStream = this.getInput().getStream();){
                    byte[] byArray = PC.eO(inputStream, s2, n);
                    BytesInput bytesInput = new BytesInput(byArray);
                    String string3 = "arsc";
                    IUnit iUnit = this.getUnitProcessor().process(string2, bytesInput, this, string3, true);
                    if (iUnit != null) {
                        this.addChildUnit(iUnit);
                    }
                }
                catch (Exception exception) {
                    this.logException(exception);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            eO.catching(iOException);
            return false;
        }
        return true;
    }

    private static byte[] eO(InputStream inputStream, short s2, int n) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        dataInputStream.skip(n2 * 2);
        Oc oc2 = null;
        for (int j = 0; j < n2; ++j) {
            if (j == n) {
                oc2 = new Oc(dataInputStream);
                Preconditions.checkArgument((s2 == EndianUtil.bigEndianBytesToShort(oc2.lS) ? 1 : 0) != 0);
                continue;
            }
            Oc.eO(dataInputStream);
        }
        Ll ll = Ll.eO(new LittleEndianDataInputStream((InputStream)dataInputStream), null, oc2);
        ((PD)((Object)ll)).Le(false);
        return ll.eO(false);
    }

    @Override
    public String getDescription() {
        String string = super.getDescription();
        string = string + String.format("\nLocalized for %d locales", this.Le.length);
        return string;
    }
}

